/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.metadata.CMManager;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.IoTDBException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.SFWOperator;
import org.apache.iotdb.db.qp.logical.sys.LoadConfigurationOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.LoadConfigurationPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterPhysicalGenerator
extends PhysicalGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ClusterPhysicalGenerator.class);

    private CMManager getCMManager() {
        return (CMManager)IoTDB.metaManager;
    }

    protected Pair<List<TSDataType>, List<TSDataType>> getSeriesTypes(List<PartialPath> paths, String aggregation) throws MetadataException {
        return this.getCMManager().getSeriesTypesByPaths(paths, aggregation);
    }

    protected List<TSDataType> getSeriesTypes(List<PartialPath> paths) throws MetadataException {
        return (List)this.getCMManager().getSeriesTypesByPaths(paths, null).left;
    }

    protected List<PartialPath> getMatchedTimeseries(PartialPath path) throws MetadataException {
        return this.getCMManager().getMatchedPaths(path);
    }

    protected Set<PartialPath> getMatchedDevices(PartialPath path) throws MetadataException {
        return this.getCMManager().getMatchedDevices(path);
    }

    public PhysicalPlan transformToPhysicalPlan(Operator operator, int fetchSize) throws QueryProcessException {
        if (operator instanceof SFWOperator) {
            try {
                this.getCMManager().syncMetaLeader();
            }
            catch (MetadataException e) {
                throw new QueryProcessException((IoTDBException)e);
            }
        }
        return super.transformToPhysicalPlan(operator, fetchSize);
    }

    protected PhysicalPlan generateLoadConfigurationPlan(LoadConfigurationOperator.LoadConfigurationOperatorType type) throws QueryProcessException {
        if (type == LoadConfigurationOperator.LoadConfigurationOperatorType.GLOBAL) {
            Properties[] properties = new Properties[2];
            properties[0] = new Properties();
            URL iotdbEnginePropertiesUrl = IoTDBDescriptor.getInstance().getPropsUrl();
            if (iotdbEnginePropertiesUrl == null) {
                logger.error("Fail to find the engine config file");
                throw new QueryProcessException("Fail to find config file");
            }
            try (InputStream inputStream = iotdbEnginePropertiesUrl.openStream();){
                properties[0].load(inputStream);
            }
            catch (IOException e) {
                logger.error("Fail to read iotdb-engine config file {}", (Object)iotdbEnginePropertiesUrl, (Object)e);
                throw new QueryProcessException("Fail to read iotdb-engine config file.");
            }
            String clusterPropertiesUrl = ClusterDescriptor.getInstance().getPropsUrl();
            properties[1] = new Properties();
            try (FileInputStream inputStream = new FileInputStream(new File(clusterPropertiesUrl));){
                properties[1].load(inputStream);
            }
            catch (IOException e) {
                logger.error("Fail to read iotdb-cluster config file {}", (Object)clusterPropertiesUrl, (Object)e);
                throw new QueryProcessException("Fail to read iotdb-cluster config file.");
            }
            return new LoadConfigurationPlan(LoadConfigurationPlan.LoadConfigurationPlanType.GLOBAL, properties);
        }
        return new LoadConfigurationPlan(LoadConfigurationPlan.LoadConfigurationPlanType.LOCAL);
    }
}

