/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.metadata;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.client.sync.SyncClientAdaptor;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.coordinator.Coordinator;
import org.apache.iotdb.cluster.exception.CheckConsistencyException;
import org.apache.iotdb.cluster.exception.UnsupportedPlanException;
import org.apache.iotdb.cluster.metadata.MetaPuller;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.query.ClusterPlanExecutor;
import org.apache.iotdb.cluster.query.manage.QueryCoordinator;
import org.apache.iotdb.cluster.rpc.thrift.GetAllPathsResult;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.PullSchemaRequest;
import org.apache.iotdb.cluster.rpc.thrift.PullSchemaResp;
import org.apache.iotdb.cluster.server.RaftServer;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.cluster.utils.ClusterUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metadata.MetaUtils;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertMultiTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsOfOneDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateMultiTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowDevicesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.ShowDevicesResult;
import org.apache.iotdb.db.query.dataset.ShowTimeSeriesResult;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EncodingInferenceUtils;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.db.utils.TypeInferenceUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.tsfile.common.cache.LRUCache;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.TimeseriesSchema;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMManager
extends MManager {
    private static final Logger logger = LoggerFactory.getLogger(CMManager.class);
    private ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private RemoteMetaCache mRemoteMetaCache;
    private MetaPuller metaPuller = MetaPuller.getInstance();
    private MetaGroupMember metaGroupMember;
    private Coordinator coordinator;

    private CMManager() {
        int remoteCacheSize = config.getmRemoteSchemaCacheSize();
        this.mRemoteMetaCache = new RemoteMetaCache(remoteCacheSize);
    }

    public static CMManager getInstance() {
        return MManagerHolder.INSTANCE;
    }

    public void syncMetaLeader() throws MetadataException {
        try {
            this.metaGroupMember.syncLeaderWithConsistencyCheck(false);
        }
        catch (CheckConsistencyException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    public String deleteTimeseries(PartialPath prefixPath) throws MetadataException {
        this.cacheLock.writeLock().lock();
        this.mRemoteMetaCache.removeItem(prefixPath);
        this.cacheLock.writeLock().unlock();
        return super.deleteTimeseries(prefixPath);
    }

    public void deleteStorageGroups(List<PartialPath> storageGroups) throws MetadataException {
        this.cacheLock.writeLock().lock();
        for (PartialPath storageGroup : storageGroups) {
            this.mRemoteMetaCache.removeItem(storageGroup);
        }
        this.cacheLock.writeLock().unlock();
        super.deleteStorageGroups(storageGroups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSDataType getSeriesType(PartialPath path) throws MetadataException {
        TSDataType seriesType;
        try {
            this.cacheLock.readLock().lock();
            MeasurementMNode measurementMNode = this.mRemoteMetaCache.get(path);
            if (measurementMNode != null) {
                TSDataType tSDataType = measurementMNode.getSchema().getType();
                return tSDataType;
            }
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        try {
            seriesType = super.getSeriesType(path);
        }
        catch (PathNotExistException e) {
            List<MeasurementSchema> schemas = this.metaPuller.pullMeasurementSchemas(Collections.singletonList(path));
            if (!schemas.isEmpty()) {
                MeasurementSchema measurementSchema = schemas.get(0);
                MeasurementMNode measurementMNode = new MeasurementMNode(null, measurementSchema.getMeasurementId(), measurementSchema, null);
                this.cacheMeta(path, measurementMNode);
                return schemas.get(0).getType();
            }
            throw e;
        }
        return seriesType;
    }

    public MeasurementMNode[] getMNodes(PartialPath deviceId, String[] measurements) throws MetadataException {
        try {
            return super.getMNodes(deviceId, measurements);
        }
        catch (MetadataException e) {
            MeasurementMNode[] measurementMNodes = new MeasurementMNode[measurements.length];
            int failedMeasurementIndex = this.getMNodesLocally(deviceId, measurements, measurementMNodes);
            if (failedMeasurementIndex == -1) {
                return measurementMNodes;
            }
            this.pullSeriesSchemas(deviceId, measurements);
            failedMeasurementIndex = this.getMNodesLocally(deviceId, measurements, measurementMNodes);
            if (failedMeasurementIndex != -1) {
                throw new MetadataException(deviceId.getFullPath() + '.' + measurements[failedMeasurementIndex] + " is not found");
            }
            return measurementMNodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMNodesLocally(PartialPath deviceId, String[] measurements, MeasurementMNode[] measurementMNodes) {
        int failedMeasurementIndex = -1;
        this.cacheLock.readLock().lock();
        try {
            for (int i = 0; i < measurements.length && failedMeasurementIndex == -1; ++i) {
                MeasurementMNode measurementMNode = this.mRemoteMetaCache.get(deviceId.concatNode(measurements[i]));
                if (measurementMNode == null) {
                    failedMeasurementIndex = i;
                    continue;
                }
                measurementMNodes[i] = measurementMNode;
            }
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        return failedMeasurementIndex;
    }

    private void pullSeriesSchemas(PartialPath deviceId, String[] measurementList) throws MetadataException {
        ArrayList<PartialPath> schemasToPull = new ArrayList<PartialPath>();
        for (String s : measurementList) {
            schemasToPull.add(deviceId.concatNode(s));
        }
        List<MeasurementSchema> schemas = this.metaPuller.pullMeasurementSchemas(schemasToPull);
        for (MeasurementSchema schema : schemas) {
            MeasurementMNode measurementMNode = new MeasurementMNode(null, schema.getMeasurementId(), schema, null);
            this.cacheMeta(deviceId.concatNode(schema.getMeasurementId()), measurementMNode);
        }
        logger.debug("Pulled {}/{} schemas from remote", (Object)schemas.size(), (Object)measurementList.length);
    }

    public void cacheMeta(PartialPath seriesPath, MeasurementMNode measurementMNode) {
        this.cacheLock.writeLock().lock();
        this.mRemoteMetaCache.put(seriesPath, measurementMNode);
        this.cacheLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLastCache(PartialPath seriesPath, TimeValuePair timeValuePair, boolean highPriorityUpdate, Long latestFlushedTime, MeasurementMNode node) {
        this.cacheLock.writeLock().lock();
        try {
            MeasurementMNode measurementMNode = this.mRemoteMetaCache.get(seriesPath);
            if (measurementMNode != null) {
                measurementMNode.updateCachedLast(timeValuePair, highPriorityUpdate, latestFlushedTime);
            }
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
        super.updateLastCache(seriesPath, timeValuePair, highPriorityUpdate, latestFlushedTime, node);
    }

    public TimeValuePair getLastCache(PartialPath seriesPath) {
        MeasurementMNode measurementMNode = this.mRemoteMetaCache.get(seriesPath);
        if (measurementMNode != null) {
            return measurementMNode.getCachedLast();
        }
        return super.getLastCache(seriesPath);
    }

    public MNode getSeriesSchemasAndReadLockDevice(InsertPlan plan) throws MetadataException {
        MeasurementMNode[] measurementMNodes = new MeasurementMNode[plan.getMeasurements().length];
        int nonExistSchemaIndex = this.getMNodesLocally(plan.getDeviceId(), plan.getMeasurements(), measurementMNodes);
        if (nonExistSchemaIndex == -1) {
            plan.setMeasurementMNodes(measurementMNodes);
            return new MNode(null, plan.getDeviceId().getDevice());
        }
        return super.getSeriesSchemasAndReadLockDevice(plan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MeasurementSchema getSeriesSchema(PartialPath device, String measurement) throws MetadataException {
        try {
            MeasurementSchema measurementSchema = super.getSeriesSchema(device, measurement);
            if (measurementSchema != null) {
                return measurementSchema;
            }
        }
        catch (PathNotExistException measurementSchema) {
            // empty catch block
        }
        this.cacheLock.readLock().lock();
        try {
            MeasurementMNode measurementMNode = this.mRemoteMetaCache.get(device.concatNode(measurement));
            if (measurementMNode != null) {
                MeasurementSchema measurementSchema = measurementMNode.getSchema();
                return measurementSchema;
            }
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        this.pullSeriesSchemas(device, new String[]{measurement});
        this.cacheLock.readLock().lock();
        try {
            MeasurementMNode measurementMeta = this.mRemoteMetaCache.get(device.concatNode(measurement));
            if (measurementMeta != null) {
                MeasurementSchema measurementSchema = measurementMeta.getSchema();
                return measurementSchema;
            }
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        return super.getSeriesSchema(device, measurement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPathExist(PartialPath path) {
        boolean localExist = super.isPathExist(path);
        if (localExist) {
            return true;
        }
        this.cacheLock.readLock().lock();
        try {
            boolean bl = this.mRemoteMetaCache.containsKey(path);
            return bl;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    public void createSchema(PhysicalPlan plan) throws MetadataException, CheckConsistencyException {
        ArrayList<PartialPath> storageGroups = new ArrayList<PartialPath>();
        if (plan instanceof InsertRowPlan || plan instanceof InsertRowsOfOneDevicePlan || plan instanceof InsertTabletPlan) {
            storageGroups.addAll(this.getStorageGroups(Collections.singletonList(((InsertPlan)plan).getDeviceId())));
        } else if (plan instanceof InsertRowsPlan) {
            storageGroups.addAll(this.getStorageGroups(((InsertRowsPlan)plan).getInsertRowPlanList().stream().map(InsertPlan::getDeviceId).collect(Collectors.toList())));
        } else if (plan instanceof InsertMultiTabletPlan) {
            storageGroups.addAll(this.getStorageGroups(((InsertMultiTabletPlan)plan).getInsertTabletPlanList().stream().map(InsertPlan::getDeviceId).collect(Collectors.toList())));
        } else if (plan instanceof CreateTimeSeriesPlan) {
            storageGroups.addAll(this.getStorageGroups(Collections.singletonList(((CreateTimeSeriesPlan)plan).getPath())));
        } else {
            storageGroups.addAll(this.getStorageGroups(plan.getPaths()));
        }
        this.createStorageGroups(storageGroups);
        this.verifyCreatedSgSuccess(storageGroups, plan);
        if (plan instanceof InsertPlan && !this.createTimeseries((InsertPlan)plan)) {
            throw new MetadataException("Failed to create timeseries from InsertPlan automatically.");
        }
    }

    private List<PartialPath> getStorageGroups(List<PartialPath> paths) throws MetadataException {
        HashSet<PartialPath> storageGroups = new HashSet<PartialPath>();
        for (PartialPath path : paths) {
            storageGroups.add(MetaUtils.getStorageGroupPathByLevel((PartialPath)path, (int)IoTDBDescriptor.getInstance().getConfig().getDefaultStorageGroupLevel()));
        }
        return new ArrayList<PartialPath>(storageGroups);
    }

    private void verifyCreatedSgSuccess(List<PartialPath> storageGroups, PhysicalPlan physicalPlan) {
        long startTime = System.currentTimeMillis();
        boolean[] ready = new boolean[storageGroups.size()];
        Arrays.fill(ready, false);
        while (true) {
            boolean allReady = true;
            for (int i = 0; i < storageGroups.size(); ++i) {
                if (ready[i]) continue;
                if (IoTDB.metaManager.isStorageGroup(storageGroups.get(i))) {
                    ready[i] = true;
                    continue;
                }
                allReady = false;
            }
            if (allReady || System.currentTimeMillis() - startTime > (long)ClusterDescriptor.getInstance().getConfig().getConnectionTimeoutInMS()) break;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                logger.debug("Failed to wait for creating sgs for plan {}", (Object)physicalPlan, (Object)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private void createStorageGroups(List<PartialPath> storageGroups) throws MetadataException {
        for (PartialPath storageGroup : storageGroups) {
            SetStorageGroupPlan setStorageGroupPlan = new SetStorageGroupPlan(storageGroup);
            TSStatus setStorageGroupResult = this.metaGroupMember.processNonPartitionedMetaPlan((PhysicalPlan)setStorageGroupPlan);
            if (setStorageGroupResult.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || setStorageGroupResult.getCode() == TSStatusCode.PATH_ALREADY_EXIST_ERROR.getStatusCode()) continue;
            throw new MetadataException(String.format("Status Code: %d, failed to set storage group %s", setStorageGroupResult.getCode(), storageGroup));
        }
    }

    public boolean createTimeseries(InsertMultiTabletPlan insertMultiTabletPlan) throws CheckConsistencyException, IllegalPathException {
        boolean allSuccess = true;
        for (InsertTabletPlan insertTabletPlan : insertMultiTabletPlan.getInsertTabletPlanList()) {
            boolean success = this.createTimeseries((InsertPlan)insertTabletPlan);
            boolean bl = allSuccess = allSuccess && success;
            if (success) continue;
            logger.error("create timeseries for device={} failed, plan={}", (Object)insertTabletPlan.getDeviceId(), (Object)insertTabletPlan);
        }
        return allSuccess;
    }

    public boolean createTimeseries(InsertRowsPlan insertRowsPlan) throws CheckConsistencyException, IllegalPathException {
        boolean allSuccess = true;
        for (InsertRowPlan insertRowPlan : insertRowsPlan.getInsertRowPlanList()) {
            boolean success = this.createTimeseries((InsertPlan)insertRowPlan);
            boolean bl = allSuccess = allSuccess && success;
            if (success) continue;
            logger.error("create timeseries for device={} failed, plan={}", (Object)insertRowPlan.getDeviceId(), (Object)insertRowPlan);
        }
        return allSuccess;
    }

    public boolean createTimeseries(InsertPlan insertPlan) throws IllegalPathException, CheckConsistencyException {
        PartialPath storageGroupName;
        if (insertPlan instanceof InsertMultiTabletPlan) {
            return this.createTimeseries((InsertMultiTabletPlan)insertPlan);
        }
        if (insertPlan instanceof InsertRowsPlan) {
            return this.createTimeseries((InsertRowsPlan)insertPlan);
        }
        ArrayList<String> seriesList = new ArrayList<String>();
        PartialPath deviceId = insertPlan.getDeviceId();
        try {
            storageGroupName = MetaUtils.getStorageGroupPathByLevel((PartialPath)deviceId, (int)IoTDBDescriptor.getInstance().getConfig().getDefaultStorageGroupLevel());
        }
        catch (MetadataException e) {
            logger.error("Failed to infer storage group from deviceId {}", (Object)deviceId);
            return false;
        }
        for (String measurementId : insertPlan.getMeasurements()) {
            seriesList.add(deviceId.getFullPath() + "." + measurementId);
        }
        PartitionGroup partitionGroup = this.metaGroupMember.getPartitionTable().route(storageGroupName.getFullPath(), 0L);
        List<String> unregisteredSeriesList = this.getUnregisteredSeriesList(seriesList, partitionGroup);
        if (unregisteredSeriesList.isEmpty()) {
            return true;
        }
        logger.debug("Unregisterd series of {} are {}", seriesList, unregisteredSeriesList);
        return this.createTimeseries(unregisteredSeriesList, seriesList, insertPlan);
    }

    private boolean createTimeseries(List<String> unregisteredSeriesList, List<String> seriesList, InsertPlan insertPlan) throws IllegalPathException {
        TSStatus result;
        ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
        ArrayList<CompressionType> compressionTypes = new ArrayList<CompressionType>();
        for (String seriesPath : unregisteredSeriesList) {
            paths.add(new PartialPath(seriesPath));
            int index = seriesList.indexOf(seriesPath);
            TSDataType dataType = insertPlan.getDataTypes() != null && insertPlan.getDataTypes()[index] != null ? insertPlan.getDataTypes()[index] : TypeInferenceUtils.getPredictedDataType((Object)(insertPlan instanceof InsertTabletPlan ? Array.get(((InsertTabletPlan)insertPlan).getColumns()[index], 0) : ((InsertRowPlan)insertPlan).getValues()[index]), (boolean)true);
            dataTypes.add(dataType);
            encodings.add(EncodingInferenceUtils.getDefaultEncoding((TSDataType)dataType));
            compressionTypes.add(TSFileDescriptor.getInstance().getConfig().getCompressor());
        }
        CreateMultiTimeSeriesPlan plan = new CreateMultiTimeSeriesPlan();
        plan.setPaths(paths);
        plan.setDataTypes(dataTypes);
        plan.setEncodings(encodings);
        plan.setCompressors(compressionTypes);
        try {
            result = this.coordinator.processPartitionedPlan((PhysicalPlan)plan);
        }
        catch (UnsupportedPlanException e) {
            logger.error("Failed to create timeseries {} automatically. Unsupported plan exception {} ", paths, (Object)e.getMessage());
            return false;
        }
        if (result.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && result.getCode() != TSStatusCode.PATH_ALREADY_EXIST_ERROR.getStatusCode() && result.getCode() != TSStatusCode.NEED_REDIRECTION.getStatusCode()) {
            logger.error("{} failed to execute create timeseries {}: {}", new Object[]{this.metaGroupMember.getThisNode(), paths, result});
            return false;
        }
        return true;
    }

    public void setMetaGroupMember(MetaGroupMember metaGroupMember) {
        this.metaGroupMember = metaGroupMember;
    }

    public void setCoordinator(Coordinator coordinator) {
        this.coordinator = coordinator;
    }

    private List<String> getUnregisteredSeriesList(List<String> seriesList, PartitionGroup partitionGroup) throws CheckConsistencyException {
        if (partitionGroup.contains(this.metaGroupMember.getThisNode())) {
            return this.getUnregisteredSeriesListLocally(seriesList, partitionGroup);
        }
        return this.getUnregisteredSeriesListRemotely(seriesList, partitionGroup);
    }

    private List<String> getUnregisteredSeriesListLocally(List<String> seriesList, PartitionGroup partitionGroup) throws CheckConsistencyException {
        DataGroupMember dataMember = this.metaGroupMember.getDataClusterServer().getDataMember(partitionGroup.getHeader(), null, null);
        return dataMember.getLocalQueryExecutor().getUnregisteredTimeseries(seriesList);
    }

    private List<String> getUnregisteredSeriesListRemotely(List<String> seriesList, PartitionGroup partitionGroup) {
        for (Node node : partitionGroup) {
            try {
                List result;
                if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
                    AsyncDataClient client = this.metaGroupMember.getClientProvider().getAsyncDataClient(node, RaftServer.getReadOperationTimeoutMS());
                    result = SyncClientAdaptor.getUnregisteredMeasurements(client, partitionGroup.getHeader(), seriesList);
                } else {
                    try (SyncDataClient syncDataClient = this.metaGroupMember.getClientProvider().getSyncDataClient(node, RaftServer.getReadOperationTimeoutMS());){
                        result = syncDataClient.getUnregisteredTimeseries(partitionGroup.getHeader(), seriesList);
                    }
                }
                if (result == null) continue;
                return result;
            }
            catch (IOException | TException e) {
                logger.error("{}: cannot getting unregistered {} and other {} paths from {}", new Object[]{this.metaGroupMember.getName(), seriesList.get(0), seriesList.get(seriesList.size() - 1), node, e});
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("{}: getting unregistered series list {} ... {} is interrupted from {}", new Object[]{this.metaGroupMember.getName(), seriesList.get(0), seriesList.get(seriesList.size() - 1), node, e});
            }
        }
        return Collections.emptyList();
    }

    public void pullTimeSeriesSchemas(List<PartialPath> prefixPaths, Node ignoredGroup) throws MetadataException {
        PartitionGroup partitionGroup;
        logger.debug("{}: Pulling timeseries schemas of {}, ignored group {}", new Object[]{this.metaGroupMember.getName(), prefixPaths, ignoredGroup});
        HashMap<PartitionGroup, List> partitionGroupPathMap = new HashMap<PartitionGroup, List>();
        for (PartialPath partialPath : prefixPaths) {
            if ("time".equalsIgnoreCase(partialPath.getFullPath()) || (partitionGroup = ClusterUtils.partitionByPathTimeWithSync(partialPath, this.metaGroupMember)).getHeader().equals(ignoredGroup)) continue;
            partitionGroupPathMap.computeIfAbsent(partitionGroup, g -> new ArrayList()).add(partialPath.getFullPath());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: pulling schemas of {} and other {} paths from {} groups", new Object[]{this.metaGroupMember.getName(), prefixPaths.get(0), prefixPaths.size() - 1, partitionGroupPathMap.size()});
        }
        for (Map.Entry entry : partitionGroupPathMap.entrySet()) {
            partitionGroup = (PartitionGroup)entry.getKey();
            List paths = (List)entry.getValue();
            this.pullTimeSeriesSchemas(partitionGroup, paths);
        }
    }

    private void pullTimeSeriesSchemas(PartitionGroup partitionGroup, List<String> prefixPaths) {
        if (partitionGroup.contains(this.metaGroupMember.getThisNode())) {
            try {
                this.metaGroupMember.getLocalDataMember(partitionGroup.getHeader(), "Pull timeseries of " + prefixPaths).syncLeader(null);
            }
            catch (CheckConsistencyException e) {
                logger.warn("Failed to check consistency.", (Throwable)e);
            }
            return;
        }
        PullSchemaRequest pullSchemaRequest = new PullSchemaRequest();
        pullSchemaRequest.setHeader(partitionGroup.getHeader());
        pullSchemaRequest.setPrefixPaths(prefixPaths);
        List<Node> nodes = QueryCoordinator.getINSTANCE().reorderNodes(partitionGroup);
        for (Node node : nodes) {
            if (this.tryPullTimeSeriesSchemas(node, pullSchemaRequest)) break;
        }
    }

    private boolean tryPullTimeSeriesSchemas(Node node, PullSchemaRequest request) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Pulling timeseries schemas of {} and other {} paths from {}", new Object[]{this.metaGroupMember.getName(), request.getPrefixPaths().get(0), request.getPrefixPaths().size() - 1, node});
        }
        List<TimeseriesSchema> schemas = null;
        try {
            schemas = this.pullTimeSeriesSchemas(node, request);
        }
        catch (IOException | TException e) {
            logger.error("{}: Cannot pull timeseries schemas of {} and other {} paths from {}", new Object[]{this.metaGroupMember.getName(), request.getPrefixPaths().get(0), request.getPrefixPaths().size() - 1, node, e});
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("{}: Cannot pull timeseries schemas of {} and other {} paths from {}", new Object[]{this.metaGroupMember.getName(), request.getPrefixPaths().get(0), request.getPrefixPaths().size() - 1, node, e});
        }
        if (schemas != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Pulled {} timeseries schemas of {} and other {} paths from {} of {}", new Object[]{this.metaGroupMember.getName(), schemas.size(), request.getPrefixPaths().get(0), request.getPrefixPaths().size() - 1, node, request.getHeader()});
            }
            for (TimeseriesSchema schema : schemas) {
                SchemaUtils.cacheTimeseriesSchema((TimeseriesSchema)schema);
            }
            return true;
        }
        return false;
    }

    private List<TimeseriesSchema> pullTimeSeriesSchemas(Node node, PullSchemaRequest request) throws TException, InterruptedException, IOException {
        List<TimeseriesSchema> schemas;
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            AsyncDataClient client = this.metaGroupMember.getClientProvider().getAsyncDataClient(node, RaftServer.getReadOperationTimeoutMS());
            schemas = SyncClientAdaptor.pullTimeseriesSchema(client, request);
        } else {
            try (SyncDataClient syncDataClient = this.metaGroupMember.getClientProvider().getSyncDataClient(node, RaftServer.getReadOperationTimeoutMS());){
                PullSchemaResp pullSchemaResp = syncDataClient.pullTimeSeriesSchema(request);
                ByteBuffer buffer = pullSchemaResp.schemaBytes;
                int size = buffer.getInt();
                schemas = new ArrayList<TimeseriesSchema>(size);
                for (int i = 0; i < size; ++i) {
                    schemas.add(TimeseriesSchema.deserializeFrom((ByteBuffer)buffer));
                }
            }
        }
        return schemas;
    }

    public Pair<List<TSDataType>, List<TSDataType>> getSeriesTypesByPaths(List<PartialPath> pathStrs, String aggregation) throws MetadataException {
        try {
            return this.getSeriesTypesByPathsLocally(pathStrs, aggregation);
        }
        catch (PathNotExistException e) {
            this.pullTimeSeriesSchemas(pathStrs, null);
            return this.getSeriesTypesByPathsLocally(pathStrs, aggregation);
        }
    }

    private Pair<List<TSDataType>, List<TSDataType>> getSeriesTypesByPathsLocally(List<PartialPath> pathStrs, String aggregation) throws MetadataException {
        List measurementDataTypes = SchemaUtils.getSeriesTypesByPaths(pathStrs, (String)null);
        if (aggregation == null) {
            return new Pair((Object)measurementDataTypes, (Object)measurementDataTypes);
        }
        List columnDataTypes = SchemaUtils.getAggregatedDataTypes((List)measurementDataTypes, (String)aggregation);
        return new Pair((Object)columnDataTypes, (Object)measurementDataTypes);
    }

    public Pair<List<TSDataType>, List<TSDataType>> getSeriesTypesByPath(List<PartialPath> paths, List<String> aggregations) throws MetadataException {
        try {
            return this.getSeriesTypesByPathLocally(paths, aggregations);
        }
        catch (PathNotExistException e) {
            return this.getSeriesTypesByPathRemotely(paths, aggregations);
        }
    }

    private Pair<List<TSDataType>, List<TSDataType>> getSeriesTypesByPathLocally(List<PartialPath> paths, List<String> aggregations) throws MetadataException {
        List measurementDataTypes = SchemaUtils.getSeriesTypesByPaths(paths);
        if (aggregations == null) {
            return new Pair((Object)measurementDataTypes, (Object)measurementDataTypes);
        }
        List columnDataTypes = SchemaUtils.getSeriesTypesByPaths(paths, aggregations);
        return new Pair((Object)columnDataTypes, (Object)measurementDataTypes);
    }

    private Pair<List<TSDataType>, List<TSDataType>> getSeriesTypesByPathRemotely(List<PartialPath> paths, List<String> aggregations) throws MetadataException {
        this.pullTimeSeriesSchemas(paths, null);
        return this.getSeriesTypesByPathLocally(paths, aggregations);
    }

    public Set<PartialPath> getMatchedDevices(PartialPath originPath) throws MetadataException {
        Map sgPathMap = this.determineStorageGroup(originPath);
        Set<PartialPath> ret = this.getMatchedDevices(sgPathMap);
        logger.debug("The devices of path {} are {}", (Object)originPath, ret);
        return ret;
    }

    private List<PartialPath> getMatchedPaths(Map<String, String> sgPathMap, boolean withAlias) throws MetadataException {
        ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        HashMap<PartitionGroup, List> groupPathMap = new HashMap<PartitionGroup, List>();
        for (Map.Entry<String, String> entry : sgPathMap.entrySet()) {
            String storageGroupName = entry.getKey();
            PartialPath pathUnderSG = new PartialPath(entry.getValue());
            PartitionGroup partitionGroup = this.metaGroupMember.getPartitionTable().route(storageGroupName, 0L);
            if (partitionGroup.contains(this.metaGroupMember.getThisNode())) {
                try {
                    this.metaGroupMember.getLocalDataMember(partitionGroup.getHeader()).syncLeader(null);
                }
                catch (CheckConsistencyException e) {
                    logger.warn("Failed to check consistency.", (Throwable)e);
                }
                List<PartialPath> allTimeseriesName = this.getMatchedPathsLocally(pathUnderSG, withAlias);
                logger.debug("{}: get matched paths of {} locally, result {}", new Object[]{this.metaGroupMember.getName(), partitionGroup, allTimeseriesName});
                result.addAll(allTimeseriesName);
                continue;
            }
            groupPathMap.computeIfAbsent(partitionGroup, p -> new ArrayList()).add(pathUnderSG.getFullPath());
        }
        for (Map.Entry<String, String> entry : groupPathMap.entrySet()) {
            PartitionGroup partitionGroup = (PartitionGroup)((Object)entry.getKey());
            List pathsToQuery = (List)((Object)entry.getValue());
            result.addAll(this.getMatchedPaths(partitionGroup, pathsToQuery, withAlias));
        }
        return result;
    }

    private List<PartialPath> getMatchedPathsLocally(PartialPath partialPath, boolean withAlias) throws MetadataException {
        if (!withAlias) {
            return this.getAllTimeseriesPath(partialPath);
        }
        return (List)super.getAllTimeseriesPathWithAlias((PartialPath)partialPath, (int)-1, (int)-1).left;
    }

    private List<PartialPath> getMatchedPaths(PartitionGroup partitionGroup, List<String> pathsToQuery, boolean withAlias) throws MetadataException {
        List<Node> coordinatedNodes = QueryCoordinator.getINSTANCE().reorderNodes(partitionGroup);
        for (Node node : coordinatedNodes) {
            try {
                List<PartialPath> paths = this.getMatchedPaths(node, partitionGroup.getHeader(), pathsToQuery, withAlias);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: get matched paths of {} and other {} paths from {} in {}, result {}", new Object[]{this.metaGroupMember.getName(), pathsToQuery.get(0), pathsToQuery.size() - 1, node, partitionGroup.getHeader(), paths});
                }
                if (paths == null) continue;
                return paths;
            }
            catch (IOException | TException e) {
                throw new MetadataException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new MetadataException((Throwable)e);
            }
        }
        logger.warn("Cannot get paths of {} from {}", pathsToQuery, (Object)partitionGroup);
        return Collections.emptyList();
    }

    private List<PartialPath> getMatchedPaths(Node node, Node header, List<String> pathsToQuery, boolean withAlias) throws IOException, TException, InterruptedException {
        GetAllPathsResult result;
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            AsyncDataClient client = this.metaGroupMember.getClientProvider().getAsyncDataClient(node, RaftServer.getReadOperationTimeoutMS());
            result = SyncClientAdaptor.getAllPaths(client, header, pathsToQuery, withAlias);
        } else {
            try (SyncDataClient syncDataClient = this.metaGroupMember.getClientProvider().getSyncDataClient(node, RaftServer.getReadOperationTimeoutMS());){
                result = syncDataClient.getAllPaths(header, pathsToQuery, withAlias);
            }
        }
        if (result != null) {
            ArrayList<PartialPath> partialPaths = new ArrayList<PartialPath>();
            for (int i = 0; i < result.paths.size(); ++i) {
                try {
                    PartialPath partialPath = new PartialPath((String)result.paths.get(i));
                    if (withAlias) {
                        partialPath.setMeasurementAlias((String)result.aliasList.get(i));
                    }
                    partialPaths.add(partialPath);
                    continue;
                }
                catch (IllegalPathException illegalPathException) {
                    // empty catch block
                }
            }
            return partialPaths;
        }
        return null;
    }

    private Set<PartialPath> getMatchedDevices(Map<String, String> sgPathMap) throws MetadataException {
        HashSet<PartialPath> result = new HashSet<PartialPath>();
        HashMap<PartitionGroup, List> groupPathMap = new HashMap<PartitionGroup, List>();
        for (Map.Entry<String, String> entry : sgPathMap.entrySet()) {
            String storageGroupName = entry.getKey();
            PartialPath pathUnderSG = new PartialPath(entry.getValue());
            PartitionGroup partitionGroup = this.metaGroupMember.getPartitionTable().route(storageGroupName, 0L);
            if (partitionGroup.contains(this.metaGroupMember.getThisNode())) {
                try {
                    this.metaGroupMember.getLocalDataMember(partitionGroup.getHeader()).syncLeader(null);
                }
                catch (CheckConsistencyException e) {
                    logger.warn("Failed to check consistency.", (Throwable)e);
                }
                Set allDevices = this.getDevices(pathUnderSG);
                logger.debug("{}: get matched paths of {} locally, result {}", new Object[]{this.metaGroupMember.getName(), partitionGroup, allDevices});
                result.addAll(allDevices);
                continue;
            }
            groupPathMap.computeIfAbsent(partitionGroup, p -> new ArrayList()).add(pathUnderSG.getFullPath());
        }
        for (Map.Entry<String, String> entry : groupPathMap.entrySet()) {
            PartitionGroup partitionGroup = (PartitionGroup)((Object)entry.getKey());
            List pathsToQuery = (List)((Object)entry.getValue());
            result.addAll(this.getMatchedDevices(partitionGroup, pathsToQuery));
        }
        return result;
    }

    private Set<PartialPath> getMatchedDevices(PartitionGroup partitionGroup, List<String> pathsToQuery) throws MetadataException {
        List<Node> coordinatedNodes = QueryCoordinator.getINSTANCE().reorderNodes(partitionGroup);
        for (Node node : coordinatedNodes) {
            try {
                Set<String> paths = this.getMatchedDevices(node, partitionGroup.getHeader(), pathsToQuery);
                logger.debug("{}: get matched paths of {} from {}, result {} for {}", new Object[]{this.metaGroupMember.getName(), partitionGroup, node, paths, pathsToQuery});
                if (paths == null) continue;
                HashSet<PartialPath> partialPaths = new HashSet<PartialPath>();
                for (String path : paths) {
                    partialPaths.add(new PartialPath(path));
                }
                return partialPaths;
            }
            catch (IOException | TException e) {
                throw new MetadataException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new MetadataException((Throwable)e);
            }
        }
        logger.warn("Cannot get paths of {} from {}", pathsToQuery, (Object)partitionGroup);
        return Collections.emptySet();
    }

    private Set<String> getMatchedDevices(Node node, Node header, List<String> pathsToQuery) throws IOException, TException, InterruptedException {
        Set paths;
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            AsyncDataClient client = this.metaGroupMember.getClientProvider().getAsyncDataClient(node, RaftServer.getReadOperationTimeoutMS());
            paths = SyncClientAdaptor.getAllDevices(client, header, pathsToQuery);
        } else {
            try (SyncDataClient syncDataClient = this.metaGroupMember.getClientProvider().getSyncDataClient(node, RaftServer.getReadOperationTimeoutMS());){
                paths = syncDataClient.getAllDevices(header, pathsToQuery);
            }
        }
        return paths;
    }

    public Pair<List<PartialPath>, Integer> getAllTimeseriesPathWithAlias(PartialPath prefixPath, int limit, int offset) throws MetadataException {
        Map sgPathMap = this.determineStorageGroup(prefixPath);
        List<Object> result = this.getMatchedPaths(sgPathMap, true);
        int skippedOffset = 0;
        if (offset > 0 && result.size() > offset) {
            skippedOffset = offset;
            result = result.subList(offset, result.size());
        } else if (offset > 0) {
            skippedOffset = result.size();
            result = Collections.emptyList();
        }
        if (limit > 0 && result.size() > limit) {
            result = result.subList(0, limit);
        }
        logger.debug("The paths of path {} are {}", (Object)prefixPath, result);
        return new Pair(result, (Object)skippedOffset);
    }

    public List<PartialPath> getMatchedPaths(PartialPath originPath) throws MetadataException {
        Map sgPathMap = this.determineStorageGroup(originPath);
        List<PartialPath> ret = this.getMatchedPaths(sgPathMap, false);
        logger.debug("The paths of path {} are {}", (Object)originPath, ret);
        return ret;
    }

    public Pair<List<PartialPath>, List<PartialPath>> getMatchedPaths(List<PartialPath> originalPaths) {
        ConcurrentSkipListSet fullPaths = new ConcurrentSkipListSet();
        ConcurrentSkipListSet nonExistPaths = new ConcurrentSkipListSet();
        ExecutorService getAllPathsService = Executors.newFixedThreadPool(this.metaGroupMember.getPartitionTable().getGlobalGroups().size());
        for (PartialPath pathStr : originalPaths) {
            getAllPathsService.submit(() -> {
                try {
                    List<PartialPath> fullPathStrs = this.getMatchedPaths(pathStr);
                    if (fullPathStrs.isEmpty()) {
                        nonExistPaths.add(pathStr);
                        logger.debug("Path {} is not found.", (Object)pathStr);
                    } else {
                        fullPaths.addAll(fullPathStrs);
                    }
                }
                catch (MetadataException e) {
                    logger.error("Failed to get full paths of the prefix path: {} because", (Object)pathStr, (Object)e);
                }
            });
        }
        getAllPathsService.shutdown();
        try {
            getAllPathsService.awaitTermination(RaftServer.getReadOperationTimeoutMS(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("Unexpected interruption when waiting for get all paths services to stop", (Throwable)e);
        }
        return new Pair(new ArrayList(fullPaths), new ArrayList(nonExistPaths));
    }

    public List<String> getAllPaths(List<String> paths) throws MetadataException {
        ArrayList<String> ret = new ArrayList<String>();
        for (String path : paths) {
            this.getAllTimeseriesPath(new PartialPath(path)).stream().map(PartialPath::getFullPath).forEach(ret::add);
        }
        return ret;
    }

    public Set<String> getAllDevices(List<String> paths) throws MetadataException {
        HashSet<String> results = new HashSet<String>();
        for (String path : paths) {
            this.getDevices(new PartialPath(path)).stream().map(PartialPath::getFullPath).forEach(results::add);
        }
        return results;
    }

    public List<String> getNodeList(String path, int nodeLevel) throws MetadataException {
        return this.getNodesList(new PartialPath(path), nodeLevel).stream().map(PartialPath::getFullPath).collect(Collectors.toList());
    }

    public Set<String> getChildNodeInNextLevel(String path) throws MetadataException {
        return this.getChildNodeInNextLevel(new PartialPath(path));
    }

    public Set<String> getChildNodePathInNextLevel(String path) throws MetadataException {
        return this.getChildNodePathInNextLevel(new PartialPath(path));
    }

    public void convertToFullPaths(PhysicalPlan plan) throws PathNotExistException, CheckConsistencyException {
        this.metaGroupMember.syncLeaderWithConsistencyCheck(false);
        Pair<List<PartialPath>, List<PartialPath>> getMatchedPathsRet = this.getMatchedPaths(plan.getPaths());
        List fullPaths = (List)getMatchedPathsRet.left;
        List nonExistPath = (List)getMatchedPathsRet.right;
        plan.setPaths(fullPaths);
        if (!nonExistPath.isEmpty()) {
            throw new PathNotExistException(nonExistPath.stream().map(PartialPath::getFullPath).collect(Collectors.toList()));
        }
    }

    public MNode getMNode(MNode deviceMNode, String measurementName) {
        MNode child = deviceMNode.getChild(measurementName);
        if (child == null) {
            child = this.mRemoteMetaCache.get(deviceMNode.getPartialPath().concatNode(measurementName));
        }
        return child;
    }

    public List<ShowTimeSeriesResult> showLocalTimeseries(ShowTimeSeriesPlan plan, QueryContext context) throws MetadataException {
        return super.showTimeseries(plan, context);
    }

    public List<ShowDevicesResult> getLocalDevices(ShowDevicesPlan plan) throws MetadataException {
        return super.getDevices(plan);
    }

    public List<ShowDevicesResult> getDevices(ShowDevicesPlan plan) throws MetadataException {
        ConcurrentSkipListSet<ShowDevicesResult> resultSet = new ConcurrentSkipListSet<ShowDevicesResult>();
        ThreadPoolExecutor pool = new ThreadPoolExecutor(6, 6, 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
        List<PartitionGroup> globalGroups = this.metaGroupMember.getPartitionTable().getGlobalGroups();
        int limit = plan.getLimit() == 0 ? Integer.MAX_VALUE : plan.getLimit();
        int offset = plan.getOffset();
        if (offset != 0) {
            plan.setLimit(0);
            plan.setOffset(0);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Fetch devices schemas of {} from {} groups", (Object)plan.getPath(), (Object)globalGroups.size());
        }
        ArrayList<Future<Void>> futureList = new ArrayList<Future<Void>>();
        for (PartitionGroup group : globalGroups) {
            futureList.add(pool.submit(() -> {
                try {
                    this.getDevices(group, plan, resultSet);
                }
                catch (CheckConsistencyException e) {
                    logger.error("Cannot get show devices result of {} from {}", (Object)plan, (Object)group);
                }
                return null;
            }));
        }
        ClusterPlanExecutor.waitForThreadPool(futureList, pool, "getDevices()");
        List<ShowDevicesResult> showDevicesResults = this.applyShowDevicesLimitOffset(resultSet, limit, offset);
        logger.debug("show devices {} has {} results", (Object)plan.getPath(), (Object)showDevicesResults.size());
        return showDevicesResults;
    }

    public List<ShowTimeSeriesResult> showTimeseries(ShowTimeSeriesPlan plan, QueryContext context) throws MetadataException {
        ConcurrentSkipListSet<ShowTimeSeriesResult> resultSet = new ConcurrentSkipListSet<ShowTimeSeriesResult>();
        ThreadPoolExecutor pool = new ThreadPoolExecutor(6, 6, 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
        List<PartitionGroup> globalGroups = this.metaGroupMember.getPartitionTable().getGlobalGroups();
        int limit = plan.getLimit() == 0 ? Integer.MAX_VALUE : plan.getLimit();
        int offset = plan.getOffset();
        if (offset != 0) {
            plan.setLimit(0);
            plan.setOffset(0);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Fetch timeseries schemas of {} from {} groups", (Object)plan.getPath(), (Object)globalGroups.size());
        }
        ArrayList<Future<Void>> futureList = new ArrayList<Future<Void>>();
        for (PartitionGroup group : globalGroups) {
            futureList.add(pool.submit(() -> {
                try {
                    this.showTimeseries(group, plan, resultSet, context);
                }
                catch (CheckConsistencyException e) {
                    logger.error("Cannot get show timeseries result of {} from {}", (Object)plan, (Object)group);
                }
                return null;
            }));
        }
        ClusterPlanExecutor.waitForThreadPool(futureList, pool, "showTimeseries()");
        List<ShowTimeSeriesResult> showTimeSeriesResults = this.applyShowTimeseriesLimitOffset(resultSet, limit, offset);
        logger.debug("Show {} has {} results", (Object)plan.getPath(), (Object)showTimeSeriesResults.size());
        return showTimeSeriesResults;
    }

    private List<ShowTimeSeriesResult> applyShowTimeseriesLimitOffset(ConcurrentSkipListSet<ShowTimeSeriesResult> resultSet, int limit, int offset) {
        ArrayList<ShowTimeSeriesResult> showTimeSeriesResults = new ArrayList<ShowTimeSeriesResult>();
        Iterator<ShowTimeSeriesResult> iterator = resultSet.iterator();
        while (iterator.hasNext() && limit > 0) {
            if (offset > 0) {
                --offset;
                iterator.next();
                continue;
            }
            --limit;
            showTimeSeriesResults.add(iterator.next());
        }
        return showTimeSeriesResults;
    }

    private List<ShowDevicesResult> applyShowDevicesLimitOffset(Set<ShowDevicesResult> resultSet, int limit, int offset) {
        ArrayList<ShowDevicesResult> showDevicesResults = new ArrayList<ShowDevicesResult>();
        Iterator<ShowDevicesResult> iterator = resultSet.iterator();
        while (iterator.hasNext() && limit > 0) {
            if (offset > 0) {
                --offset;
                iterator.next();
                continue;
            }
            --limit;
            showDevicesResults.add(iterator.next());
        }
        return showDevicesResults;
    }

    private void showTimeseries(PartitionGroup group, ShowTimeSeriesPlan plan, Set<ShowTimeSeriesResult> resultSet, QueryContext context) throws CheckConsistencyException, MetadataException {
        if (group.contains(this.metaGroupMember.getThisNode())) {
            this.showLocalTimeseries(group, plan, resultSet, context);
        } else {
            this.showRemoteTimeseries(group, plan, resultSet);
        }
    }

    private void getDevices(PartitionGroup group, ShowDevicesPlan plan, Set<ShowDevicesResult> resultSet) throws CheckConsistencyException, MetadataException {
        if (group.contains(this.metaGroupMember.getThisNode())) {
            this.getLocalDevices(group, plan, resultSet);
        } else {
            this.getRemoteDevices(group, plan, resultSet);
        }
    }

    private void getLocalDevices(PartitionGroup group, ShowDevicesPlan plan, Set<ShowDevicesResult> resultSet) throws CheckConsistencyException, MetadataException {
        Node header = group.getHeader();
        DataGroupMember localDataMember = this.metaGroupMember.getLocalDataMember(header);
        localDataMember.syncLeaderWithConsistencyCheck(false);
        try {
            List localResult = super.getDevices(plan);
            resultSet.addAll(localResult);
            logger.debug("Fetched {} devices of {} from {}", new Object[]{localResult.size(), plan.getPath(), group});
        }
        catch (MetadataException e) {
            logger.error("Cannot execute show devices plan {} from {} locally.", (Object)plan, (Object)group);
            throw e;
        }
    }

    private void showLocalTimeseries(PartitionGroup group, ShowTimeSeriesPlan plan, Set<ShowTimeSeriesResult> resultSet, QueryContext context) throws CheckConsistencyException, MetadataException {
        Node header = group.getHeader();
        DataGroupMember localDataMember = this.metaGroupMember.getLocalDataMember(header);
        localDataMember.syncLeaderWithConsistencyCheck(false);
        try {
            List localResult = super.showTimeseries(plan, context);
            resultSet.addAll(localResult);
            logger.debug("Fetched local timeseries {} schemas of {} from {}", new Object[]{localResult.size(), plan.getPath(), group});
        }
        catch (MetadataException e) {
            logger.error("Cannot execute show timeseries plan  {} from {} locally.", (Object)plan, (Object)group);
            throw e;
        }
    }

    private void showRemoteTimeseries(PartitionGroup group, ShowTimeSeriesPlan plan, Set<ShowTimeSeriesResult> resultSet) {
        ByteBuffer resultBinary = null;
        for (Node node : group) {
            try {
                resultBinary = this.showRemoteTimeseries(node, group, plan);
                if (resultBinary == null) continue;
                break;
            }
            catch (IOException e) {
                logger.error("Failed to connect to node: {}", (Object)node, (Object)e);
            }
            catch (TException e) {
                logger.error("Error occurs when getting timeseries schemas in node {}.", (Object)node, (Object)e);
            }
            catch (InterruptedException e) {
                logger.error("Interrupted when getting timeseries schemas in node {}.", (Object)node, (Object)e);
                Thread.currentThread().interrupt();
            }
        }
        if (resultBinary != null) {
            int size = resultBinary.getInt();
            logger.debug("Fetched remote timeseries {} schemas of {} from {}", new Object[]{size, plan.getPath(), group});
            for (int i = 0; i < size; ++i) {
                resultSet.add(ShowTimeSeriesResult.deserialize((ByteBuffer)resultBinary));
            }
        } else {
            logger.error("Failed to execute show timeseries {} in group: {}.", (Object)plan, (Object)group);
        }
    }

    private void getRemoteDevices(PartitionGroup group, ShowDevicesPlan plan, Set<ShowDevicesResult> resultSet) {
        ByteBuffer resultBinary = null;
        for (Node node : group) {
            try {
                resultBinary = this.getRemoteDevices(node, group, plan);
                if (resultBinary == null) continue;
                break;
            }
            catch (IOException e) {
                logger.error("Failed to connect to node: {}", (Object)node, (Object)e);
            }
            catch (TException e) {
                logger.error("Error occurs when getting devices schemas in node {}.", (Object)node, (Object)e);
            }
            catch (InterruptedException e) {
                logger.error("Interrupted when getting devices schemas in node {}.", (Object)node, (Object)e);
                Thread.currentThread().interrupt();
            }
        }
        if (resultBinary != null) {
            int size = resultBinary.getInt();
            logger.debug("Fetched remote devices {} schemas of {} from {}", new Object[]{size, plan.getPath(), group});
            for (int i = 0; i < size; ++i) {
                resultSet.add(ShowDevicesResult.deserialize((ByteBuffer)resultBinary));
            }
        } else {
            logger.error("Failed to execute show devices {} in group: {}.", (Object)plan, (Object)group);
        }
    }

    private ByteBuffer showRemoteTimeseries(Node node, PartitionGroup group, ShowTimeSeriesPlan plan) throws IOException, TException, InterruptedException {
        ByteBuffer resultBinary;
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            AsyncDataClient client = this.metaGroupMember.getClientProvider().getAsyncDataClient(node, RaftServer.getReadOperationTimeoutMS());
            resultBinary = SyncClientAdaptor.getAllMeasurementSchema(client, group.getHeader(), plan);
        } else {
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                 DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                 SyncDataClient syncDataClient = this.metaGroupMember.getClientProvider().getSyncDataClient(node, RaftServer.getReadOperationTimeoutMS());){
                plan.serialize(dataOutputStream);
                resultBinary = syncDataClient.getAllMeasurementSchema(group.getHeader(), ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            }
        }
        return resultBinary;
    }

    private ByteBuffer getRemoteDevices(Node node, PartitionGroup group, ShowDevicesPlan plan) throws IOException, TException, InterruptedException {
        ByteBuffer resultBinary;
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            AsyncDataClient client = this.metaGroupMember.getClientProvider().getAsyncDataClient(node, RaftServer.getReadOperationTimeoutMS());
            resultBinary = SyncClientAdaptor.getDevices(client, group.getHeader(), plan);
        } else {
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                 DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                 SyncDataClient syncDataClient = this.metaGroupMember.getClientProvider().getSyncDataClient(node, RaftServer.getReadOperationTimeoutMS());){
                plan.serialize(dataOutputStream);
                resultBinary = syncDataClient.getDevices(group.getHeader(), ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            }
        }
        return resultBinary;
    }

    public GetAllPathsResult getAllPaths(List<String> paths, boolean withAlias) throws MetadataException {
        List<Object> retPaths = new ArrayList();
        ArrayList<String> alias = null;
        if (withAlias) {
            alias = new ArrayList<String>();
        }
        if (withAlias) {
            for (String path : paths) {
                List allTimeseriesPathWithAlias = (List)super.getAllTimeseriesPathWithAlias((PartialPath)new PartialPath((String)path), (int)-1, (int)-1).left;
                for (PartialPath timeseriesPathWithAlias : allTimeseriesPathWithAlias) {
                    retPaths.add(timeseriesPathWithAlias.getFullPath());
                    alias.add(timeseriesPathWithAlias.getMeasurementAlias());
                }
            }
        } else {
            retPaths = this.getAllPaths(paths);
        }
        GetAllPathsResult getAllPathsResult = new GetAllPathsResult();
        getAllPathsResult.setPaths(retPaths);
        getAllPathsResult.setAliasList(alias);
        return getAllPathsResult;
    }

    public PartialPath getStorageGroupPath(PartialPath path) throws StorageGroupNotSetException {
        try {
            return super.getStorageGroupPath(path);
        }
        catch (StorageGroupNotSetException e) {
            try {
                this.metaGroupMember.syncLeader(null);
            }
            catch (CheckConsistencyException ex) {
                logger.warn("Failed to check consistency.", (Throwable)e);
            }
            return super.getStorageGroupPath(path);
        }
    }

    private static class RemoteMetaCache
    extends LRUCache<PartialPath, MeasurementMNode> {
        RemoteMetaCache(int cacheSize) {
            super(cacheSize);
        }

        protected MeasurementMNode loadObjectByKey(PartialPath key) {
            return null;
        }

        public synchronized void removeItem(PartialPath key) {
            this.cache.keySet().removeIf(s -> s.getFullPath().startsWith(key.getFullPath()));
        }

        public synchronized MeasurementMNode get(PartialPath key) {
            try {
                return (MeasurementMNode)super.get((Object)key);
            }
            catch (IOException e) {
                return null;
            }
        }

        public synchronized boolean containsKey(PartialPath key) {
            return this.cache.containsKey(key);
        }
    }

    private static class MManagerHolder {
        private static final CMManager INSTANCE = new CMManager();

        private MManagerHolder() {
        }
    }
}

