/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.catchup;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.cluster.client.sync.SyncClientAdaptor;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.exception.EntryCompactedException;
import org.apache.iotdb.cluster.exception.LeaderUnknownException;
import org.apache.iotdb.cluster.log.Log;
import org.apache.iotdb.cluster.log.Snapshot;
import org.apache.iotdb.cluster.log.catchup.LogCatchUpTask;
import org.apache.iotdb.cluster.log.catchup.SnapshotCatchUpTask;
import org.apache.iotdb.cluster.log.logtypes.EmptyContentLog;
import org.apache.iotdb.cluster.log.manage.RaftLogManager;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.server.NodeCharacter;
import org.apache.iotdb.cluster.server.member.RaftMember;
import org.apache.iotdb.cluster.server.monitor.Peer;
import org.apache.iotdb.cluster.utils.ClientUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatchUpTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CatchUpTask.class);
    private Node node;
    private Peer peer;
    private RaftMember raftMember;
    private Snapshot snapshot;
    private List<Log> logs;
    private long lastLogIndex;
    private boolean abort;
    private String name;

    public CatchUpTask(Node node, Peer peer, RaftMember raftMember, long lastLogIdx) {
        this.node = node;
        this.peer = peer;
        this.raftMember = raftMember;
        this.logs = Collections.emptyList();
        this.snapshot = null;
        this.lastLogIndex = lastLogIdx;
        this.name = raftMember.getName() + "@" + System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkMatchIndex() throws TException, InterruptedException, LeaderUnknownException {
        long newMatchedIndex;
        logger.debug("Checking the match index of {}", (Object)this.node);
        long lo = 0L;
        long hi = 0L;
        long localFirstIndex = 0L;
        try {
            RaftLogManager raftLogManager = this.raftMember.getLogManager();
            synchronized (raftLogManager) {
                localFirstIndex = this.raftMember.getLogManager().getFirstIndex();
                lo = Math.max(localFirstIndex, this.peer.getMatchIndex() + 1L);
                hi = this.raftMember.getLogManager().getLastLogIndex() + 1L;
                this.logs = this.raftMember.getLogManager().getEntries(lo, hi);
            }
            if (logger.isInfoEnabled()) {
                logger.info("{}: use {} logs of [{}, {}] to fix log inconsistency with node [{}], local first index: {}", new Object[]{this.raftMember.getName(), this.logs.size(), lo, hi, this.node, localFirstIndex});
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
        }
        catch (Exception e) {
            logger.error("Unexpected error in logManager's getEntries during matchIndexCheck", (Throwable)e);
        }
        if (this.logs.isEmpty()) {
            return true;
        }
        int index = this.findLastMatchIndex(this.logs);
        if (index == -1) {
            long endIndex;
            logger.info("{}, Cannot find matched of {} within [{}, {}] in memory", new Object[]{this.name, this.node, lo, hi});
            if (!this.judgeUseLogsInDiskToCatchUp()) {
                return false;
            }
            long startIndex = this.peer.getMatchIndex() + 1L;
            List<Log> logsInDisk = this.getLogsInStableEntryManager(startIndex, endIndex = this.raftMember.getLogManager().getCommitLogIndex());
            if (!logsInDisk.isEmpty()) {
                logger.info("{}, found {} logs in disk to catch up {} , startIndex={}, endIndex={}, memoryFirstIndex={}, getFirstLogIndex={}", new Object[]{this.name, logsInDisk.size(), this.node, startIndex, endIndex, localFirstIndex, logsInDisk.get(0).getCurrLogIndex()});
                this.logs = logsInDisk;
                index = this.findLastMatchIndex(this.logs);
                if (index == -1) {
                    return false;
                }
            } else {
                logger.info("{}, Cannot find matched of {} within [{}, {}] in disk", new Object[]{this.name, this.node, startIndex, endIndex});
                return false;
            }
        }
        if ((newMatchedIndex = this.logs.get(index).getCurrLogIndex() - 1L) > this.lastLogIndex) {
            logger.info("{}: matched index of {} has moved beyond last log index, node is self-catching-up, abort this catch up to avoid duplicates", (Object)this.name, (Object)this.node);
            this.abort = true;
            return true;
        }
        logger.info("{}: {} matches at {}", new Object[]{this.name, this.node, newMatchedIndex});
        this.peer.setMatchIndex(newMatchedIndex);
        this.logs.subList(0, index).clear();
        if (logger.isInfoEnabled()) {
            if (this.logs.isEmpty()) {
                logger.info("{}: {} has caught up by previous catch up", (Object)this.name, (Object)this.node);
            } else {
                logger.info("{}: makes {} catch up with {} and other {} logs", new Object[]{this.name, this.node, this.logs.get(0), this.logs.size()});
            }
        }
        return true;
    }

    private boolean judgeUseLogsInDiskToCatchUp() {
        if (!ClusterDescriptor.getInstance().getConfig().isEnableRaftLogPersistence()) {
            return false;
        }
        return ClusterDescriptor.getInstance().getConfig().isEnableUsePersistLogOnDiskToCatchUp();
    }

    private List<Log> getLogsInStableEntryManager(long startIndex, long endIndex) {
        List<Log> logsInDisk = this.raftMember.getLogManager().getStableEntryManager().getLogs(startIndex, endIndex);
        logger.debug("{}, found {} logs in disk to catchup {}, startIndex={}, endIndex={}", new Object[]{this.raftMember.getName(), logsInDisk.size(), this.node, startIndex, endIndex});
        return logsInDisk;
    }

    public int findLastMatchIndex(List<Log> logs) throws LeaderUnknownException, TException, InterruptedException {
        int start = 0;
        int end = logs.size() - 1;
        int matchedIndex = -1;
        while (start <= end) {
            int mid = start + (end - start) / 2;
            if (this.checkMatchIndex(mid)) {
                start = mid + 1;
                matchedIndex = mid;
                continue;
            }
            end = mid - 1;
        }
        return matchedIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkMatchIndex(int index) throws LeaderUnknownException, TException, InterruptedException {
        Log log = this.logs.get(index);
        AtomicLong atomicLong = this.raftMember.getTerm();
        synchronized (atomicLong) {
            if (this.raftMember.getCharacter() != NodeCharacter.LEADER) {
                throw new LeaderUnknownException(this.raftMember.getAllNodes());
            }
        }
        long prevLogIndex = log.getCurrLogIndex() - 1L;
        long prevLogTerm = this.getPrevLogTerm(index);
        if (prevLogTerm == -1L) {
            return prevLogIndex == -1L;
        }
        boolean matched = this.checkLogIsMatch(prevLogIndex, prevLogTerm);
        this.raftMember.getLastCatchUpResponseTime().put(this.node, System.currentTimeMillis());
        logger.info("{} check {}'s matchIndex {} with log [{}]", new Object[]{this.raftMember.getName(), this.node, matched ? "succeed" : "failed", log});
        return matched;
    }

    private boolean checkLogIsMatch(long logIndex, long logTerm) throws TException, InterruptedException {
        boolean matched;
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            RaftService.AsyncClient client = this.raftMember.getAsyncClient(this.node);
            if (client == null) {
                return false;
            }
            Node header = this.raftMember.getHeader();
            matched = SyncClientAdaptor.matchTerm(client, this.node, logIndex, logTerm, header);
        } else {
            RaftService.Client client = this.raftMember.getSyncClient(this.node);
            if (client == null) {
                return false;
            }
            try {
                matched = client.matchTerm(logIndex, logTerm, this.raftMember.getHeader());
            }
            catch (TException e) {
                client.getInputProtocol().getTransport().close();
                throw e;
            }
            finally {
                ClientUtils.putBackSyncClient(client);
            }
        }
        return matched;
    }

    private long getPrevLogTerm(int index) {
        long prevLogTerm = -1L;
        if (index > 0) {
            prevLogTerm = this.logs.get(index - 1).getCurrLogTerm();
        } else {
            try {
                prevLogTerm = this.raftMember.getLogManager().getTerm(this.logs.get(0).getCurrLogIndex() - 1L);
            }
            catch (EntryCompactedException e) {
                logger.info("Log [{}] is compacted during catchup", (Object)(this.logs.get(0).getCurrLogIndex() - 1L));
            }
        }
        return prevLogTerm;
    }

    private void doSnapshot() {
        try {
            this.raftMember.getLogManager().takeSnapshot();
        }
        catch (IOException e) {
            logger.error("Unexpected error when taking snapshot.", (Throwable)e);
        }
        this.snapshot = this.raftMember.getLogManager().getSnapshot(this.peer.getMatchIndex());
        if (logger.isInfoEnabled()) {
            logger.info("{}: Logs in {} are too old, catch up with snapshot", (Object)this.raftMember.getName(), (Object)this.node);
        }
    }

    private void removeSnapshotLogs() {
        EmptyContentLog logToSearch = new EmptyContentLog(this.snapshot.getLastLogIndex(), this.snapshot.getLastLogTerm());
        int pos = Collections.binarySearch(this.logs, logToSearch, Comparator.comparingLong(Log::getCurrLogIndex));
        int prevSize = this.logs.size();
        if (pos >= 0) {
            this.logs.subList(0, pos + 1).clear();
        } else {
            int insertPos = -pos - 1;
            if (insertPos > 0) {
                this.logs.subList(0, insertPos).clear();
            }
        }
        logger.info("Logs are reduced from {} to {}", (Object)prevSize, (Object)this.logs.size());
    }

    @Override
    public void run() {
        try {
            boolean catchUpSucceeded;
            LogCatchUpTask task;
            boolean findMatchedIndex = this.checkMatchIndex();
            if (this.abort) {
                this.peer.resetInconsistentHeartbeatNum();
                this.raftMember.getLastCatchUpResponseTime().remove(this.node);
                return;
            }
            if (!findMatchedIndex) {
                logger.info("{}: performing a snapshot catch-up to {}", (Object)this.raftMember.getName(), (Object)this.node);
                this.doSnapshot();
                this.removeSnapshotLogs();
                task = new SnapshotCatchUpTask(this.logs, this.snapshot, this.node, this.raftMember);
                catchUpSucceeded = ((SnapshotCatchUpTask)task).call();
            } else {
                logger.info("{}: performing a log catch-up to {}", (Object)this.raftMember.getName(), (Object)this.node);
                task = new LogCatchUpTask(this.logs, this.node, this.raftMember);
                catchUpSucceeded = task.call();
            }
            if (catchUpSucceeded) {
                if (!this.logs.isEmpty() || this.snapshot != null) {
                    long lastIndex = !this.logs.isEmpty() ? this.logs.get(this.logs.size() - 1).getCurrLogIndex() : this.snapshot.getLastLogIndex();
                    this.peer.setMatchIndex(lastIndex);
                }
                if (logger.isInfoEnabled()) {
                    logger.info("{}: Catch up {} finished, update it's matchIndex to {}", new Object[]{this.raftMember.getName(), this.node, this.peer.getMatchIndex()});
                }
                this.peer.resetInconsistentHeartbeatNum();
            }
        }
        catch (LeaderUnknownException e) {
            logger.warn("Catch up {} failed because leadership is lost", (Object)this.node);
        }
        catch (Exception e) {
            logger.error("Catch up {} errored", (Object)this.node, (Object)e);
        }
        this.raftMember.getLastCatchUpResponseTime().remove(this.node);
    }

    public void setLogs(List<Log> logs) {
        this.logs = logs;
    }
}

