/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc;

import java.io.IOException;
import org.apache.iotdb.rpc.TCompressedElasticFramedTransport;
import org.apache.iotdb.rpc.TElasticFramedTransport;
import org.apache.thrift.transport.TTransport;
import org.xerial.snappy.Snappy;

public class TSnappyElasticFramedTransport
extends TCompressedElasticFramedTransport {
    public TSnappyElasticFramedTransport(TTransport underlying) {
        this(underlying, 65536, 0x20000000);
    }

    public TSnappyElasticFramedTransport(TTransport underlying, int thriftDefaultBufferSize, int thriftMaxFrameSize) {
        super(underlying, thriftDefaultBufferSize, thriftMaxFrameSize);
    }

    @Override
    protected int uncompressedLength(byte[] buf, int off, int len) throws IOException {
        return Snappy.uncompressedLength((byte[])buf, (int)off, (int)len);
    }

    @Override
    protected int maxCompressedLength(int len) {
        return Snappy.maxCompressedLength((int)len);
    }

    @Override
    protected int compress(byte[] input, int inOff, int len, byte[] output, int outOff) throws IOException {
        return Snappy.compress((byte[])input, (int)inOff, (int)len, (byte[])output, (int)outOff);
    }

    @Override
    protected void uncompress(byte[] input, int inOff, int size, byte[] output, int outOff) throws IOException {
        Snappy.uncompress((byte[])input, (int)inOff, (int)size, (byte[])output, (int)outOff);
    }

    public static class Factory
    extends TElasticFramedTransport.Factory {
        public Factory() {
            this(65536, 0x20000000);
        }

        public Factory(int thriftDefaultBufferSize) {
            this(thriftDefaultBufferSize, 0x20000000);
        }

        public Factory(int thriftDefaultBufferSize, int thriftMaxFrameSize) {
            super(thriftDefaultBufferSize, thriftMaxFrameSize);
        }

        @Override
        public TTransport getTransport(TTransport trans) {
            return new TSnappyElasticFramedTransport(trans, this.thriftDefaultBufferSize, this.thriftMaxFrameSize);
        }
    }
}

