/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.service.rpc.thrift.TSCloseOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsResp;
import org.apache.iotdb.service.rpc.thrift.TSIService;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;

public class IoTDBRpcDataSet {
    public static final String TIMESTAMP_STR = "Time";
    public static final String VALUE_IS_NULL = "The value got by %s (column name) is NULL.";
    public static final int START_INDEX = 2;
    public String sql;
    public boolean isClosed = false;
    public TSIService.Iface client;
    public List<String> columnNameList;
    public List<TSDataType> columnTypeList;
    public Map<String, Integer> columnOrdinalMap;
    public List<TSDataType> columnTypeDeduplicatedList;
    public int fetchSize;
    public final long timeout;
    public boolean emptyResultSet = false;
    public boolean hasCachedRecord = false;
    public boolean lastReadWasNull;
    public byte[][] values;
    public int columnSize;
    public long sessionId;
    public long queryId;
    public long statementId;
    public boolean ignoreTimeStamp;
    public int rowsIndex = 0;
    public TSQueryDataSet tsQueryDataSet = null;
    public byte[] time;
    public byte[] currentBitmap;
    public static final int FLAG = 128;

    public IoTDBRpcDataSet(String sql, List<String> columnNameList, List<String> columnTypeList, Map<String, Integer> columnNameIndex, boolean ignoreTimeStamp, long queryId, long statementId, TSIService.Iface client, long sessionId, TSQueryDataSet queryDataSet, int fetchSize, long timeout) {
        int i;
        this.sessionId = sessionId;
        this.statementId = statementId;
        this.ignoreTimeStamp = ignoreTimeStamp;
        this.sql = sql;
        this.queryId = queryId;
        this.client = client;
        this.fetchSize = fetchSize;
        this.timeout = timeout;
        this.columnSize = columnNameList.size();
        this.columnNameList = new ArrayList<String>();
        this.columnTypeList = new ArrayList<TSDataType>();
        if (!ignoreTimeStamp) {
            this.columnNameList.add(TIMESTAMP_STR);
            this.columnTypeList.add(TSDataType.INT64);
        }
        this.columnOrdinalMap = new HashMap<String, Integer>();
        if (!ignoreTimeStamp) {
            this.columnOrdinalMap.put(TIMESTAMP_STR, 1);
        }
        if (columnNameIndex != null) {
            this.columnTypeDeduplicatedList = new ArrayList<TSDataType>(columnNameIndex.size());
            for (i = 0; i < columnNameIndex.size(); ++i) {
                this.columnTypeDeduplicatedList.add(null);
            }
            for (i = 0; i < columnNameList.size(); ++i) {
                String name = columnNameList.get(i);
                this.columnNameList.add(name);
                this.columnTypeList.add(TSDataType.valueOf((String)columnTypeList.get(i)));
                if (this.columnOrdinalMap.containsKey(name)) continue;
                int index = columnNameIndex.get(name);
                this.columnOrdinalMap.put(name, index + 2);
                this.columnTypeDeduplicatedList.set(index, TSDataType.valueOf((String)columnTypeList.get(i)));
            }
        } else {
            this.columnTypeDeduplicatedList = new ArrayList<TSDataType>();
            int index = 2;
            for (int i2 = 0; i2 < columnNameList.size(); ++i2) {
                String name = columnNameList.get(i2);
                this.columnNameList.add(name);
                this.columnTypeList.add(TSDataType.valueOf((String)columnTypeList.get(i2)));
                if (this.columnOrdinalMap.containsKey(name)) continue;
                this.columnOrdinalMap.put(name, index++);
                this.columnTypeDeduplicatedList.add(TSDataType.valueOf((String)columnTypeList.get(i2)));
            }
        }
        this.time = new byte[8];
        this.currentBitmap = new byte[this.columnTypeDeduplicatedList.size()];
        this.values = new byte[this.columnTypeDeduplicatedList.size()][];
        block11: for (i = 0; i < this.values.length; ++i) {
            TSDataType dataType = this.columnTypeDeduplicatedList.get(i);
            switch (dataType) {
                case BOOLEAN: {
                    this.values[i] = new byte[1];
                    continue block11;
                }
                case INT32: {
                    this.values[i] = new byte[4];
                    continue block11;
                }
                case INT64: {
                    this.values[i] = new byte[8];
                    continue block11;
                }
                case FLOAT: {
                    this.values[i] = new byte[4];
                    continue block11;
                }
                case DOUBLE: {
                    this.values[i] = new byte[8];
                    continue block11;
                }
                case TEXT: {
                    this.values[i] = null;
                    continue block11;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.columnTypeDeduplicatedList.get(i)));
                }
            }
        }
        this.tsQueryDataSet = queryDataSet;
        this.emptyResultSet = queryDataSet == null || !queryDataSet.time.hasRemaining();
    }

    public void close() throws StatementExecutionException, TException {
        if (this.isClosed) {
            return;
        }
        if (this.client != null) {
            try {
                TSCloseOperationReq closeReq = new TSCloseOperationReq(this.sessionId);
                closeReq.setStatementId(this.statementId);
                closeReq.setQueryId(this.queryId);
                TSStatus closeResp = this.client.closeOperation(closeReq);
                RpcUtils.verifySuccess(closeResp);
            }
            catch (StatementExecutionException e) {
                throw new StatementExecutionException("Error occurs for close operation in server side because ", e);
            }
            catch (TException e) {
                throw new TException("Error occurs when connecting to server for close operation ", (Throwable)e);
            }
        }
        this.client = null;
        this.isClosed = true;
    }

    public boolean next() throws StatementExecutionException, IoTDBConnectionException {
        if (this.hasCachedResults()) {
            this.constructOneRow();
            return true;
        }
        if (this.emptyResultSet) {
            return false;
        }
        if (this.fetchResults()) {
            this.constructOneRow();
            return true;
        }
        return false;
    }

    public boolean fetchResults() throws StatementExecutionException, IoTDBConnectionException {
        this.rowsIndex = 0;
        TSFetchResultsReq req = new TSFetchResultsReq(this.sessionId, this.sql, this.fetchSize, this.queryId, true);
        req.setTimeout(this.timeout);
        try {
            TSFetchResultsResp resp = this.client.fetchResults(req);
            RpcUtils.verifySuccess(resp.getStatus());
            if (!resp.hasResultSet) {
                this.emptyResultSet = true;
            } else {
                this.tsQueryDataSet = resp.getQueryDataSet();
            }
            return resp.hasResultSet;
        }
        catch (TException e) {
            throw new IoTDBConnectionException("Cannot fetch result from server, because of network connection: {} ", e);
        }
    }

    public boolean hasCachedResults() {
        return this.tsQueryDataSet != null && this.tsQueryDataSet.time.hasRemaining();
    }

    public void constructOneRow() {
        this.tsQueryDataSet.time.get(this.time);
        block4: for (int i = 0; i < this.tsQueryDataSet.bitmapList.size(); ++i) {
            ByteBuffer bitmapBuffer = (ByteBuffer)this.tsQueryDataSet.bitmapList.get(i);
            if (this.rowsIndex % 8 == 0) {
                this.currentBitmap[i] = bitmapBuffer.get();
            }
            if (this.isNull(i, this.rowsIndex)) continue;
            ByteBuffer valueBuffer = (ByteBuffer)this.tsQueryDataSet.valueList.get(i);
            TSDataType dataType = this.columnTypeDeduplicatedList.get(i);
            switch (dataType) {
                case BOOLEAN: 
                case INT32: 
                case INT64: 
                case FLOAT: 
                case DOUBLE: {
                    valueBuffer.get(this.values[i]);
                    continue block4;
                }
                case TEXT: {
                    int length = valueBuffer.getInt();
                    this.values[i] = ReadWriteIOUtils.readBytes((ByteBuffer)valueBuffer, (int)length);
                    continue block4;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.columnTypeDeduplicatedList.get(i)));
                }
            }
        }
        ++this.rowsIndex;
        this.hasCachedRecord = true;
    }

    public boolean isNull(int columnIndex) throws StatementExecutionException {
        int index = this.columnOrdinalMap.get(this.findColumnNameByIndex(columnIndex)) - 2;
        if (index < 0) {
            return true;
        }
        return this.isNull(index, this.rowsIndex - 1);
    }

    public boolean isNull(String columnName) {
        int index = this.columnOrdinalMap.get(columnName) - 2;
        if (index < 0) {
            return true;
        }
        return this.isNull(index, this.rowsIndex - 1);
    }

    private boolean isNull(int index, int rowNum) {
        int shift = rowNum % 8;
        byte bitmap = this.currentBitmap[index];
        return (128 >>> shift & (bitmap & 0xFF)) == 0;
    }

    public boolean getBoolean(int columnIndex) throws StatementExecutionException {
        return this.getBoolean(this.findColumnNameByIndex(columnIndex));
    }

    public boolean getBoolean(String columnName) throws StatementExecutionException {
        this.checkRecord();
        int index = this.columnOrdinalMap.get(columnName) - 2;
        if (!this.isNull(index, this.rowsIndex - 1)) {
            this.lastReadWasNull = false;
            return BytesUtils.bytesToBool((byte[])this.values[index]);
        }
        this.lastReadWasNull = true;
        return false;
    }

    public double getDouble(int columnIndex) throws StatementExecutionException {
        return this.getDouble(this.findColumnNameByIndex(columnIndex));
    }

    public double getDouble(String columnName) throws StatementExecutionException {
        this.checkRecord();
        int index = this.columnOrdinalMap.get(columnName) - 2;
        if (!this.isNull(index, this.rowsIndex - 1)) {
            this.lastReadWasNull = false;
            return BytesUtils.bytesToDouble((byte[])this.values[index]);
        }
        this.lastReadWasNull = true;
        return 0.0;
    }

    public float getFloat(int columnIndex) throws StatementExecutionException {
        return this.getFloat(this.findColumnNameByIndex(columnIndex));
    }

    public float getFloat(String columnName) throws StatementExecutionException {
        this.checkRecord();
        int index = this.columnOrdinalMap.get(columnName) - 2;
        if (!this.isNull(index, this.rowsIndex - 1)) {
            this.lastReadWasNull = false;
            return BytesUtils.bytesToFloat((byte[])this.values[index]);
        }
        this.lastReadWasNull = true;
        return 0.0f;
    }

    public int getInt(int columnIndex) throws StatementExecutionException {
        return this.getInt(this.findColumnNameByIndex(columnIndex));
    }

    public int getInt(String columnName) throws StatementExecutionException {
        this.checkRecord();
        int index = this.columnOrdinalMap.get(columnName) - 2;
        if (!this.isNull(index, this.rowsIndex - 1)) {
            this.lastReadWasNull = false;
            return BytesUtils.bytesToInt((byte[])this.values[index]);
        }
        this.lastReadWasNull = true;
        return 0;
    }

    public long getLong(int columnIndex) throws StatementExecutionException {
        return this.getLong(this.findColumnNameByIndex(columnIndex));
    }

    public long getLong(String columnName) throws StatementExecutionException {
        this.checkRecord();
        if (columnName.equals(TIMESTAMP_STR)) {
            return BytesUtils.bytesToLong((byte[])this.time);
        }
        int index = this.columnOrdinalMap.get(columnName) - 2;
        if (!this.isNull(index, this.rowsIndex - 1)) {
            this.lastReadWasNull = false;
            return BytesUtils.bytesToLong((byte[])this.values[index]);
        }
        this.lastReadWasNull = true;
        return 0L;
    }

    public Object getObject(int columnIndex) throws StatementExecutionException {
        return this.getObject(this.findColumnNameByIndex(columnIndex));
    }

    public Object getObject(String columnName) throws StatementExecutionException {
        return this.getObjectByName(columnName);
    }

    public String getString(int columnIndex) throws StatementExecutionException {
        return this.getString(this.findColumnNameByIndex(columnIndex));
    }

    public String getString(String columnName) throws StatementExecutionException {
        return this.getValueByName(columnName);
    }

    public Timestamp getTimestamp(int columnIndex) throws StatementExecutionException {
        return new Timestamp(this.getLong(columnIndex));
    }

    public Timestamp getTimestamp(String columnName) throws StatementExecutionException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public int findColumn(String columnName) {
        return this.columnOrdinalMap.get(columnName);
    }

    public String getValueByName(String columnName) throws StatementExecutionException {
        this.checkRecord();
        if (columnName.equals(TIMESTAMP_STR)) {
            return String.valueOf(BytesUtils.bytesToLong((byte[])this.time));
        }
        int index = this.columnOrdinalMap.get(columnName) - 2;
        if (index < 0 || index >= this.values.length || this.isNull(index, this.rowsIndex - 1)) {
            this.lastReadWasNull = true;
            return null;
        }
        this.lastReadWasNull = false;
        return this.getString(index, this.columnTypeDeduplicatedList.get(index), this.values);
    }

    public String getString(int index, TSDataType tsDataType, byte[][] values) {
        switch (tsDataType) {
            case BOOLEAN: {
                return String.valueOf(BytesUtils.bytesToBool((byte[])values[index]));
            }
            case INT32: {
                return String.valueOf(BytesUtils.bytesToInt((byte[])values[index]));
            }
            case INT64: {
                return String.valueOf(BytesUtils.bytesToLong((byte[])values[index]));
            }
            case FLOAT: {
                return String.valueOf(BytesUtils.bytesToFloat((byte[])values[index]));
            }
            case DOUBLE: {
                return String.valueOf(BytesUtils.bytesToDouble((byte[])values[index]));
            }
            case TEXT: {
                return new String(values[index], StandardCharsets.UTF_8);
            }
        }
        return null;
    }

    public Object getObjectByName(String columnName) throws StatementExecutionException {
        this.checkRecord();
        if (columnName.equals(TIMESTAMP_STR)) {
            return BytesUtils.bytesToLong((byte[])this.time);
        }
        int index = this.columnOrdinalMap.get(columnName) - 2;
        if (index < 0 || index >= this.values.length || this.isNull(index, this.rowsIndex - 1)) {
            this.lastReadWasNull = true;
            return null;
        }
        this.lastReadWasNull = false;
        return this.getObject(index, this.columnTypeDeduplicatedList.get(index), this.values);
    }

    public Object getObject(int index, TSDataType tsDataType, byte[][] values) {
        switch (tsDataType) {
            case BOOLEAN: {
                return BytesUtils.bytesToBool((byte[])values[index]);
            }
            case INT32: {
                return BytesUtils.bytesToInt((byte[])values[index]);
            }
            case INT64: {
                return BytesUtils.bytesToLong((byte[])values[index]);
            }
            case FLOAT: {
                return Float.valueOf(BytesUtils.bytesToFloat((byte[])values[index]));
            }
            case DOUBLE: {
                return BytesUtils.bytesToDouble((byte[])values[index]);
            }
            case TEXT: {
                return new String(values[index], StandardCharsets.UTF_8);
            }
        }
        return null;
    }

    public String findColumnNameByIndex(int columnIndex) throws StatementExecutionException {
        if (columnIndex <= 0) {
            throw new StatementExecutionException("column index should start from 1");
        }
        if (columnIndex > this.columnNameList.size()) {
            throw new StatementExecutionException(String.format("column index %d out of range %d", columnIndex, this.columnNameList.size()));
        }
        return this.columnNameList.get(columnIndex - 1);
    }

    public void checkRecord() throws StatementExecutionException {
        if (Objects.isNull(this.tsQueryDataSet)) {
            throw new StatementExecutionException("No record remains");
        }
    }

    public void setTsQueryDataSet(TSQueryDataSet tsQueryDataSet) {
        this.tsQueryDataSet = tsQueryDataSet;
        this.emptyResultSet = tsQueryDataSet == null || !tsQueryDataSet.time.hasRemaining();
    }
}

