/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.upgrade.UpgradeCheckStatus;
import org.apache.iotdb.db.engine.upgrade.UpgradeLog;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;
import org.apache.iotdb.tsfile.v2.read.TsFileSequenceReaderForV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeUtils {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeUtils.class);
    private static final String COMMA_SEPERATOR = ",";
    private static final ReadWriteLock cntUpgradeFileLock = new ReentrantReadWriteLock();
    private static final ReadWriteLock upgradeLogLock = new ReentrantReadWriteLock();
    private static FSFactory fsFactory = FSFactoryProducer.getFSFactory();
    private static Map<String, Integer> upgradeRecoverMap = new HashMap<String, Integer>();

    public static ReadWriteLock getCntUpgradeFileLock() {
        return cntUpgradeFileLock;
    }

    public static ReadWriteLock getUpgradeLogLock() {
        return upgradeLogLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNeedUpgrade(TsFileResource tsFileResource) {
        tsFileResource.readLock();
        try {
            if (tsFileResource.getTsFile().length() == 0L) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            tsFileResource.readUnlock();
        }
        tsFileResource.readLock();
        try (TsFileSequenceReaderForV2 tsFileSequenceReader = new TsFileSequenceReaderForV2(tsFileResource.getTsFile().getAbsolutePath());){
            String versionNumber = tsFileSequenceReader.readVersionNumberV2();
            if (versionNumber.equals("000002") || versionNumber.equals("000001")) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            logger.error("meet error when judge whether file needs to be upgraded, the file's path:{}", (Object)tsFileResource.getTsFile().getAbsolutePath(), (Object)e);
        }
        finally {
            tsFileResource.readUnlock();
        }
        return false;
    }

    public static void moveUpgradedFiles(TsFileResource resource) throws IOException {
        List<TsFileResource> upgradedResources = resource.getUpgradedResources();
        for (TsFileResource upgradedResource : upgradedResources) {
            File upgradeDir;
            File upgradedFile = upgradedResource.getTsFile();
            long partition = upgradedResource.getTimePartition();
            String virtualStorageGroupDir = upgradedFile.getParentFile().getParentFile().getParent();
            File partitionDir = fsFactory.getFile(virtualStorageGroupDir, String.valueOf(partition));
            if (!partitionDir.exists()) {
                partitionDir.mkdir();
            }
            if (upgradedFile.exists()) {
                fsFactory.moveFile(upgradedFile, fsFactory.getFile(partitionDir, upgradedFile.getName()));
            }
            File tempResourceFile = fsFactory.getFile(upgradedResource.getTsFile().toPath() + ".resource");
            File newModsFile = fsFactory.getFile(upgradedResource.getTsFile().toPath() + ".mods");
            if (newModsFile.exists()) {
                fsFactory.moveFile(newModsFile, fsFactory.getFile(partitionDir, newModsFile.getName()));
            }
            upgradedResource.setFile(fsFactory.getFile(partitionDir, upgradedFile.getName()));
            if (fsFactory.getFile(partitionDir, newModsFile.getName()).exists()) {
                upgradedResource.getModFile();
            }
            upgradedResource.setClosed(true);
            upgradedResource.serialize();
            Files.delete(tempResourceFile.toPath());
            File tmpPartitionDir = upgradedFile.getParentFile();
            if (tmpPartitionDir.isDirectory() && tmpPartitionDir.listFiles().length == 0) {
                Files.delete(tmpPartitionDir.toPath());
            }
            if (!(upgradeDir = tmpPartitionDir.getParentFile()).isDirectory() || upgradeDir.listFiles().length != 0) continue;
            Files.delete(upgradeDir.toPath());
        }
    }

    public static boolean isUpgradedFileGenerated(String oldFileName) {
        return upgradeRecoverMap.containsKey(oldFileName) && upgradeRecoverMap.get(oldFileName).intValue() == UpgradeCheckStatus.AFTER_UPGRADE_FILE.getCheckStatusCode();
    }

    public static void clearUpgradeRecoverMap() {
        upgradeRecoverMap = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recoverUpgrade() {
        if (FSFactoryProducer.getFSFactory().getFile(UpgradeLog.getUpgradeLogPath()).exists()) {
            try (BufferedReader upgradeLogReader = new BufferedReader(new FileReader(FSFactoryProducer.getFSFactory().getFile(UpgradeLog.getUpgradeLogPath())));){
                String line = null;
                while ((line = upgradeLogReader.readLine()) != null) {
                    String oldFilePath = line.split(COMMA_SEPERATOR)[0];
                    String oldFileName = new File(oldFilePath).getName();
                    if (upgradeRecoverMap.containsKey(oldFileName)) {
                        upgradeRecoverMap.put(oldFileName, upgradeRecoverMap.get(oldFileName) + 1);
                        continue;
                    }
                    upgradeRecoverMap.put(oldFileName, 1);
                }
            }
            catch (IOException e) {
                logger.error("meet error when recover upgrade process, file path:{}", (Object)UpgradeLog.getUpgradeLogPath(), (Object)e);
            }
            finally {
                FSFactoryProducer.getFSFactory().getFile(UpgradeLog.getUpgradeLogPath()).delete();
            }
        }
    }
}

