/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.entity.PathPrivilege;
import org.apache.iotdb.db.auth.entity.PrivilegeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthUtils {
    private static final Logger logger = LoggerFactory.getLogger(AuthUtils.class);
    private static final int MIN_PASSWORD_LENGTH = 4;
    private static final int MIN_USERNAME_LENGTH = 4;
    private static final int MIN_ROLENAME_LENGTH = 4;
    private static final String ROOT_PREFIX = "root";
    private static final String ENCRYPT_ALGORITHM = "MD5";
    private static final String STRING_ENCODING = "utf-8";

    private AuthUtils() {
    }

    public static void validatePassword(String password) throws AuthException {
        if (password.length() < 4) {
            throw new AuthException("Password's size must be greater than or equal to 4");
        }
    }

    public static void validateUsername(String username) throws AuthException {
        if (username.length() < 4) {
            throw new AuthException("Username's size must be greater than or equal to 4");
        }
    }

    public static void validateRolename(String rolename) throws AuthException {
        if (rolename.length() < 4) {
            throw new AuthException("Role name's size must be greater than or equal to 4");
        }
    }

    public static void validatePrivilege(int privilegeId) throws AuthException {
        if (privilegeId < 0 || privilegeId >= PrivilegeType.values().length) {
            throw new AuthException(String.format("Invalid privilegeId %d", privilegeId));
        }
    }

    public static void validatePath(String path) throws AuthException {
        if (!path.startsWith(ROOT_PREFIX)) {
            throw new AuthException(String.format("Illegal seriesPath %s, seriesPath should start with \"%s\"", path, ROOT_PREFIX));
        }
    }

    public static void validatePrivilegeOnPath(String path, int privilegeId) throws AuthException {
        AuthUtils.validatePrivilege(privilegeId);
        PrivilegeType type = PrivilegeType.values()[privilegeId];
        if (!path.equals(ROOT_PREFIX)) {
            AuthUtils.validatePath(path);
            switch (type) {
                case READ_TIMESERIES: 
                case SET_STORAGE_GROUP: 
                case CREATE_TIMESERIES: 
                case DELETE_TIMESERIES: 
                case INSERT_TIMESERIES: 
                case UPDATE_TIMESERIES: {
                    return;
                }
            }
            throw new AuthException(String.format("Illegal privilege %s on seriesPath %s", new Object[]{type, path}));
        }
        switch (type) {
            case READ_TIMESERIES: 
            case SET_STORAGE_GROUP: 
            case CREATE_TIMESERIES: 
            case DELETE_TIMESERIES: 
            case INSERT_TIMESERIES: 
            case UPDATE_TIMESERIES: {
                AuthUtils.validatePath(path);
                return;
            }
        }
    }

    public static String encryptPassword(String password) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(ENCRYPT_ALGORITHM);
            messageDigest.update(password.getBytes(STRING_ENCODING));
            return new String(messageDigest.digest(), STRING_ENCODING);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            logger.error("meet error while encrypting password.", (Throwable)e);
            return password;
        }
    }

    public static boolean pathBelongsTo(String pathA, String pathB) {
        return pathA.equals(pathB) || pathA.startsWith(pathB) && pathA.charAt(pathB.length()) == '.';
    }

    public static boolean checkPrivilege(String path, int privilegeId, List<PathPrivilege> privilegeList) {
        if (privilegeList == null) {
            return false;
        }
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (!(path != null ? pathPrivilege.getPath() != null && AuthUtils.pathBelongsTo(path, pathPrivilege.getPath()) && pathPrivilege.getPrivileges().contains(privilegeId) : pathPrivilege.getPath() == null && pathPrivilege.getPrivileges().contains(privilegeId))) continue;
            return true;
        }
        return false;
    }

    public static Set<Integer> getPrivileges(String path, List<PathPrivilege> privilegeList) {
        if (privilegeList == null) {
            return new HashSet<Integer>();
        }
        HashSet<Integer> privileges = new HashSet<Integer>();
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (path != null) {
                if (pathPrivilege.getPath() == null || !AuthUtils.pathBelongsTo(path, pathPrivilege.getPath())) continue;
                privileges.addAll(pathPrivilege.getPrivileges());
                continue;
            }
            if (pathPrivilege.getPath() != null) continue;
            privileges.addAll(pathPrivilege.getPrivileges());
        }
        return privileges;
    }

    public static boolean hasPrivilege(String path, int privilegeId, List<PathPrivilege> privilegeList) {
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (!pathPrivilege.getPath().equals(path) || !pathPrivilege.getPrivileges().contains(privilegeId)) continue;
            pathPrivilege.getReferenceCnt().incrementAndGet();
            return true;
        }
        return false;
    }

    public static void addPrivilege(String path, int privilegeId, List<PathPrivilege> privilegeList) {
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (!pathPrivilege.getPath().equals(path)) continue;
            if (privilegeId != PrivilegeType.ALL.ordinal()) {
                pathPrivilege.getPrivileges().add(privilegeId);
            } else {
                for (PrivilegeType privilegeType : PrivilegeType.values()) {
                    pathPrivilege.getPrivileges().add(privilegeType.ordinal());
                }
            }
            return;
        }
        PathPrivilege pathPrivilege = new PathPrivilege(path);
        if (privilegeId != PrivilegeType.ALL.ordinal()) {
            pathPrivilege.getPrivileges().add(privilegeId);
        } else {
            for (PrivilegeType privilegeType : PrivilegeType.values()) {
                pathPrivilege.getPrivileges().add(privilegeType.ordinal());
            }
        }
        privilegeList.add(pathPrivilege);
    }

    public static void removePrivilege(String path, int privilegeId, List<PathPrivilege> privilegeList) {
        PathPrivilege emptyPrivilege = null;
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (!pathPrivilege.getPath().equals(path)) continue;
            if (privilegeId == PrivilegeType.ALL.ordinal()) {
                privilegeList.remove(pathPrivilege);
                return;
            }
            pathPrivilege.getPrivileges().remove(privilegeId);
            if (!pathPrivilege.getPrivileges().isEmpty()) break;
            emptyPrivilege = pathPrivilege;
            break;
        }
        if (emptyPrivilege != null) {
            privilegeList.remove(emptyPrivilege);
        }
    }
}

