/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.rescon;

import java.util.ArrayDeque;
import java.util.EnumMap;
import java.util.Map;
import java.util.Queue;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.rescon.TVListAllocatorMBean;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.JMXService;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class TVListAllocator
implements TVListAllocatorMBean,
IService {
    private Map<TSDataType, Queue<TVList>> tvListCache = new EnumMap<TSDataType, Queue<TVList>>(TSDataType.class);
    private String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.service", "type", this.getID().getJmxName());
    private static final TVListAllocator INSTANCE = new TVListAllocator();

    public static TVListAllocator getInstance() {
        return INSTANCE;
    }

    public synchronized TVList allocate(TSDataType dataType) {
        Queue tvLists = this.tvListCache.computeIfAbsent(dataType, k -> new ArrayDeque());
        TVList list = (TVList)tvLists.poll();
        return list != null ? list : TVList.newList(dataType);
    }

    public synchronized void release(TSDataType dataType, TVList list) {
        list.clear();
        this.tvListCache.get(dataType).add(list);
    }

    public synchronized void release(TVList list) {
        list.clear();
        this.tvListCache.get(list.getDataType()).add(list);
    }

    @Override
    public int getNumberOfTVLists() {
        int number = 0;
        for (Queue<TVList> queue : this.tvListCache.values()) {
            number += queue.size();
        }
        return number;
    }

    @Override
    public void start() throws StartupException {
        try {
            JMXService.registerMBean(INSTANCE, this.mbeanName);
        }
        catch (Exception e) {
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
    }

    @Override
    public void stop() {
        JMXService.deregisterMBean(this.mbeanName);
        for (Queue<TVList> queue : this.tvListCache.values()) {
            queue.clear();
        }
    }

    @Override
    public ServiceType getID() {
        return ServiceType.TVLIST_ALLOCATOR_SERVICE;
    }
}

