/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.AlignByDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.FillQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.executor.IQueryRouter;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.rpc.RedirectException;
import org.apache.iotdb.service.rpc.thrift.EndPoint;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Binary;

public class AlignByDeviceDataSet
extends QueryDataSet {
    private DataSetType dataSetType;
    private IQueryRouter queryRouter;
    private QueryContext context;
    private IExpression expression;
    private List<String> measurements;
    private List<PartialPath> devices;
    private Map<String, IExpression> deviceToFilterMap;
    private Map<String, AlignByDevicePlan.MeasurementType> measurementTypeMap;
    private Map<String, TSDataType> measurementDataTypeMap;
    private GroupByTimePlan groupByTimePlan;
    private FillQueryPlan fillQueryPlan;
    private AggregationPlan aggregationPlan;
    private RawDataQueryPlan rawDataQueryPlan;
    private boolean curDataSetInitialized;
    private PartialPath currentDevice;
    private QueryDataSet currentDataSet;
    private Iterator<PartialPath> deviceIterator;
    private List<String> executeColumns;
    private int pathsNum = 0;

    public AlignByDeviceDataSet(AlignByDevicePlan alignByDevicePlan, QueryContext context, IQueryRouter queryRouter) {
        super(null, alignByDevicePlan.getDataTypes());
        this.measurements = alignByDevicePlan.getMeasurements();
        this.devices = alignByDevicePlan.getDevices();
        this.measurementDataTypeMap = alignByDevicePlan.getMeasurementDataTypeMap();
        this.queryRouter = queryRouter;
        this.context = context;
        this.deviceToFilterMap = alignByDevicePlan.getDeviceToFilterMap();
        this.measurementTypeMap = alignByDevicePlan.getMeasurementTypeMap();
        switch (alignByDevicePlan.getOperatorType()) {
            case GROUPBYTIME: {
                this.dataSetType = DataSetType.GROUPBYTIME;
                this.groupByTimePlan = alignByDevicePlan.getGroupByTimePlan();
                this.groupByTimePlan.setAscending(alignByDevicePlan.isAscending());
                break;
            }
            case AGGREGATION: {
                this.dataSetType = DataSetType.AGGREGATE;
                this.aggregationPlan = alignByDevicePlan.getAggregationPlan();
                this.aggregationPlan.setAscending(alignByDevicePlan.isAscending());
                break;
            }
            case FILL: {
                this.dataSetType = DataSetType.FILL;
                this.fillQueryPlan = alignByDevicePlan.getFillQueryPlan();
                this.fillQueryPlan.setAscending(alignByDevicePlan.isAscending());
                break;
            }
            default: {
                this.dataSetType = DataSetType.QUERY;
                this.rawDataQueryPlan = new RawDataQueryPlan();
                this.rawDataQueryPlan.setAscending(alignByDevicePlan.isAscending());
                this.rawDataQueryPlan.setEnableRedirect(alignByDevicePlan.isEnableRedirect());
            }
        }
        this.curDataSetInitialized = false;
        this.deviceIterator = this.devices.iterator();
    }

    public int getPathsNum() {
        return this.pathsNum;
    }

    public boolean hasNextWithoutConstraint() throws IOException {
        if (this.curDataSetInitialized && this.currentDataSet.hasNext()) {
            return true;
        }
        this.curDataSetInitialized = false;
        while (this.deviceIterator.hasNext()) {
            this.currentDevice = this.deviceIterator.next();
            Set<String> measurementOfGivenDevice = this.getDeviceMeasurements(this.currentDevice);
            this.executeColumns = new ArrayList<String>();
            ArrayList<PartialPath> executePaths = new ArrayList<PartialPath>();
            ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
            ArrayList<String> executeAggregations = new ArrayList<String>();
            Iterator<String> iterator = this.measurementDataTypeMap.keySet().iterator();
            while (iterator.hasNext()) {
                String column;
                String measurement = column = iterator.next();
                if ((this.dataSetType == DataSetType.GROUPBYTIME || this.dataSetType == DataSetType.AGGREGATE) && measurementOfGivenDevice.contains(measurement = column.substring(column.indexOf(40) + 1, column.indexOf(41)))) {
                    executeAggregations.add(column.substring(0, column.indexOf(40)));
                }
                if (!measurementOfGivenDevice.contains(measurement)) continue;
                this.executeColumns.add(column);
                executePaths.add(this.currentDevice.concatNode(measurement));
                tsDataTypes.add(this.measurementDataTypeMap.get(column));
            }
            if (this.deviceToFilterMap != null) {
                this.expression = this.deviceToFilterMap.get(this.currentDevice.getFullPath());
            }
            if (IoTDBDescriptor.getInstance().getConfig().isEnablePerformanceTracing()) {
                this.pathsNum += this.executeColumns.size();
            }
            try {
                switch (this.dataSetType) {
                    case GROUPBYTIME: {
                        this.groupByTimePlan.setDeduplicatedPaths(executePaths);
                        this.groupByTimePlan.setDeduplicatedDataTypes(tsDataTypes);
                        this.groupByTimePlan.setDeduplicatedAggregations(executeAggregations);
                        this.groupByTimePlan.setExpression(this.expression);
                        this.currentDataSet = this.queryRouter.groupBy(this.groupByTimePlan, this.context);
                        break;
                    }
                    case AGGREGATE: {
                        this.aggregationPlan.setDeduplicatedPaths(executePaths);
                        this.aggregationPlan.setDeduplicatedAggregations(executeAggregations);
                        this.aggregationPlan.setDeduplicatedDataTypes(tsDataTypes);
                        this.aggregationPlan.setExpression(this.expression);
                        this.currentDataSet = this.queryRouter.aggregate(this.aggregationPlan, this.context);
                        break;
                    }
                    case FILL: {
                        this.fillQueryPlan.setDeduplicatedDataTypes(tsDataTypes);
                        this.fillQueryPlan.setDeduplicatedPaths(executePaths);
                        this.currentDataSet = this.queryRouter.fill(this.fillQueryPlan, this.context);
                        break;
                    }
                    case QUERY: {
                        this.rawDataQueryPlan.setDeduplicatedPaths(executePaths);
                        this.rawDataQueryPlan.setDeduplicatedDataTypes(tsDataTypes);
                        this.rawDataQueryPlan.setExpression(this.expression);
                        this.currentDataSet = this.queryRouter.rawDataQuery(this.rawDataQueryPlan, this.context);
                        break;
                    }
                    default: {
                        throw new IOException("unsupported DataSetType");
                    }
                }
            }
            catch (StorageEngineException | QueryProcessException | QueryFilterOptimizationException e) {
                throw new IOException(e);
            }
            if (this.currentDataSet.getEndPoint() != null) {
                EndPoint endPoint = new EndPoint();
                endPoint.setIp(this.currentDataSet.getEndPoint().getIp());
                endPoint.setPort(this.currentDataSet.getEndPoint().getPort());
                throw new RedirectException(endPoint);
            }
            if (!this.currentDataSet.hasNext()) continue;
            this.curDataSetInitialized = true;
            return true;
        }
        return false;
    }

    protected Set<String> getDeviceMeasurements(PartialPath device) throws IOException {
        try {
            MNode deviceNode = IoTDB.metaManager.getNodeByPath(device);
            return deviceNode.getChildren().keySet();
        }
        catch (MetadataException e) {
            throw new IOException("Cannot get node from " + device, e);
        }
    }

    public RowRecord nextWithoutConstraint() throws IOException {
        RowRecord originRowRecord = this.currentDataSet.next();
        RowRecord rowRecord = new RowRecord(originRowRecord.getTimestamp());
        Field deviceField = new Field(TSDataType.TEXT);
        deviceField.setBinaryV(new Binary(this.currentDevice.getFullPath()));
        rowRecord.addField(deviceField);
        List measurementFields = originRowRecord.getFields();
        HashMap<String, Field> currentColumnMap = new HashMap<String, Field>();
        for (int i = 0; i < measurementFields.size(); ++i) {
            currentColumnMap.put(this.executeColumns.get(i), (Field)measurementFields.get(i));
        }
        for (String measurement : this.measurements) {
            switch (this.measurementTypeMap.get(measurement)) {
                case Exist: {
                    if (currentColumnMap.get(measurement) != null) {
                        rowRecord.addField((Field)currentColumnMap.get(measurement));
                        break;
                    }
                    rowRecord.addField(new Field(null));
                    break;
                }
                case NonExist: {
                    rowRecord.addField(new Field(null));
                    break;
                }
                case Constant: {
                    Field res = new Field(TSDataType.TEXT);
                    res.setBinaryV(Binary.valueOf((String)measurement));
                    rowRecord.addField(res);
                }
            }
        }
        return rowRecord;
    }

    private static enum DataSetType {
        GROUPBYTIME,
        AGGREGATE,
        FILL,
        QUERY;

    }
}

