/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingManager {
    private static final Logger logger = LoggerFactory.getLogger(TracingManager.class);
    private static final String QUERY_ID = "Query Id: ";
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private BufferedWriter writer;
    private Map<Long, Long> queryStartTime = new ConcurrentHashMap<Long, Long>();

    public TracingManager(String dirName, String logFileName) {
        this.initTracingManager(dirName, logFileName);
    }

    public void initTracingManager(String dirName, String logFileName) {
        File tracingDir = SystemFileFactory.INSTANCE.getFile(dirName);
        if (!tracingDir.exists()) {
            if (tracingDir.mkdirs()) {
                logger.info("create performance folder {}.", (Object)tracingDir);
            } else {
                logger.info("create performance folder {} failed.", (Object)tracingDir);
            }
        }
        File logFile = SystemFileFactory.INSTANCE.getFile(dirName + File.separator + logFileName);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(logFile, true);
        }
        catch (IOException e) {
            logger.error("Meeting error while creating TracingManager: {}", (Object)e.getMessage());
        }
        this.writer = new BufferedWriter(fileWriter);
    }

    public static TracingManager getInstance() {
        return TracingManagerHelper.INSTANCE;
    }

    public void writeQueryInfo(long queryId, String statement, long startTime, int pathsNum) throws IOException {
        this.queryStartTime.put(queryId, startTime);
        StringBuilder builder = new StringBuilder();
        builder.append(QUERY_ID).append(queryId).append(" - Query Statement: ").append(statement).append("\nQuery Id: ").append(queryId).append(" - Start time: ").append(new SimpleDateFormat(DATE_FORMAT).format(startTime)).append("\nQuery Id: ").append(queryId).append(" - Number of series paths: ").append(pathsNum).append("\n");
        this.writer.write(builder.toString());
    }

    public void writeQueryInfo(long queryId, String statement, long startTime) throws IOException {
        this.queryStartTime.put(queryId, startTime);
        StringBuilder builder = new StringBuilder();
        builder.append(QUERY_ID).append(queryId).append(" - Query Statement: ").append(statement).append("\nQuery Id: ").append(queryId).append(" - Start time: ").append(new SimpleDateFormat(DATE_FORMAT).format(startTime)).append("\n");
        this.writer.write(builder.toString());
    }

    public void writePathsNum(long queryId, int pathsNum) throws IOException {
        StringBuilder builder = new StringBuilder(QUERY_ID).append(queryId).append(" - Number of series paths: ").append(pathsNum).append("\n");
        this.writer.write(builder.toString());
    }

    public void writeTsFileInfo(long queryId, Set<TsFileResource> seqFileResources, Set<TsFileResource> unSeqFileResources) throws IOException {
        StringBuilder builder = new StringBuilder(QUERY_ID).append(queryId).append(" - Number of sequence files: ").append(seqFileResources.size());
        for (TsFileResource seqFileResource : seqFileResources) {
            builder.append("\nQuery Id: ").append(queryId).append(" - SeqFile_").append(seqFileResource.getTsFile().getName());
            this.printTsFileStatistics(builder, seqFileResource);
        }
        builder.append("\nQuery Id: ").append(queryId).append(" - Number of unSequence files: ").append(unSeqFileResources.size());
        for (TsFileResource unSeqFileResource : unSeqFileResources) {
            builder.append("\nQuery Id: ").append(queryId).append(" - UnSeqFile_").append(unSeqFileResource.getTsFile().getName());
            this.printTsFileStatistics(builder, unSeqFileResource);
        }
        builder.append("\n");
        this.writer.write(builder.toString());
    }

    private void printTsFileStatistics(StringBuilder builder, TsFileResource tsFileResource) {
        Iterator<String> deviceIter = tsFileResource.getDevices().iterator();
        while (deviceIter.hasNext()) {
            String device = deviceIter.next();
            builder.append(" ").append(device).append("[").append(tsFileResource.getStartTime(device)).append(", ").append(tsFileResource.getEndTime(device)).append("]");
            if (!deviceIter.hasNext()) continue;
            builder.append(",");
        }
    }

    public void writeChunksInfo(long queryId, long totalChunkNum, long totalChunkSize) throws IOException {
        StringBuilder builder = new StringBuilder(QUERY_ID).append(queryId).append(" - Number of chunks: ").append(totalChunkNum).append("\nQuery Id: ").append(queryId).append(" - Average size of chunks: ").append(totalChunkSize / totalChunkNum).append("\n");
        this.writer.write(builder.toString());
    }

    public void writeEndTime(long queryId) throws IOException {
        long endTime = System.currentTimeMillis();
        StringBuilder builder = new StringBuilder(QUERY_ID).append(queryId).append(" - Total cost time: ").append(endTime - this.queryStartTime.remove(queryId)).append("ms\n");
        this.writer.write(builder.toString());
        this.writer.flush();
    }

    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            logger.error("Meeting error while Close the tracing log stream : {}", (Object)e.getMessage());
        }
    }

    public boolean getWriterStatus() {
        try {
            this.writer.flush();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void openTracingWriteStream() {
        this.initTracingManager(IoTDBDescriptor.getInstance().getConfig().getTracingDir(), "tracing.txt");
    }

    private static class TracingManagerHelper {
        private static final TracingManager INSTANCE = new TracingManager(IoTDBDescriptor.getInstance().getConfig().getTracingDir(), "tracing.txt");

        private TracingManagerHelper() {
        }
    }
}

