/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.MNodePlan;
import org.apache.iotdb.db.qp.physical.sys.MeasurementMNodePlan;
import org.apache.iotdb.db.qp.physical.sys.StorageGroupMNodePlan;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLogTxtWriter
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(MLogTxtWriter.class);
    private static final String STRING_TYPE = "%s,%s,%s" + System.lineSeparator();
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private final File logFile;
    private FileOutputStream fileOutputStream;
    private FileChannel channel;
    private final AtomicInteger lineNumber;

    public MLogTxtWriter(String schemaDir, String logFileName) throws IOException {
        File metadataDir = SystemFileFactory.INSTANCE.getFile(schemaDir);
        if (!metadataDir.exists()) {
            if (metadataDir.mkdirs()) {
                logger.info("create schema folder {}.", (Object)metadataDir);
            } else {
                logger.info("create schema folder {} failed.", (Object)metadataDir);
            }
        }
        this.logFile = SystemFileFactory.INSTANCE.getFile(schemaDir + File.separator + logFileName);
        this.fileOutputStream = new FileOutputStream(this.logFile, true);
        this.channel = this.fileOutputStream.getChannel();
        this.lineNumber = new AtomicInteger(0);
    }

    public MLogTxtWriter(String logFileName) throws FileNotFoundException {
        this.logFile = SystemFileFactory.INSTANCE.getFile(logFileName);
        this.fileOutputStream = new FileOutputStream(this.logFile, true);
        this.channel = this.fileOutputStream.getChannel();
        this.lineNumber = new AtomicInteger(0);
    }

    @Override
    public void close() throws IOException {
        this.fileOutputStream.close();
    }

    public void createTimeseries(CreateTimeSeriesPlan plan, long offset) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("%s,%s,%s,%s,%s", "0", plan.getPath().getFullPath(), plan.getDataType().serialize(), plan.getEncoding().serialize(), plan.getCompressor().serialize()));
        buf.append(",");
        if (plan.getProps() != null) {
            boolean first = true;
            for (Map.Entry<String, String> entry : plan.getProps().entrySet()) {
                if (first) {
                    buf.append(String.format("%s=%s", entry.getKey(), entry.getValue()));
                    first = false;
                    continue;
                }
                buf.append(String.format("&%s=%s", entry.getKey(), entry.getValue()));
            }
        }
        buf.append(",");
        if (plan.getAlias() != null) {
            buf.append(plan.getAlias());
        }
        buf.append(",");
        if (offset >= 0L) {
            buf.append(offset);
        }
        buf.append(LINE_SEPARATOR);
        this.channel.write(ByteBuffer.wrap(buf.toString().getBytes()));
        this.lineNumber.incrementAndGet();
    }

    public void deleteTimeseries(String path) throws IOException {
        String outputStr = "1," + path + LINE_SEPARATOR;
        ByteBuffer buff = ByteBuffer.wrap(outputStr.getBytes());
        this.channel.write(buff);
    }

    public void setStorageGroup(String storageGroup) throws IOException {
        String outputStr = "2," + storageGroup + LINE_SEPARATOR;
        ByteBuffer buff = ByteBuffer.wrap(outputStr.getBytes());
        this.channel.write(buff);
        this.lineNumber.incrementAndGet();
    }

    public void deleteStorageGroup(String storageGroup) throws IOException {
        String outputStr = "11," + storageGroup + LINE_SEPARATOR;
        ByteBuffer buff = ByteBuffer.wrap(outputStr.getBytes());
        this.channel.write(buff);
        this.lineNumber.incrementAndGet();
    }

    public void setTTL(String storageGroup, long ttl) throws IOException {
        String outputStr = String.format(STRING_TYPE, "10", storageGroup, ttl);
        ByteBuffer buff = ByteBuffer.wrap(outputStr.getBytes());
        this.channel.write(buff);
        this.lineNumber.incrementAndGet();
    }

    public void changeOffset(String path, long offset) throws IOException {
        String outputStr = String.format(STRING_TYPE, "12", path, offset);
        ByteBuffer buff = ByteBuffer.wrap(outputStr.getBytes());
        this.channel.write(buff);
        this.lineNumber.incrementAndGet();
    }

    public void changeAlias(String path, String alias) throws IOException {
        String outputStr = String.format(STRING_TYPE, "13", path, alias);
        ByteBuffer buff = ByteBuffer.wrap(outputStr.getBytes());
        this.channel.write(buff);
        this.lineNumber.incrementAndGet();
    }

    public static void upgradeMLog(String schemaDir, String logFileName) throws IOException {
        File logFile = SystemFileFactory.INSTANCE.getFile(schemaDir + File.separator + logFileName);
        File tmpLogFile = SystemFileFactory.INSTANCE.getFile(logFile.getAbsolutePath() + ".tmp");
        if (!logFile.exists() && !tmpLogFile.exists()) {
            return;
        }
        if (!logFile.exists() && tmpLogFile.exists()) {
            FSFactoryProducer.getFSFactory().moveFile(tmpLogFile, logFile);
            return;
        }
        if (tmpLogFile.exists()) {
            try {
                Files.delete(Paths.get(tmpLogFile.toURI()));
            }
            catch (IOException e) {
                throw new IOException("Deleting " + tmpLogFile + "failed with exception " + e.getMessage());
            }
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(logFile));
             BufferedWriter writer = new BufferedWriter(new FileWriter(tmpLogFile, true));){
            String line;
            while ((line = reader.readLine()) != null) {
                StringBuilder buf = new StringBuilder();
                buf.append(line);
                if (line.startsWith("0")) {
                    buf.append(",,,");
                }
                writer.write(buf.toString());
                writer.newLine();
                writer.flush();
            }
        }
    }

    public void clear() throws IOException {
        this.channel.force(true);
        this.channel.close();
        this.fileOutputStream.close();
        Files.delete(this.logFile.toPath());
        this.fileOutputStream = new FileOutputStream(this.logFile, true);
        this.channel = this.fileOutputStream.getChannel();
        this.lineNumber.set(0);
    }

    public void serializeMNode(MNodePlan plan) throws IOException {
        StringBuilder s = new StringBuilder(String.valueOf(1));
        s.append(",").append(plan.getName()).append(",");
        s.append(plan.getChildSize());
        s.append(LINE_SEPARATOR);
        ByteBuffer buff = ByteBuffer.wrap(s.toString().getBytes());
        this.channel.write(buff);
        this.lineNumber.incrementAndGet();
    }

    public void serializeMeasurementMNode(MeasurementMNodePlan plan) throws IOException {
        StringBuilder s = new StringBuilder(String.valueOf(2));
        s.append(",").append(plan.getName()).append(",");
        if (plan.getAlias() != null) {
            s.append(plan.getAlias());
        }
        MeasurementSchema schema = plan.getSchema();
        s.append(",").append(schema.getType().ordinal()).append(",");
        s.append(schema.getEncodingType().ordinal()).append(",");
        s.append(schema.getCompressor().ordinal()).append(",");
        if (schema.getProps() != null) {
            for (Map.Entry entry : schema.getProps().entrySet()) {
                s.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append(";");
            }
        }
        s.append(",").append(plan.getOffset()).append(",");
        s.append(plan.getChildSize());
        s.append(LINE_SEPARATOR);
        ByteBuffer buff = ByteBuffer.wrap(s.toString().getBytes());
        this.channel.write(buff);
        this.lineNumber.incrementAndGet();
    }

    public void serializeStorageGroupMNode(StorageGroupMNodePlan plan) throws IOException {
        StringBuilder s = new StringBuilder(String.valueOf(1));
        s.append(",").append(plan.getName()).append(",");
        s.append(plan.getDataTTL()).append(",");
        s.append(plan.getChildSize());
        s.append(LINE_SEPARATOR);
        ByteBuffer buff = ByteBuffer.wrap(s.toString().getBytes());
        this.channel.write(buff);
        this.lineNumber.incrementAndGet();
    }

    int getLineNumber() {
        return this.lineNumber.get();
    }

    void setLineNumber(int number) {
        this.lineNumber.set(number);
    }
}

