/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.adapter.CompressionRatio;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.flush.CloseFileListener;
import org.apache.iotdb.db.engine.flush.FlushListener;
import org.apache.iotdb.db.engine.flush.FlushManager;
import org.apache.iotdb.db.engine.flush.MemTableFlushTask;
import org.apache.iotdb.db.engine.flush.NotifyFlushMemTable;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupInfo;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessorInfo;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.TsFileProcessorException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.WriteProcessRejectException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.rescon.MemTableManager;
import org.apache.iotdb.db.rescon.PrimitiveArrayManager;
import org.apache.iotdb.db.rescon.SystemInfo;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.db.writelog.WALFlushListener;
import org.apache.iotdb.db.writelog.manager.MultiFileLogNodeManager;
import org.apache.iotdb.db.writelog.node.WriteLogNode;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TsFileProcessor.class);
    private final String storageGroupName;
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final boolean enableMemControl = this.config.isEnableMemControl();
    private StorageGroupInfo storageGroupInfo;
    private TsFileProcessorInfo tsFileProcessorInfo;
    private final ConcurrentLinkedDeque<IMemTable> flushingMemTables = new ConcurrentLinkedDeque();
    private List<Pair<Modification, IMemTable>> modsToMemtable = new ArrayList<Pair<Modification, IMemTable>>();
    private RestorableTsFileIOWriter writer;
    private final TsFileResource tsFileResource;
    private long timeRangeId;
    private volatile boolean managedByFlushManager;
    private final ReadWriteLock flushQueryLock = new ReentrantReadWriteLock();
    private volatile boolean shouldClose;
    private IMemTable workMemTable;
    private final StorageGroupProcessor.UpdateEndTimeCallBack updateLatestFlushTimeCallback;
    private WriteLogNode logNode;
    private final boolean sequence;
    private long totalMemTableSize;
    private boolean shouldFlush = false;
    private static final String FLUSH_QUERY_WRITE_LOCKED = "{}: {} get flushQueryLock write lock";
    private static final String FLUSH_QUERY_WRITE_RELEASE = "{}: {} get flushQueryLock write lock released";
    private List<CloseFileListener> closeFileListeners = new ArrayList<CloseFileListener>();
    private List<FlushListener> flushListeners = new ArrayList<FlushListener>();

    TsFileProcessor(String storageGroupName, File tsfile, StorageGroupInfo storageGroupInfo, CloseFileListener closeTsFileCallback, StorageGroupProcessor.UpdateEndTimeCallBack updateLatestFlushTimeCallback, boolean sequence, int deviceNumInLastClosedTsFile) throws IOException {
        this.storageGroupName = storageGroupName;
        this.tsFileResource = new TsFileResource(tsfile, this, deviceNumInLastClosedTsFile);
        this.storageGroupInfo = storageGroupInfo;
        this.writer = new RestorableTsFileIOWriter(tsfile);
        this.updateLatestFlushTimeCallback = updateLatestFlushTimeCallback;
        this.sequence = sequence;
        logger.info("create a new tsfile processor {}", (Object)tsfile.getAbsolutePath());
        this.flushListeners.add(new WALFlushListener(this));
        this.closeFileListeners.add(closeTsFileCallback);
    }

    public TsFileProcessor(String storageGroupName, StorageGroupInfo storageGroupInfo, TsFileResource tsFileResource, CloseFileListener closeUnsealedTsFileProcessor, StorageGroupProcessor.UpdateEndTimeCallBack updateLatestFlushTimeCallback, boolean sequence, RestorableTsFileIOWriter writer) {
        this.storageGroupName = storageGroupName;
        this.tsFileResource = tsFileResource;
        this.storageGroupInfo = storageGroupInfo;
        this.writer = writer;
        this.updateLatestFlushTimeCallback = updateLatestFlushTimeCallback;
        this.sequence = sequence;
        logger.info("reopen a tsfile processor {}", (Object)tsFileResource.getTsFile());
        this.flushListeners.add(new WALFlushListener(this));
        this.closeFileListeners.add(closeUnsealedTsFileProcessor);
    }

    public void insert(InsertRowPlan insertRowPlan) throws WriteProcessException {
        if (this.workMemTable == null) {
            if (this.enableMemControl) {
                this.workMemTable = new PrimitiveMemTable(this.enableMemControl);
                MemTableManager.getInstance().addMemtableNumber();
            } else {
                this.workMemTable = MemTableManager.getInstance().getAvailableMemTable(this.storageGroupName);
            }
        }
        if (this.enableMemControl) {
            this.checkMemCostAndAddToTspInfo(insertRowPlan);
        }
        this.workMemTable.insert(insertRowPlan);
        if (IoTDBDescriptor.getInstance().getConfig().isEnableWal()) {
            try {
                this.getLogNode().write(insertRowPlan);
            }
            catch (Exception e) {
                throw new WriteProcessException(String.format("%s: %s write WAL failed", this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath()), e);
            }
        }
        this.tsFileResource.updateStartTime(insertRowPlan.getDeviceId().getFullPath(), insertRowPlan.getTime());
        if (!this.sequence) {
            this.tsFileResource.updateEndTime(insertRowPlan.getDeviceId().getFullPath(), insertRowPlan.getTime());
        }
        this.tsFileResource.updatePlanIndexes(insertRowPlan.getIndex());
    }

    public void insertTablet(InsertTabletPlan insertTabletPlan, int start, int end, TSStatus[] results) throws WriteProcessException {
        if (this.workMemTable == null) {
            if (this.enableMemControl) {
                this.workMemTable = new PrimitiveMemTable(this.enableMemControl);
                MemTableManager.getInstance().addMemtableNumber();
            } else {
                this.workMemTable = MemTableManager.getInstance().getAvailableMemTable(this.storageGroupName);
            }
        }
        try {
            if (this.enableMemControl) {
                this.checkMemCostAndAddToTspInfo(insertTabletPlan, start, end);
            }
        }
        catch (WriteProcessException e) {
            for (int i = start; i < end; ++i) {
                results[i] = RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRITE_PROCESS_REJECT, (String)e.getMessage());
            }
            throw new WriteProcessException(e);
        }
        try {
            this.workMemTable.insertTablet(insertTabletPlan, start, end);
            if (IoTDBDescriptor.getInstance().getConfig().isEnableWal()) {
                insertTabletPlan.setStart(start);
                insertTabletPlan.setEnd(end);
                this.getLogNode().write(insertTabletPlan);
            }
        }
        catch (Exception e) {
            for (int i = start; i < end; ++i) {
                results[i] = RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
            }
            throw new WriteProcessException(e);
        }
        for (int i = start; i < end; ++i) {
            results[i] = RpcUtils.SUCCESS_STATUS;
        }
        this.tsFileResource.updateStartTime(insertTabletPlan.getDeviceId().getFullPath(), insertTabletPlan.getTimes()[start]);
        if (!this.sequence) {
            this.tsFileResource.updateEndTime(insertTabletPlan.getDeviceId().getFullPath(), insertTabletPlan.getTimes()[end - 1]);
        }
        this.tsFileResource.updatePlanIndexes(insertTabletPlan.getIndex());
    }

    private void checkMemCostAndAddToTspInfo(InsertRowPlan insertRowPlan) throws WriteProcessException {
        long memTableIncrement = 0L;
        long textDataIncrement = 0L;
        long chunkMetadataIncrement = 0L;
        String deviceId = insertRowPlan.getDeviceId().getFullPath();
        long unsealedResourceIncrement = this.tsFileResource.estimateRamIncrement(deviceId);
        for (int i = 0; i < insertRowPlan.getDataTypes().length; ++i) {
            if (insertRowPlan.getDataTypes()[i] == null || insertRowPlan.getMeasurements()[i] == null) continue;
            if (this.workMemTable.checkIfChunkDoesNotExist(deviceId, insertRowPlan.getMeasurements()[i])) {
                chunkMetadataIncrement += ChunkMetadata.calculateRamSize((String)insertRowPlan.getMeasurements()[i], (TSDataType)insertRowPlan.getDataTypes()[i]);
                memTableIncrement += TVList.tvListArrayMemSize(insertRowPlan.getDataTypes()[i]);
            } else {
                int currentChunkPointNum = this.workMemTable.getCurrentChunkPointNum(deviceId, insertRowPlan.getMeasurements()[i]);
                memTableIncrement += currentChunkPointNum % PrimitiveArrayManager.ARRAY_SIZE == 0 ? TVList.tvListArrayMemSize(insertRowPlan.getDataTypes()[i]) : 0L;
            }
            if (insertRowPlan.getDataTypes()[i] != TSDataType.TEXT) continue;
            textDataIncrement += MemUtils.getBinarySize((Binary)insertRowPlan.getValues()[i]);
        }
        this.updateMemoryInfo(memTableIncrement, unsealedResourceIncrement, chunkMetadataIncrement, textDataIncrement);
    }

    private void checkMemCostAndAddToTspInfo(InsertTabletPlan insertTabletPlan, int start, int end) throws WriteProcessException {
        if (start >= end) {
            return;
        }
        long[] memIncrements = new long[3];
        String deviceId = insertTabletPlan.getDeviceId().getFullPath();
        long unsealedResourceIncrement = this.tsFileResource.estimateRamIncrement(deviceId);
        for (int i = 0; i < insertTabletPlan.getDataTypes().length; ++i) {
            TSDataType dataType = insertTabletPlan.getDataTypes()[i];
            String measurement = insertTabletPlan.getMeasurements()[i];
            Object column = insertTabletPlan.getColumns()[i];
            if (dataType == null || column == null || measurement == null) continue;
            this.updateMemCost(dataType, measurement, deviceId, start, end, memIncrements, column);
        }
        long memTableIncrement = memIncrements[0];
        long textDataIncrement = memIncrements[1];
        long chunkMetadataIncrement = memIncrements[2];
        this.updateMemoryInfo(memTableIncrement, unsealedResourceIncrement, chunkMetadataIncrement, textDataIncrement);
    }

    private void updateMemCost(TSDataType dataType, String measurement, String deviceId, int start, int end, long[] memIncrements, Object column) {
        if (this.workMemTable.checkIfChunkDoesNotExist(deviceId, measurement)) {
            memIncrements[2] = memIncrements[2] + ChunkMetadata.calculateRamSize((String)measurement, (TSDataType)dataType);
            memIncrements[0] = memIncrements[0] + (long)((end - start) / PrimitiveArrayManager.ARRAY_SIZE + 1) * TVList.tvListArrayMemSize(dataType);
        } else {
            int currentChunkPointNum = this.workMemTable.getCurrentChunkPointNum(deviceId, measurement);
            if (currentChunkPointNum % PrimitiveArrayManager.ARRAY_SIZE == 0) {
                memIncrements[0] = memIncrements[0] + (long)((end - start) / PrimitiveArrayManager.ARRAY_SIZE + 1) * TVList.tvListArrayMemSize(dataType);
            } else {
                int acquireArray = (end - start - 1 + currentChunkPointNum % PrimitiveArrayManager.ARRAY_SIZE) / PrimitiveArrayManager.ARRAY_SIZE;
                memIncrements[0] = memIncrements[0] + (acquireArray == 0 ? 0L : (long)acquireArray * TVList.tvListArrayMemSize(dataType));
            }
        }
        if (dataType == TSDataType.TEXT) {
            Binary[] binColumn = (Binary[])column;
            memIncrements[1] = memIncrements[1] + MemUtils.getBinaryColumnSize(binColumn, start, end);
        }
    }

    private void updateMemoryInfo(long memTableIncrement, long unsealedResourceIncrement, long chunkMetadataIncrement, long textDataIncrement) throws WriteProcessException {
        this.storageGroupInfo.addStorageGroupMemCost(memTableIncrement += textDataIncrement);
        this.tsFileProcessorInfo.addTSPMemCost(unsealedResourceIncrement + chunkMetadataIncrement);
        if (this.storageGroupInfo.needToReportToSystem()) {
            SystemInfo.getInstance().reportStorageGroupStatus(this.storageGroupInfo);
            try {
                StorageEngine.blockInsertionIfReject();
            }
            catch (WriteProcessRejectException e) {
                this.storageGroupInfo.releaseStorageGroupMemCost(memTableIncrement);
                this.tsFileProcessorInfo.releaseTSPMemCost(unsealedResourceIncrement + chunkMetadataIncrement);
                SystemInfo.getInstance().resetStorageGroupStatus(this.storageGroupInfo, false);
                throw e;
            }
        }
        this.workMemTable.addTVListRamCost(memTableIncrement);
        this.workMemTable.addTextDataSize(textDataIncrement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDataInMemory(Deletion deletion, Set<PartialPath> devicePaths) {
        this.flushQueryLock.writeLock().lock();
        if (logger.isDebugEnabled()) {
            logger.debug(FLUSH_QUERY_WRITE_LOCKED, (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
        }
        try {
            if (this.workMemTable != null) {
                for (PartialPath device : devicePaths) {
                    this.workMemTable.delete(deletion.getPath(), device, deletion.getStartTime(), deletion.getEndTime());
                    logger.info("[Deletion] Delete in-memory data with deletion path: {}, time:{}-{}.", new Object[]{deletion.getPath(), deletion.getStartTime(), deletion.getEndTime()});
                }
            }
            if (!this.flushingMemTables.isEmpty()) {
                this.modsToMemtable.add((Pair<Modification, IMemTable>)new Pair((Object)deletion, (Object)this.flushingMemTables.getLast()));
            }
        }
        finally {
            this.flushQueryLock.writeLock().unlock();
            if (logger.isDebugEnabled()) {
                logger.debug(FLUSH_QUERY_WRITE_RELEASE, (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
            }
        }
    }

    public TsFileResource getTsFileResource() {
        return this.tsFileResource;
    }

    public boolean shouldFlush() {
        if (this.workMemTable == null) {
            return false;
        }
        if (this.shouldFlush) {
            logger.info("The memtable size {} of tsfile {} reaches the mem control threshold", (Object)this.workMemTable.memSize(), (Object)this.tsFileResource.getTsFile().getAbsolutePath());
            return true;
        }
        if (!this.enableMemControl && this.workMemTable.memSize() >= this.getMemtableSizeThresholdBasedOnSeriesNum()) {
            logger.info("The memtable size {} of tsfile {} reaches the threshold", (Object)this.workMemTable.memSize(), (Object)this.tsFileResource.getTsFile().getAbsolutePath());
            return true;
        }
        if (this.workMemTable.reachTotalPointNumThreshold()) {
            logger.info("The avg series points num {} of tsfile {} reaches the threshold", (Object)(this.workMemTable.getTotalPointsNum() / (long)this.workMemTable.getSeriesNumber()), (Object)this.tsFileResource.getTsFile().getAbsolutePath());
            return true;
        }
        return false;
    }

    private long getMemtableSizeThresholdBasedOnSeriesNum() {
        return this.config.getMemtableSizeThreshold();
    }

    public boolean shouldClose() {
        long fileSizeThreshold;
        long fileSize = this.tsFileResource.getTsFileSize();
        if (fileSize >= (fileSizeThreshold = IoTDBDescriptor.getInstance().getConfig().getTsFileSizeThreshold())) {
            logger.info("{} fileSize {} >= fileSizeThreshold {}", new Object[]{this.tsFileResource.getTsFilePath(), fileSize, fileSizeThreshold});
        }
        return fileSize >= fileSizeThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncClose() {
        logger.info("Sync close file: {}, will firstly async close it", (Object)this.tsFileResource.getTsFile().getAbsolutePath());
        if (this.shouldClose) {
            return;
        }
        ConcurrentLinkedDeque<IMemTable> concurrentLinkedDeque = this.flushingMemTables;
        synchronized (concurrentLinkedDeque) {
            try {
                this.asyncClose();
                logger.info("Start to wait until file {} is closed", (Object)this.tsFileResource);
                long startTime = System.currentTimeMillis();
                while (!this.flushingMemTables.isEmpty()) {
                    this.flushingMemTables.wait(60000L);
                    if (System.currentTimeMillis() - startTime <= 60000L || this.flushingMemTables.isEmpty()) continue;
                    logger.warn("{} has spent {}s for waiting flushing one memtable; {} left (first: {}). FlushingManager info: {}", new Object[]{this.tsFileResource.getTsFile().getAbsolutePath(), (System.currentTimeMillis() - startTime) / 1000L, this.flushingMemTables.size(), this.flushingMemTables.getFirst(), FlushManager.getInstance()});
                }
            }
            catch (InterruptedException e) {
                logger.error("{}: {} wait close interrupted", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e});
                Thread.currentThread().interrupt();
            }
        }
        logger.info("File {} is closed synchronously", (Object)this.tsFileResource.getTsFile().getAbsolutePath());
    }

    void asyncClose() {
        this.flushQueryLock.writeLock().lock();
        if (logger.isDebugEnabled()) {
            logger.debug(FLUSH_QUERY_WRITE_LOCKED, (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
        }
        try {
            if (logger.isInfoEnabled()) {
                if (this.workMemTable != null) {
                    logger.info("{}: flush a working memtable in async close tsfile {}, memtable size: {}, tsfile size: {}, plan index: [{}, {}]", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), this.workMemTable.memSize(), this.tsFileResource.getTsFileSize(), this.workMemTable.getMinPlanIndex(), this.workMemTable.getMaxPlanIndex()});
                } else {
                    logger.info("{}: flush a NotifyFlushMemTable in async close tsfile {}, tsfile size: {}", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), this.tsFileResource.getTsFileSize()});
                }
            }
            if (this.shouldClose) {
                return;
            }
            NotifyFlushMemTable tmpMemTable = this.workMemTable == null || this.workMemTable.memSize() == 0L ? new NotifyFlushMemTable() : this.workMemTable;
            try {
                this.addAMemtableIntoFlushingList(tmpMemTable);
                logger.info("Memtable {} has been added to flushing list", (Object)tmpMemTable);
                this.shouldClose = true;
            }
            catch (Exception e) {
                logger.error("{}: {} async close failed, because", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e});
            }
        }
        finally {
            this.flushQueryLock.writeLock().unlock();
            if (logger.isDebugEnabled()) {
                logger.debug(FLUSH_QUERY_WRITE_RELEASE, (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncFlush() throws IOException {
        IMemTable tmpMemTable;
        this.flushQueryLock.writeLock().lock();
        if (logger.isDebugEnabled()) {
            logger.debug(FLUSH_QUERY_WRITE_LOCKED, (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
        }
        try {
            IMemTable iMemTable = tmpMemTable = this.workMemTable == null ? new NotifyFlushMemTable() : this.workMemTable;
            if (logger.isDebugEnabled() && tmpMemTable.isSignalMemTable()) {
                logger.debug("{}: {} add a signal memtable into flushing memtable list when sync flush", (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
            }
            this.addAMemtableIntoFlushingList(tmpMemTable);
        }
        finally {
            this.flushQueryLock.writeLock().unlock();
            if (logger.isDebugEnabled()) {
                logger.debug(FLUSH_QUERY_WRITE_RELEASE, (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
            }
        }
        IMemTable iMemTable = tmpMemTable;
        synchronized (iMemTable) {
            try {
                long startWait = System.currentTimeMillis();
                while (this.flushingMemTables.contains(tmpMemTable)) {
                    tmpMemTable.wait(1000L);
                    if (System.currentTimeMillis() - startWait <= 60000L) continue;
                    logger.warn("has waited for synced flushing a memtable in {} for 60 seconds.", (Object)this.tsFileResource.getTsFile().getAbsolutePath());
                    startWait = System.currentTimeMillis();
                }
            }
            catch (InterruptedException e) {
                logger.error("{}: {} wait flush finished meets error", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e});
                Thread.currentThread().interrupt();
            }
        }
    }

    public void asyncFlush() {
        this.flushQueryLock.writeLock().lock();
        if (logger.isDebugEnabled()) {
            logger.debug(FLUSH_QUERY_WRITE_LOCKED, (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
        }
        try {
            if (this.workMemTable == null) {
                return;
            }
            logger.info("Async flush a memtable to tsfile: {}", (Object)this.tsFileResource.getTsFile().getAbsolutePath());
            this.addAMemtableIntoFlushingList(this.workMemTable);
        }
        catch (Exception e) {
            logger.error("{}: {} add a memtable into flushing list failed", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e});
        }
        finally {
            this.flushQueryLock.writeLock().unlock();
            if (logger.isDebugEnabled()) {
                logger.debug(FLUSH_QUERY_WRITE_RELEASE, (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
            }
        }
    }

    private void addAMemtableIntoFlushingList(IMemTable tobeFlushed) throws IOException {
        if (!(tobeFlushed.isSignalMemTable() || this.updateLatestFlushTimeCallback.call(this) && tobeFlushed.memSize() != 0L)) {
            logger.warn("This normal memtable is empty, skip it in flush. {}: {} Memetable info: {}", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), tobeFlushed.getMemTableMap()});
            return;
        }
        for (FlushListener flushListener : this.flushListeners) {
            flushListener.onFlushStart(tobeFlushed);
        }
        this.flushingMemTables.addLast(tobeFlushed);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: {} Memtable (signal = {}) is added into the flushing Memtable, queue size = {}", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), tobeFlushed.isSignalMemTable(), this.flushingMemTables.size()});
        }
        if (!tobeFlushed.isSignalMemTable()) {
            this.totalMemTableSize += tobeFlushed.memSize();
        }
        this.workMemTable = null;
        this.shouldFlush = false;
        FlushManager.getInstance().registerTsFileProcessor(this);
    }

    private void releaseFlushedMemTable(IMemTable memTable) {
        this.flushQueryLock.writeLock().lock();
        if (logger.isDebugEnabled()) {
            logger.debug(FLUSH_QUERY_WRITE_LOCKED, (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
        }
        try {
            this.writer.makeMetadataVisible();
            if (!this.flushingMemTables.remove(memTable)) {
                logger.warn("{}: {} put the memtable (signal={}) out of flushingMemtables but it is not in the queue.", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), memTable.isSignalMemTable()});
            } else if (logger.isDebugEnabled()) {
                logger.debug("{}: {} memtable (signal={}) is removed from the queue. {} left.", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), memTable.isSignalMemTable(), this.flushingMemTables.size()});
            }
            memTable.release();
            MemTableManager.getInstance().decreaseMemtableNumber();
            if (this.enableMemControl) {
                this.storageGroupInfo.releaseStorageGroupMemCost(memTable.getTVListsRamCost());
                if (logger.isDebugEnabled()) {
                    logger.debug("[mem control] {}: {} flush finished, try to reset system memcost, flushing memtable list size: {}", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), this.flushingMemTables.size()});
                }
                SystemInfo.getInstance().resetStorageGroupStatus(this.storageGroupInfo, true);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: {} flush finished, remove a memtable from flushing list, flushing memtable list size: {}", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), this.flushingMemTables.size()});
            }
        }
        catch (Exception e) {
            logger.error("{}: {}", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e});
        }
        finally {
            this.flushQueryLock.writeLock().unlock();
            if (logger.isDebugEnabled()) {
                logger.debug(FLUSH_QUERY_WRITE_RELEASE, (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushOneMemTable() {
        IMemTable memTableToFlush = this.flushingMemTables.getFirst();
        if (!memTableToFlush.isSignalMemTable()) {
            try {
                this.writer.mark();
                MemTableFlushTask flushTask = new MemTableFlushTask(memTableToFlush, this.writer, this.storageGroupName);
                flushTask.syncFlushMemTable();
            }
            catch (Exception e) {
                if (this.writer == null) {
                    logger.info("{}: {} is closed during flush, abandon flush task", (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
                    ConcurrentLinkedDeque<IMemTable> concurrentLinkedDeque = this.flushingMemTables;
                    synchronized (concurrentLinkedDeque) {
                        this.flushingMemTables.notifyAll();
                    }
                }
                logger.error("{}: {} meet error when flushing a memtable, change system mode to read-only", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e});
                IoTDBDescriptor.getInstance().getConfig().setReadOnly(true);
                try {
                    logger.error("{}: {} IOTask meets error, truncate the corrupted data", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e});
                    this.writer.reset();
                }
                catch (IOException e1) {
                    logger.error("{}: {} Truncate corrupted data meets error", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e1});
                }
                Thread.currentThread().interrupt();
            }
        }
        for (FlushListener flushListener : this.flushListeners) {
            flushListener.onFlushEnd(memTableToFlush);
        }
        try {
            Iterator<Pair<Modification, IMemTable>> iterator = this.modsToMemtable.iterator();
            while (iterator.hasNext()) {
                Pair<Modification, IMemTable> entry = iterator.next();
                if (!((IMemTable)entry.right).equals(memTableToFlush)) continue;
                ((Modification)entry.left).setFileOffset(this.tsFileResource.getTsFileSize());
                this.tsFileResource.getModFile().write((Modification)entry.left);
                this.tsFileResource.getModFile().close();
                iterator.remove();
                logger.info("[Deletion] Deletion with path: {}, time:{}-{} written when flush memtable", new Object[]{((Modification)entry.left).getPath(), ((Deletion)entry.left).getStartTime(), ((Deletion)entry.left).getEndTime()});
            }
        }
        catch (IOException e) {
            logger.error("Meet error when writing into ModificationFile file of {} ", (Object)this.tsFileResource.getTsFile().getName(), (Object)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: {} try get lock to release a memtable (signal={})", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), memTableToFlush.isSignalMemTable()});
        }
        IMemTable e = memTableToFlush;
        synchronized (e) {
            this.releaseFlushedMemTable(memTableToFlush);
            memTableToFlush.notifyAll();
            if (logger.isDebugEnabled()) {
                logger.debug("{}: {} released a memtable (signal={}), flushingMemtables size ={}", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), memTableToFlush.isSignalMemTable(), this.flushingMemTables.size()});
            }
        }
        if (this.shouldClose && this.flushingMemTables.isEmpty() && this.writer != null) {
            try {
                this.writer.mark();
                this.updateCompressionRatio(memTableToFlush);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: {} flushingMemtables is empty and will close the file", (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
                }
                this.endFile();
                if (logger.isDebugEnabled()) {
                    logger.debug("{} flushingMemtables is clear", (Object)this.storageGroupName);
                }
            }
            catch (Exception e2) {
                logger.error("{} meet error when flush FileMetadata to {}, change system mode to read-only", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), e2});
                IoTDBDescriptor.getInstance().getConfig().setReadOnly(true);
                try {
                    this.writer.reset();
                }
                catch (IOException e1) {
                    logger.error("{}: {} truncate corrupted data meets error", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e1});
                }
                logger.error("{}: {} marking or ending file meet error", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e2});
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: {} try to get flushingMemtables lock.", (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
            }
            ConcurrentLinkedDeque<IMemTable> concurrentLinkedDeque = this.flushingMemTables;
            synchronized (concurrentLinkedDeque) {
                this.flushingMemTables.notifyAll();
            }
        }
    }

    private void updateCompressionRatio(IMemTable memTableToFlush) {
        try {
            double compressionRatio = (double)this.totalMemTableSize / (double)this.writer.getPos();
            if (logger.isDebugEnabled()) {
                logger.debug("The compression ratio of tsfile {} is {}, totalMemTableSize: {}, the file size: {}", new Object[]{this.writer.getFile().getAbsolutePath(), compressionRatio, this.totalMemTableSize, this.writer.getPos()});
            }
            if (compressionRatio == 0.0 && !memTableToFlush.isSignalMemTable()) {
                logger.error("{} The compression ratio of tsfile {} is 0, totalMemTableSize: {}, the file size: {}", new Object[]{this.storageGroupName, this.writer.getFile().getAbsolutePath(), this.totalMemTableSize, this.writer.getPos()});
            }
            CompressionRatio.getInstance().updateRatio(compressionRatio);
        }
        catch (IOException e) {
            logger.error("{}: {} update compression ratio failed", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e});
        }
    }

    private void endFile() throws IOException, TsFileProcessorException {
        logger.info("Start to end file {}", (Object)this.tsFileResource);
        long closeStartTime = System.currentTimeMillis();
        this.tsFileResource.serialize();
        this.writer.endFile();
        logger.info("Ended file {}", (Object)this.tsFileResource);
        for (CloseFileListener closeFileListener : this.closeFileListeners) {
            closeFileListener.onClosed(this);
        }
        if (this.enableMemControl) {
            this.tsFileProcessorInfo.clear();
            this.storageGroupInfo.closeTsFileProcessorAndReportToSystem(this);
        }
        if (logger.isInfoEnabled()) {
            long closeEndTime = System.currentTimeMillis();
            logger.info("Storage group {} close the file {}, TsFile size is {}, time consumption of flushing metadata is {}ms", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsoluteFile(), this.writer.getFile().length(), closeEndTime - closeStartTime});
        }
        this.writer = null;
    }

    public boolean isManagedByFlushManager() {
        return this.managedByFlushManager;
    }

    public void setManagedByFlushManager(boolean managedByFlushManager) {
        this.managedByFlushManager = managedByFlushManager;
    }

    public WriteLogNode getLogNode() {
        if (this.logNode == null) {
            this.logNode = MultiFileLogNodeManager.getInstance().getNode(this.storageGroupName + "-" + this.tsFileResource.getTsFile().getName(), this.storageGroupInfo.getWalSupplier());
        }
        return this.logNode;
    }

    public void close() throws TsFileProcessorException {
        try {
            this.tsFileResource.close();
            MultiFileLogNodeManager.getInstance().deleteNode(this.storageGroupName + "-" + this.tsFileResource.getTsFile().getName(), this.storageGroupInfo.getWalConsumer());
        }
        catch (IOException e) {
            throw new TsFileProcessorException(e);
        }
    }

    public int getFlushingMemTableSize() {
        return this.flushingMemTables.size();
    }

    RestorableTsFileIOWriter getWriter() {
        return this.writer;
    }

    public String getStorageGroupName() {
        return this.storageGroupName;
    }

    private List<Modification> getModificationsForMemtable(IMemTable memTable) {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        boolean foundMemtable = false;
        for (Pair<Modification, IMemTable> entry : this.modsToMemtable) {
            if (!foundMemtable && !((IMemTable)entry.right).equals(memTable)) continue;
            modifications.add((Modification)entry.left);
            foundMemtable = true;
        }
        return modifications;
    }

    private List<TimeRange> constructDeletionList(IMemTable memTable, String deviceId, String measurement, long timeLowerBound) throws MetadataException {
        ArrayList<TimeRange> deletionList = new ArrayList<TimeRange>();
        deletionList.add(new TimeRange(Long.MIN_VALUE, timeLowerBound));
        for (Modification modification : this.getModificationsForMemtable(memTable)) {
            Deletion deletion;
            if (!(modification instanceof Deletion) || !(deletion = (Deletion)modification).getPath().matchFullPath(new PartialPath(deviceId, measurement)) || deletion.getEndTime() <= timeLowerBound) continue;
            long lowerBound = Math.max(deletion.getStartTime(), timeLowerBound);
            deletionList.add(new TimeRange(lowerBound, deletion.getEndTime()));
        }
        return TimeRange.sortAndMerge(deletionList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void query(String deviceId, String measurementId, TSDataType dataType, TSEncoding encoding, Map<String, String> props, QueryContext context, List<TsFileResource> tsfileResourcesForQuery) throws IOException, MetadataException {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: {} get flushQueryLock and hotCompactionMergeLock read lock", (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
        }
        this.flushQueryLock.readLock().lock();
        try {
            ReadOnlyMemChunk memChunk;
            ArrayList<ReadOnlyMemChunk> readOnlyMemChunks = new ArrayList<ReadOnlyMemChunk>();
            for (IMemTable flushingMemTable : this.flushingMemTables) {
                if (flushingMemTable.isSignalMemTable()) continue;
                List<TimeRange> deletionList = this.constructDeletionList(flushingMemTable, deviceId, measurementId, context.getQueryTimeLowerBound());
                ReadOnlyMemChunk memChunk2 = flushingMemTable.query(deviceId, measurementId, dataType, encoding, props, context.getQueryTimeLowerBound(), deletionList);
                if (memChunk2 == null) continue;
                readOnlyMemChunks.add(memChunk2);
            }
            if (this.workMemTable != null && (memChunk = this.workMemTable.query(deviceId, measurementId, dataType, encoding, props, context.getQueryTimeLowerBound(), null)) != null) {
                readOnlyMemChunks.add(memChunk);
            }
            ModificationFile modificationFile = this.tsFileResource.getModFile();
            List<Modification> modifications = context.getPathModifications(modificationFile, new PartialPath(deviceId + '.' + measurementId));
            List chunkMetadataList = this.writer.getVisibleMetadataList(deviceId, measurementId, dataType);
            QueryUtils.modifyChunkMetaData(chunkMetadataList, modifications);
            chunkMetadataList.removeIf(context::chunkNotSatisfy);
            if (!readOnlyMemChunks.isEmpty() || !chunkMetadataList.isEmpty()) {
                tsfileResourcesForQuery.add(new TsFileResource(readOnlyMemChunks, chunkMetadataList, this.tsFileResource));
            }
        }
        catch (QueryProcessException e) {
            logger.error("{}: {} get ReadOnlyMemChunk has error", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e});
        }
        finally {
            this.flushQueryLock.readLock().unlock();
            if (logger.isDebugEnabled()) {
                logger.debug("{}: {} release flushQueryLock", (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
            }
        }
    }

    public long getTimeRangeId() {
        return this.timeRangeId;
    }

    public void setTimeRangeId(long timeRangeId) {
        this.timeRangeId = timeRangeId;
    }

    public void putMemTableBackAndClose() throws TsFileProcessorException {
        if (this.workMemTable != null) {
            this.workMemTable.release();
            this.workMemTable = null;
        }
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new TsFileProcessorException(e);
        }
    }

    public TsFileProcessorInfo getTsFileProcessorInfo() {
        return this.tsFileProcessorInfo;
    }

    public void setTsFileProcessorInfo(TsFileProcessorInfo tsFileProcessorInfo) {
        this.tsFileProcessorInfo = tsFileProcessorInfo;
    }

    public long getWorkMemTableRamCost() {
        return this.workMemTable != null ? this.workMemTable.getTVListsRamCost() : 0L;
    }

    public boolean isSequence() {
        return this.sequence;
    }

    public void startAsyncFlush() {
        this.storageGroupInfo.getStorageGroupProcessor().asyncFlushMemTableInTsFileProcessor(this);
    }

    public void setFlush() {
        this.shouldFlush = true;
    }

    public void addFlushListener(FlushListener listener) {
        this.flushListeners.add(listener);
    }

    public void addCloseFileListener(CloseFileListener listener) {
        this.closeFileListeners.add(listener);
    }

    public void addFlushListeners(Collection<FlushListener> listeners) {
        this.flushListeners.addAll(listeners);
    }

    public void addCloseFileListeners(Collection<CloseFileListener> listeners) {
        this.closeFileListeners.addAll(listeners);
    }
}

