/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.rescon.SystemInfo;
import org.apache.iotdb.db.utils.MmapUtil;

public class StorageGroupInfo {
    private StorageGroupProcessor storageGroupProcessor;
    private AtomicLong memoryCost;
    private long storageGroupSizeReportThreshold = IoTDBDescriptor.getInstance().getConfig().getStorageGroupSizeReportThreshold();
    private AtomicLong lastReportedSize = new AtomicLong();
    private List<TsFileProcessor> reportedTsps = new CopyOnWriteArrayList<TsFileProcessor>();

    public StorageGroupInfo(StorageGroupProcessor storageGroupProcessor) {
        this.storageGroupProcessor = storageGroupProcessor;
        this.memoryCost = new AtomicLong();
    }

    public StorageGroupProcessor getStorageGroupProcessor() {
        return this.storageGroupProcessor;
    }

    public void initTsFileProcessorInfo(TsFileProcessor tsFileProcessor) {
        if (this.reportedTsps.add(tsFileProcessor)) {
            this.memoryCost.getAndAdd(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize());
        }
    }

    public void addStorageGroupMemCost(long cost) {
        this.memoryCost.getAndAdd(cost);
    }

    public void releaseStorageGroupMemCost(long cost) {
        this.memoryCost.getAndAdd(-cost);
    }

    public long getMemCost() {
        return this.memoryCost.get();
    }

    public List<TsFileProcessor> getAllReportedTsp() {
        return this.reportedTsps;
    }

    public boolean needToReportToSystem() {
        return this.memoryCost.get() - this.lastReportedSize.get() > this.storageGroupSizeReportThreshold;
    }

    public void setLastReportedSize(long size) {
        this.lastReportedSize.set(size);
    }

    public void closeTsFileProcessorAndReportToSystem(TsFileProcessor tsFileProcessor) {
        this.reportedTsps.remove(tsFileProcessor);
        SystemInfo.getInstance().resetStorageGroupStatus(this, true);
    }

    public Supplier<ByteBuffer[]> getWalSupplier() {
        if (this.storageGroupProcessor != null) {
            return this.storageGroupProcessor::getWalDirectByteBuffer;
        }
        return this::walSupplier;
    }

    private ByteBuffer[] walSupplier() {
        ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
        return buffers;
    }

    public Consumer<ByteBuffer[]> getWalConsumer() {
        if (this.storageGroupProcessor != null) {
            return this.storageGroupProcessor::releaseWalBuffer;
        }
        return this::walConsumer;
    }

    private void walConsumer(ByteBuffer[] buffers) {
        for (ByteBuffer byteBuffer : buffers) {
            MmapUtil.clean((MappedByteBuffer)byteBuffer);
        }
    }
}

