/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge.manage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.reader.resource.CachedUnseqResourceMergeReader;
import org.apache.iotdb.db.utils.MergeUtils;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;

public class MergeResource {
    private List<TsFileResource> seqFiles;
    private List<TsFileResource> unseqFiles;
    private Map<TsFileResource, TsFileSequenceReader> fileReaderCache = new HashMap<TsFileResource, TsFileSequenceReader>();
    private Map<TsFileResource, RestorableTsFileIOWriter> fileWriterCache = new HashMap<TsFileResource, RestorableTsFileIOWriter>();
    private Map<TsFileResource, List<Modification>> modificationCache = new HashMap<TsFileResource, List<Modification>>();
    private Map<TsFileResource, Map<String, Pair<Long, Long>>> startEndTimeCache = new HashMap<TsFileResource, Map<String, Pair<Long, Long>>>();
    private Map<PartialPath, MeasurementSchema> measurementSchemaMap = new HashMap<PartialPath, MeasurementSchema>();
    private Map<MeasurementSchema, IChunkWriter> chunkWriterCache = new ConcurrentHashMap<MeasurementSchema, IChunkWriter>();
    private long timeLowerBound = Long.MIN_VALUE;
    private boolean cacheDeviceMeta = false;

    public MergeResource(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles) {
        this.seqFiles = seqFiles.stream().filter(this::filterResource).collect(Collectors.toList());
        this.unseqFiles = unseqFiles.stream().filter(this::filterResource).collect(Collectors.toList());
    }

    private boolean filterResource(TsFileResource res) {
        return res.getTsFile().exists() && !res.isDeleted() && (!res.isClosed() || res.stillLives(this.timeLowerBound));
    }

    public MergeResource(Collection<TsFileResource> seqFiles, List<TsFileResource> unseqFiles, long timeLowerBound) {
        this.timeLowerBound = timeLowerBound;
        this.seqFiles = seqFiles.stream().filter(this::filterResource).collect(Collectors.toList());
        this.unseqFiles = unseqFiles.stream().filter(this::filterResource).collect(Collectors.toList());
    }

    public void clear() throws IOException {
        for (TsFileSequenceReader sequenceReader : this.fileReaderCache.values()) {
            sequenceReader.close();
        }
        for (RestorableTsFileIOWriter writer : this.fileWriterCache.values()) {
            writer.close();
        }
        this.fileReaderCache.clear();
        this.fileWriterCache.clear();
        this.modificationCache.clear();
        this.measurementSchemaMap.clear();
        this.chunkWriterCache.clear();
    }

    public MeasurementSchema getSchema(PartialPath path) {
        return this.measurementSchemaMap.get(path);
    }

    public RestorableTsFileIOWriter getMergeFileWriter(TsFileResource resource) throws IOException {
        RestorableTsFileIOWriter writer = this.fileWriterCache.get(resource);
        if (writer == null) {
            writer = new RestorableTsFileIOWriter(FSFactoryProducer.getFSFactory().getFile(resource.getTsFilePath() + ".merge"));
            this.fileWriterCache.put(resource, writer);
        }
        return writer;
    }

    public List<ChunkMetadata> queryChunkMetadata(PartialPath path, TsFileResource seqFile) throws IOException {
        TsFileSequenceReader sequenceReader = this.getFileReader(seqFile);
        return sequenceReader.getChunkMetadataList((Path)path);
    }

    public TsFileSequenceReader getFileReader(TsFileResource tsFileResource) throws IOException {
        TsFileSequenceReader reader = this.fileReaderCache.get(tsFileResource);
        if (reader == null) {
            reader = new TsFileSequenceReader(tsFileResource.getTsFilePath(), true, this.cacheDeviceMeta);
            this.fileReaderCache.put(tsFileResource, reader);
        }
        return reader;
    }

    public IPointReader[] getUnseqReaders(List<PartialPath> paths) throws IOException {
        List<Chunk>[] pathChunks = MergeUtils.collectUnseqChunks(paths, this.unseqFiles, this);
        IPointReader[] ret = new IPointReader[paths.size()];
        for (int i = 0; i < paths.size(); ++i) {
            TSDataType dataType = this.getSchema(paths.get(i)).getType();
            ret[i] = new CachedUnseqResourceMergeReader(pathChunks[i], dataType);
        }
        return ret;
    }

    public IChunkWriter getChunkWriter(MeasurementSchema measurementSchema) {
        return this.chunkWriterCache.computeIfAbsent(measurementSchema, ChunkWriterImpl::new);
    }

    public List<Modification> getModifications(TsFileResource tsFileResource, PartialPath path) {
        List modifications = this.modificationCache.computeIfAbsent(tsFileResource, resource -> new LinkedList<Modification>(resource.getModFile().getModifications()));
        ArrayList<Modification> pathModifications = new ArrayList<Modification>();
        for (Modification modification : modifications) {
            if (!modification.getPath().matchFullPath(path)) continue;
            pathModifications.add(modification);
        }
        return pathModifications;
    }

    public void removeFileAndWriter(TsFileResource tsFileResource) throws IOException {
        RestorableTsFileIOWriter newFileWriter = this.fileWriterCache.remove(tsFileResource);
        if (newFileWriter != null) {
            newFileWriter.close();
            newFileWriter.getFile().delete();
        }
    }

    public void removeFileReader(TsFileResource resource) throws IOException {
        TsFileSequenceReader sequenceReader = this.fileReaderCache.remove(resource);
        if (sequenceReader != null) {
            sequenceReader.close();
        }
    }

    public List<TsFileResource> getSeqFiles() {
        return this.seqFiles;
    }

    public void setSeqFiles(List<TsFileResource> seqFiles) {
        this.seqFiles = seqFiles;
    }

    public List<TsFileResource> getUnseqFiles() {
        return this.unseqFiles;
    }

    public void setUnseqFiles(List<TsFileResource> unseqFiles) {
        this.unseqFiles = unseqFiles;
    }

    public void removeOutdatedSeqReaders() throws IOException {
        Iterator<Map.Entry<TsFileResource, TsFileSequenceReader>> entryIterator = this.fileReaderCache.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<TsFileResource, TsFileSequenceReader> entry = entryIterator.next();
            TsFileResource tsFile = entry.getKey();
            if (this.seqFiles.contains(tsFile)) continue;
            TsFileSequenceReader reader = entry.getValue();
            reader.close();
            entryIterator.remove();
        }
    }

    public void setCacheDeviceMeta(boolean cacheDeviceMeta) {
        this.cacheDeviceMeta = cacheDeviceMeta;
    }

    public void setMeasurementSchemaMap(Map<PartialPath, MeasurementSchema> measurementSchemaMap) {
        this.measurementSchemaMap = measurementSchemaMap;
    }

    public void clearChunkWriterCache() {
        this.chunkWriterCache.clear();
    }

    public void updateStartTime(TsFileResource tsFileResource, String device, long startTime) {
        Map deviceStartEndTimePairMap = this.startEndTimeCache.getOrDefault(tsFileResource, new HashMap());
        Pair startEndTimePair = deviceStartEndTimePairMap.getOrDefault(device, new Pair((Object)Long.MAX_VALUE, (Object)Long.MIN_VALUE));
        long newStartTime = (Long)startEndTimePair.left > startTime ? startTime : (Long)startEndTimePair.left;
        deviceStartEndTimePairMap.put(device, new Pair((Object)newStartTime, (Object)((Long)startEndTimePair.right)));
        this.startEndTimeCache.put(tsFileResource, deviceStartEndTimePairMap);
    }

    public void updateEndTime(TsFileResource tsFileResource, String device, long endTime) {
        Map deviceStartEndTimePairMap = this.startEndTimeCache.getOrDefault(tsFileResource, new HashMap());
        Pair startEndTimePair = deviceStartEndTimePairMap.getOrDefault(device, new Pair((Object)Long.MAX_VALUE, (Object)Long.MIN_VALUE));
        long newEndTime = (Long)startEndTimePair.right < endTime ? endTime : (Long)startEndTimePair.right;
        deviceStartEndTimePairMap.put(device, new Pair((Object)((Long)startEndTimePair.left), (Object)newEndTime));
        this.startEndTimeCache.put(tsFileResource, deviceStartEndTimePairMap);
    }

    public Map<String, Pair<Long, Long>> getStartEndTime(TsFileResource tsFileResource) {
        return this.startEndTimeCache.getOrDefault(tsFileResource, new HashMap());
    }
}

