/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.utils;

import com.google.common.util.concurrent.RateLimiter;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections4.keyvalue.DefaultMapEntry;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.TsFileManagement;
import org.apache.iotdb.db.engine.compaction.utils.CompactionLogger;
import org.apache.iotdb.db.engine.merge.manage.MergeManager;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.MergeUtils;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.reader.BatchDataIterator;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReaderByTimestamp;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionUtils {
    private static final Logger logger = LoggerFactory.getLogger(CompactionUtils.class);
    private static final int MERGE_PAGE_POINT_NUM = IoTDBDescriptor.getInstance().getConfig().getMergePagePointNumberThreshold();

    private CompactionUtils() {
        throw new IllegalStateException("Utility class");
    }

    private static Pair<ChunkMetadata, Chunk> readByAppendMerge(Map<TsFileSequenceReader, List<ChunkMetadata>> readerChunkMetadataMap, Map<String, List<Modification>> modificationCache, PartialPath seriesPath, List<Modification> modifications) throws IOException {
        ChunkMetadata newChunkMetadata = null;
        Chunk newChunk = null;
        for (Map.Entry<TsFileSequenceReader, List<ChunkMetadata>> entry : readerChunkMetadataMap.entrySet()) {
            TsFileSequenceReader reader = entry.getKey();
            List<ChunkMetadata> chunkMetadataList = entry.getValue();
            CompactionUtils.modifyChunkMetaDataWithCache(reader, chunkMetadataList, modificationCache, seriesPath, modifications);
            for (ChunkMetadata chunkMetadata : chunkMetadataList) {
                Chunk chunk = reader.readMemChunk(chunkMetadata);
                if (newChunkMetadata == null) {
                    newChunkMetadata = chunkMetadata;
                    newChunk = chunk;
                    continue;
                }
                newChunk.mergeChunk(chunk);
                newChunkMetadata.mergeChunkMetadata(chunkMetadata);
            }
        }
        return new Pair(newChunkMetadata, newChunk);
    }

    private static void readByDeserializeMerge(Map<TsFileSequenceReader, List<ChunkMetadata>> readerChunkMetadataMap, Map<Long, TimeValuePair> timeValuePairMap, Map<String, List<Modification>> modificationCache, PartialPath seriesPath, List<Modification> modifications) throws IOException {
        for (Map.Entry<TsFileSequenceReader, List<ChunkMetadata>> entry : readerChunkMetadataMap.entrySet()) {
            TsFileSequenceReader reader = entry.getKey();
            List<ChunkMetadata> chunkMetadataList = entry.getValue();
            CompactionUtils.modifyChunkMetaDataWithCache(reader, chunkMetadataList, modificationCache, seriesPath, modifications);
            for (ChunkMetadata chunkMetadata : chunkMetadataList) {
                ChunkReaderByTimestamp chunkReader = new ChunkReaderByTimestamp(reader.readMemChunk(chunkMetadata));
                while (chunkReader.hasNextSatisfiedPage()) {
                    BatchDataIterator iPointReader = new BatchDataIterator(chunkReader.nextPageData());
                    while (iPointReader.hasNextTimeValuePair()) {
                        TimeValuePair timeValuePair = iPointReader.nextTimeValuePair();
                        timeValuePairMap.put(timeValuePair.getTimestamp(), timeValuePair);
                    }
                }
            }
        }
    }

    public static void writeByAppendMerge(String device, RateLimiter compactionWriteRateLimiter, Map.Entry<String, Map<TsFileSequenceReader, List<ChunkMetadata>>> entry, TsFileResource targetResource, RestorableTsFileIOWriter writer, Map<String, List<Modification>> modificationCache, List<Modification> modifications) throws IOException, IllegalPathException {
        Pair<ChunkMetadata, Chunk> chunkPair = CompactionUtils.readByAppendMerge(entry.getValue(), modificationCache, new PartialPath(device, entry.getKey()), modifications);
        ChunkMetadata newChunkMetadata = (ChunkMetadata)chunkPair.left;
        Chunk newChunk = (Chunk)chunkPair.right;
        if (newChunkMetadata != null && newChunk != null) {
            MergeManager.mergeRateLimiterAcquire(compactionWriteRateLimiter, (long)newChunk.getHeader().getDataSize() + (long)newChunk.getData().position());
            writer.writeChunk(newChunk, newChunkMetadata);
            targetResource.updateStartTime(device, newChunkMetadata.getStartTime());
            targetResource.updateEndTime(device, newChunkMetadata.getEndTime());
        }
    }

    public static void writeByDeserializeMerge(String device, RateLimiter compactionRateLimiter, Map.Entry<String, Map<TsFileSequenceReader, List<ChunkMetadata>>> entry, TsFileResource targetResource, RestorableTsFileIOWriter writer, Map<String, List<Modification>> modificationCache, List<Modification> modifications) throws IOException, IllegalPathException {
        ChunkWriterImpl chunkWriter;
        TreeMap<Long, TimeValuePair> timeValuePairMap = new TreeMap<Long, TimeValuePair>();
        Map<TsFileSequenceReader, List<ChunkMetadata>> readerChunkMetadataMap = entry.getValue();
        CompactionUtils.readByDeserializeMerge(readerChunkMetadataMap, timeValuePairMap, modificationCache, new PartialPath(device, entry.getKey()), modifications);
        boolean isChunkMetadataEmpty = true;
        for (List<ChunkMetadata> chunkMetadataList : readerChunkMetadataMap.values()) {
            if (chunkMetadataList.isEmpty()) continue;
            isChunkMetadataEmpty = false;
            break;
        }
        if (isChunkMetadataEmpty) {
            return;
        }
        try {
            chunkWriter = new ChunkWriterImpl(IoTDB.metaManager.getSeriesSchema(new PartialPath(device), entry.getKey()), true);
        }
        catch (MetadataException e) {
            logger.error("{} get schema {} error, skip this sensor", new Object[]{device, entry.getKey(), e});
            return;
        }
        for (TimeValuePair timeValuePair : timeValuePairMap.values()) {
            MergeUtils.writeTVPair(timeValuePair, (IChunkWriter)chunkWriter);
            targetResource.updateStartTime(device, timeValuePair.getTimestamp());
            targetResource.updateEndTime(device, timeValuePair.getTimestamp());
        }
        MergeManager.mergeRateLimiterAcquire(compactionRateLimiter, chunkWriter.getCurrentChunkSize());
        chunkWriter.writeToFileWriter((TsFileIOWriter)writer);
    }

    private static Set<String> getTsFileDevicesSet(List<TsFileResource> subLevelResources, Map<String, TsFileSequenceReader> tsFileSequenceReaderMap, String storageGroup) throws IOException {
        HashSet<String> tsFileDevicesSet = new HashSet<String>();
        for (TsFileResource levelResource : subLevelResources) {
            TsFileSequenceReader reader = CompactionUtils.buildReaderFromTsFileResource(levelResource, tsFileSequenceReaderMap, storageGroup);
            if (reader == null) continue;
            tsFileDevicesSet.addAll(reader.getAllDevices());
        }
        return tsFileDevicesSet;
    }

    private static boolean hasNextChunkMetadataList(Collection<Iterator<Map<String, List<ChunkMetadata>>>> iteratorSet) {
        boolean hasNextChunkMetadataList = false;
        for (Iterator<Map<String, List<ChunkMetadata>>> iterator : iteratorSet) {
            hasNextChunkMetadataList = hasNextChunkMetadataList || iterator.hasNext();
        }
        return hasNextChunkMetadataList;
    }

    public static void merge(TsFileResource targetResource, List<TsFileResource> tsFileResources, String storageGroup, CompactionLogger compactionLogger, Set<String> devices, boolean sequence, List<Modification> modifications) throws IOException, IllegalPathException {
        RestorableTsFileIOWriter writer = new RestorableTsFileIOWriter(targetResource.getTsFile());
        HashMap<String, TsFileSequenceReader> tsFileSequenceReaderMap = new HashMap<String, TsFileSequenceReader>();
        HashMap<String, List<Modification>> modificationCache = new HashMap<String, List<Modification>>();
        RateLimiter compactionWriteRateLimiter = MergeManager.getINSTANCE().getMergeWriteRateLimiter();
        Set<String> tsFileDevicesMap = CompactionUtils.getTsFileDevicesSet(tsFileResources, tsFileSequenceReaderMap, storageGroup);
        for (String device : tsFileDevicesMap) {
            if (devices.contains(device)) continue;
            writer.startChunkGroup(device);
            TreeMap<TsFileSequenceReader, Object> chunkMetadataListCacheForMerge = new TreeMap<TsFileSequenceReader, Object>((o1, o2) -> TsFileManagement.compareFileName(new File(o1.getFileName()), new File(o2.getFileName())));
            TreeMap<TsFileSequenceReader, Iterator> chunkMetadataListIteratorCache = new TreeMap<TsFileSequenceReader, Iterator>((o1, o2) -> TsFileManagement.compareFileName(new File(o1.getFileName()), new File(o2.getFileName())));
            for (TsFileResource tsFileResource : tsFileResources) {
                TsFileSequenceReader reader = CompactionUtils.buildReaderFromTsFileResource(tsFileResource, tsFileSequenceReaderMap, storageGroup);
                if (reader == null) {
                    throw new IOException();
                }
                Iterator iterator = reader.getMeasurementChunkMetadataListMapIterator(device);
                chunkMetadataListIteratorCache.put(reader, iterator);
                chunkMetadataListCacheForMerge.put(reader, new TreeMap());
            }
            while (CompactionUtils.hasNextChunkMetadataList(chunkMetadataListIteratorCache.values())) {
                String lastSensor = null;
                HashSet allSensors = new HashSet();
                for (Map.Entry chunkMetadataListCacheForMergeEntry : chunkMetadataListCacheForMerge.entrySet()) {
                    TsFileSequenceReader reader = (TsFileSequenceReader)chunkMetadataListCacheForMergeEntry.getKey();
                    Object sensorChunkMetadataListMap = (Map)chunkMetadataListCacheForMergeEntry.getValue();
                    if (sensorChunkMetadataListMap.size() <= 0) {
                        if (!((Iterator)chunkMetadataListIteratorCache.get(reader)).hasNext()) continue;
                        sensorChunkMetadataListMap = (Map)((Iterator)chunkMetadataListIteratorCache.get(reader)).next();
                        chunkMetadataListCacheForMerge.put(reader, sensorChunkMetadataListMap);
                    }
                    String string = (String)Collections.max(sensorChunkMetadataListMap.keySet());
                    if (lastSensor == null) {
                        lastSensor = string;
                    } else if (string.compareTo(lastSensor) < 0) {
                        lastSensor = string;
                    }
                    allSensors.addAll(sensorChunkMetadataListMap.keySet());
                }
                for (String sensor : allSensors) {
                    boolean bl;
                    if (sensor.compareTo(lastSensor) > 0) continue;
                    TreeMap<TsFileSequenceReader, List> readerChunkMetadataListMap = new TreeMap<TsFileSequenceReader, List>((o1, o2) -> TsFileManagement.compareFileName(new File(o1.getFileName()), new File(o2.getFileName())));
                    for (Map.Entry entry : chunkMetadataListCacheForMerge.entrySet()) {
                        TsFileSequenceReader reader = (TsFileSequenceReader)entry.getKey();
                        Map sensorChunkMetadataListMap = (Map)entry.getValue();
                        if (!sensorChunkMetadataListMap.containsKey(sensor)) continue;
                        readerChunkMetadataListMap.put(reader, (List)sensorChunkMetadataListMap.get(sensor));
                        sensorChunkMetadataListMap.remove(sensor);
                    }
                    DefaultMapEntry sensorReaderChunkMetadataListEntry = new DefaultMapEntry((Object)sensor, readerChunkMetadataListMap);
                    if (!sequence) {
                        CompactionUtils.writeByDeserializeMerge(device, compactionWriteRateLimiter, (Map.Entry<String, Map<TsFileSequenceReader, List<ChunkMetadata>>>)sensorReaderChunkMetadataListEntry, targetResource, writer, modificationCache, modifications);
                        continue;
                    }
                    boolean bl2 = true;
                    block6: for (List chunkMetadatas : readerChunkMetadataListMap.values()) {
                        for (ChunkMetadata chunkMetadata : chunkMetadatas) {
                            if (chunkMetadata.getNumOfPoints() >= (long)MERGE_PAGE_POINT_NUM) continue;
                            bl = false;
                            continue block6;
                        }
                    }
                    if (bl) {
                        logger.debug("{} [Compaction] page enough large, use append merge", (Object)storageGroup);
                        CompactionUtils.writeByAppendMerge(device, compactionWriteRateLimiter, (Map.Entry<String, Map<TsFileSequenceReader, List<ChunkMetadata>>>)sensorReaderChunkMetadataListEntry, targetResource, writer, modificationCache, modifications);
                        continue;
                    }
                    logger.debug("{} [Compaction] page too small, use deserialize merge", (Object)storageGroup);
                    CompactionUtils.writeByDeserializeMerge(device, compactionWriteRateLimiter, (Map.Entry<String, Map<TsFileSequenceReader, List<ChunkMetadata>>>)sensorReaderChunkMetadataListEntry, targetResource, writer, modificationCache, modifications);
                }
            }
            writer.endChunkGroup();
            if (compactionLogger == null) continue;
            compactionLogger.logDevice(device, writer.getPos());
        }
        for (TsFileSequenceReader reader : tsFileSequenceReaderMap.values()) {
            reader.close();
        }
        for (TsFileResource tsFileResource : tsFileResources) {
            targetResource.updatePlanIndexes(tsFileResource);
        }
        targetResource.serialize();
        writer.endFile();
        targetResource.close();
    }

    private static TsFileSequenceReader buildReaderFromTsFileResource(TsFileResource levelResource, Map<String, TsFileSequenceReader> tsFileSequenceReaderMap, String storageGroup) {
        return tsFileSequenceReaderMap.computeIfAbsent(levelResource.getTsFile().getAbsolutePath(), path -> {
            try {
                if (levelResource.getTsFile().exists()) {
                    return new TsFileSequenceReader(path);
                }
                logger.info("{} tsfile does not exist", path);
                return null;
            }
            catch (IOException e) {
                logger.error("Storage group {}, flush recover meets error. reader create failed.", (Object)storageGroup, (Object)e);
                return null;
            }
        });
    }

    private static void modifyChunkMetaDataWithCache(TsFileSequenceReader reader, List<ChunkMetadata> chunkMetadataList, Map<String, List<Modification>> modificationCache, PartialPath seriesPath, List<Modification> usedModifications) {
        List modifications = modificationCache.computeIfAbsent(reader.getFileName(), fileName -> new LinkedList<Modification>(new ModificationFile(fileName + ".mods").getModifications()));
        LinkedList<Modification> seriesModifications = new LinkedList<Modification>();
        for (Modification modification : modifications) {
            if (!modification.getPath().matchFullPath(seriesPath)) continue;
            seriesModifications.add(modification);
            usedModifications.add(modification);
        }
        QueryUtils.modifyChunkMetaData(chunkMetadataList, seriesModifications);
    }
}

