/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.common.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.Set;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.utils.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSFileDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(TSFileDescriptor.class);
    private TSFileConfig conf = new TSFileConfig();

    private TSFileDescriptor() {
        this.loadProps();
    }

    public static TSFileDescriptor getInstance() {
        return TsfileDescriptorHolder.INSTANCE;
    }

    public TSFileConfig getConfig() {
        return this.conf;
    }

    private void multiplicityWarning(String resource, ClassLoader classLoader) {
        try {
            Set<URL> urlSet = Loader.getResources(resource, classLoader);
            if (urlSet != null && urlSet.size() > 1) {
                logger.warn("Resource [{}] occurs multiple times on the classpath", (Object)resource);
                for (URL url : urlSet) {
                    logger.warn("Resource [{}] occurs at [{}]", (Object)resource, (Object)url);
                }
            }
        }
        catch (IOException e) {
            logger.error("Failed to get url list for {}", (Object)resource);
        }
    }

    private static URL getResource(String filename, ClassLoader classLoader) {
        return Loader.getResource(filename, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProps() {
        FileInputStream inputStream;
        String url = System.getProperty("TSFILE_CONF", null);
        if (url == null) {
            url = System.getProperty("TSFILE_HOME", null);
            if (url != null) {
                url = url + File.separator + "conf" + File.separator + "iotdb-engine.properties";
            } else {
                ClassLoader classLoader = Loader.getClassLoaderOfObject(this);
                URL u = TSFileDescriptor.getResource("iotdb-engine.properties", classLoader);
                if (u == null) {
                    logger.warn("Failed to find config file {} at classpath, use default configuration", (Object)"iotdb-engine.properties");
                    return;
                }
                this.multiplicityWarning("iotdb-engine.properties", classLoader);
                url = u.getFile();
            }
        } else {
            url = url + File.separatorChar + "iotdb-engine.properties";
        }
        try {
            inputStream = new FileInputStream(new File(url));
        }
        catch (FileNotFoundException e) {
            logger.warn("Fail to find config file {}", (Object)url);
            return;
        }
        logger.info("Start to read config file {}", (Object)url);
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            this.conf.setGroupSizeInByte(Integer.parseInt(properties.getProperty("group_size_in_byte", Integer.toString(this.conf.getGroupSizeInByte()))));
            this.conf.setPageSizeInByte(Integer.parseInt(properties.getProperty("page_size_in_byte", Integer.toString(this.conf.getPageSizeInByte()))));
            if (this.conf.getPageSizeInByte() > this.conf.getGroupSizeInByte()) {
                logger.warn("page_size is greater than group size, will set it as the same with group size");
                this.conf.setPageSizeInByte(this.conf.getGroupSizeInByte());
            }
            this.conf.setMaxNumberOfPointsInPage(Integer.parseInt(properties.getProperty("max_number_of_points_in_page", Integer.toString(this.conf.getMaxNumberOfPointsInPage()))));
            this.conf.setMaxDegreeOfIndexNode(Integer.parseInt(properties.getProperty("max_degree_of_index_node", Integer.toString(this.conf.getMaxDegreeOfIndexNode()))));
            this.conf.setTimeSeriesDataType(properties.getProperty("time_series_data_type", this.conf.getTimeSeriesDataType()));
            this.conf.setMaxStringLength(Integer.parseInt(properties.getProperty("max_string_length", Integer.toString(this.conf.getMaxStringLength()))));
            this.conf.setFloatPrecision(Integer.parseInt(properties.getProperty("float_precision", Integer.toString(this.conf.getFloatPrecision()))));
            this.conf.setTimeEncoder(properties.getProperty("time_encoder", this.conf.getTimeEncoder()));
            this.conf.setValueEncoder(properties.getProperty("value_encoder", this.conf.getValueEncoder()));
            this.conf.setCompressor(properties.getProperty("compressor", this.conf.getCompressor().toString()));
            this.conf.setBatchSize(Integer.parseInt(properties.getProperty("batch_size", Integer.toString(this.conf.getBatchSize()))));
        }
        catch (IOException e) {
            logger.warn("Cannot load config file, use default configuration", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Loading settings {} failed", (Object)url, (Object)e);
        }
        finally {
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException e) {
                logger.error("Failed to close stream for loading config", (Throwable)e);
            }
        }
    }

    private static class TsfileDescriptorHolder {
        private static final TSFileDescriptor INSTANCE = new TSFileDescriptor();

        private TsfileDescriptorHolder() {
            throw new IllegalAccessError("Utility class");
        }
    }
}

