/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.v1.read;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.apache.iotdb.tsfile.utils.BloomFilter;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.v1.file.metadata.ChunkGroupMetaDataV1;
import org.apache.iotdb.tsfile.v1.file.metadata.ChunkMetadataV1;
import org.apache.iotdb.tsfile.v1.file.metadata.TimeseriesMetadataForV1;
import org.apache.iotdb.tsfile.v1.file.metadata.TsDeviceMetadataIndexV1;
import org.apache.iotdb.tsfile.v1.file.metadata.TsDeviceMetadataV1;
import org.apache.iotdb.tsfile.v1.file.metadata.TsFileMetadataV1;
import org.apache.iotdb.tsfile.v1.file.utils.HeaderUtils;

public class TsFileSequenceReaderForV1
extends TsFileSequenceReader {
    private long fileMetadataPos;
    private int fileMetadataSize;
    private TsFileMetadataV1 oldTsFileMetaData;
    private Map<String, Map<String, TimeseriesMetadata>> cachedDeviceMetadataFromOldFile = new ConcurrentHashMap<String, Map<String, TimeseriesMetadata>>();
    private static final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private boolean cacheDeviceMetadata;

    public TsFileSequenceReaderForV1(String file) throws IOException {
        super(file, true);
    }

    public TsFileSequenceReaderForV1(String file, boolean loadMetadataSize) throws IOException {
        super(file, loadMetadataSize);
    }

    public TsFileSequenceReaderForV1(TsFileInput input) throws IOException {
        this(input, true);
    }

    public TsFileSequenceReaderForV1(TsFileInput input, boolean loadMetadataSize) throws IOException {
        super(input, loadMetadataSize);
    }

    public TsFileSequenceReaderForV1(TsFileInput input, long fileMetadataPos, int fileMetadataSize) {
        super(input, fileMetadataPos, fileMetadataSize);
        this.fileMetadataPos = fileMetadataPos;
        this.fileMetadataSize = fileMetadataSize;
    }

    @Override
    public void loadMetadataSize() throws IOException {
        ByteBuffer metadataSize = ByteBuffer.allocate(4);
        if (this.readTailMagic().equals("TsFile")) {
            this.tsFileInput.read(metadataSize, this.tsFileInput.size() - (long)"TsFile".getBytes().length - 4L);
            metadataSize.flip();
            this.fileMetadataSize = ReadWriteIOUtils.readInt(metadataSize);
            this.fileMetadataPos = this.tsFileInput.size() - (long)"TsFile".getBytes().length - 4L - (long)this.fileMetadataSize;
        }
    }

    public TsFileMetadataV1 readOldFileMetadata() throws IOException {
        if (this.oldTsFileMetaData == null) {
            this.oldTsFileMetaData = TsFileMetadataV1.deserializeFrom(this.readDataFromOldFile(this.fileMetadataPos, this.fileMetadataSize));
        }
        return this.oldTsFileMetaData;
    }

    @Override
    public BloomFilter readBloomFilter() throws IOException {
        this.readOldFileMetadata();
        return this.oldTsFileMetaData.getBloomFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, TimeseriesMetadata> readDeviceMetadata(String device) throws IOException {
        if (!this.cacheDeviceMetadata) {
            return this.constructDeviceMetadataFromOldFile(device);
        }
        cacheLock.readLock().lock();
        try {
            if (this.cachedDeviceMetadataFromOldFile.containsKey(device)) {
                Map<String, TimeseriesMetadata> map = this.cachedDeviceMetadataFromOldFile.get(device);
                return map;
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        cacheLock.writeLock().lock();
        try {
            if (this.cachedDeviceMetadataFromOldFile.containsKey(device)) {
                Map<String, TimeseriesMetadata> map = this.cachedDeviceMetadataFromOldFile.get(device);
                return map;
            }
            this.readOldFileMetadata();
            if (!this.oldTsFileMetaData.containsDevice(device)) {
                HashMap<String, TimeseriesMetadata> hashMap = new HashMap<String, TimeseriesMetadata>();
                return hashMap;
            }
            Map<String, TimeseriesMetadata> deviceMetadata = this.constructDeviceMetadataFromOldFile(device);
            this.cachedDeviceMetadataFromOldFile.put(device, deviceMetadata);
            Map<String, TimeseriesMetadata> map = deviceMetadata;
            return map;
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    private Map<String, TimeseriesMetadata> constructDeviceMetadataFromOldFile(String device) throws IOException {
        HashMap<String, TimeseriesMetadata> newDeviceMetadata = new HashMap<String, TimeseriesMetadata>();
        this.readOldFileMetadata();
        TsDeviceMetadataIndexV1 index = this.oldTsFileMetaData.getDeviceMetadataIndex(device);
        TsDeviceMetadataV1 tsDeviceMetadata = this.readOldTsDeviceMetaData(index);
        if (tsDeviceMetadata == null) {
            return newDeviceMetadata;
        }
        HashMap<String, List> measurementChunkMetaMap = new HashMap<String, List>();
        for (ChunkGroupMetaDataV1 chunkGroupMetaData : tsDeviceMetadata.getChunkGroupMetaDataList()) {
            List<ChunkMetadataV1> chunkMetaDataListInOneChunkGroup = chunkGroupMetaData.getChunkMetaDataList();
            for (ChunkMetadataV1 oldChunkMetadata : chunkMetaDataListInOneChunkGroup) {
                oldChunkMetadata.setVersion(chunkGroupMetaData.getVersion());
                measurementChunkMetaMap.computeIfAbsent(oldChunkMetadata.getMeasurementUid(), key -> new ArrayList()).add(oldChunkMetadata.upgradeToChunkMetadata());
            }
        }
        measurementChunkMetaMap.forEach((measurementId, chunkMetadataList) -> {
            if (!chunkMetadataList.isEmpty()) {
                TimeseriesMetadataForV1 timeseiresMetadata = new TimeseriesMetadataForV1();
                timeseiresMetadata.setMeasurementId((String)measurementId);
                timeseiresMetadata.setTSDataType(((ChunkMetadata)chunkMetadataList.get(0)).getDataType());
                Statistics statistics = Statistics.getStatsByType(((ChunkMetadata)chunkMetadataList.get(0)).getDataType());
                for (ChunkMetadata chunkMetadata : chunkMetadataList) {
                    statistics.mergeStatistics(chunkMetadata.getStatistics());
                }
                timeseiresMetadata.setStatistics(statistics);
                timeseiresMetadata.setChunkMetadataList((List<ChunkMetadata>)chunkMetadataList);
                newDeviceMetadata.put((String)measurementId, timeseiresMetadata);
            }
        });
        return newDeviceMetadata;
    }

    private TsDeviceMetadataV1 readOldTsDeviceMetaData(TsDeviceMetadataIndexV1 index) throws IOException {
        if (index == null) {
            return null;
        }
        return TsDeviceMetadataV1.deserializeFrom(this.readDataFromOldFile(index.getOffset(), index.getLen()));
    }

    @Override
    public List<TimeseriesMetadata> readTimeseriesMetadata(String device, Set<String> measurements) throws IOException {
        return this.getTimeseriesMetadataFromOldFile(device, measurements);
    }

    private TimeseriesMetadata getTimeseriesMetadataFromOldFile(Path path) throws IOException {
        Map<String, TimeseriesMetadata> deviceMetadata = this.constructDeviceMetadataFromOldFile(path.getDevice());
        return deviceMetadata.get(path.getMeasurement());
    }

    private List<TimeseriesMetadata> getTimeseriesMetadataFromOldFile(String device, Set<String> measurements) throws IOException {
        Map<String, TimeseriesMetadata> deviceMetadata = this.constructDeviceMetadataFromOldFile(device);
        ArrayList<TimeseriesMetadata> resultTimeseriesMetadataList = new ArrayList<TimeseriesMetadata>();
        for (Map.Entry<String, TimeseriesMetadata> entry : deviceMetadata.entrySet()) {
            if (!measurements.contains(entry.getKey())) continue;
            resultTimeseriesMetadataList.add(entry.getValue());
        }
        return resultTimeseriesMetadataList;
    }

    private ChunkHeader readChunkHeaderFromOldFile(long position, int chunkHeaderSize, boolean markerRead) throws IOException {
        return HeaderUtils.deserializeChunkHeaderV1(this.tsFileInput, position, chunkHeaderSize, markerRead);
    }

    private ByteBuffer readChunkFromOldFile(long position, int dataSize) throws IOException {
        return this.readDataFromOldFile(position, dataSize);
    }

    @Override
    public Chunk readMemChunk(ChunkMetadata metaData) throws IOException {
        int chunkHeadSize = HeaderUtils.getSerializedSizeV1(metaData.getMeasurementUid());
        ChunkHeader header = this.readChunkHeaderFromOldFile(metaData.getOffsetOfChunkHeader(), chunkHeadSize, false);
        ByteBuffer buffer = this.readChunkFromOldFile(metaData.getOffsetOfChunkHeader() + (long)chunkHeadSize, header.getDataSize());
        return new Chunk(header, buffer, metaData.getDeleteIntervalList());
    }

    @Override
    public PageHeader readPageHeader(TSDataType type) throws IOException {
        return HeaderUtils.deserializePageHeaderV1(this.tsFileInput.wrapAsInputStream(), type);
    }

    private ByteBuffer readDataFromOldFile(long position, int size) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        if (position < 0L ? ReadWriteIOUtils.readAsPossible(this.tsFileInput, buffer) != size : ReadWriteIOUtils.readAsPossible(this.tsFileInput, buffer, position, size) != size) {
            throw new IOException("reach the end of the data");
        }
        buffer.flip();
        return buffer;
    }

    @Override
    public List<ChunkMetadata> getChunkMetadataList(Path path) throws IOException {
        return this.getChunkMetadataListFromOldFile(path);
    }

    private List<ChunkMetadata> getChunkMetadataListFromOldFile(Path path) throws IOException {
        this.readOldFileMetadata();
        if (!this.oldTsFileMetaData.containsDevice(path.getDevice())) {
            return new ArrayList<ChunkMetadata>();
        }
        TsDeviceMetadataIndexV1 index = this.oldTsFileMetaData.getDeviceMetadataIndex(path.getDevice());
        TsDeviceMetadataV1 tsDeviceMetadata = this.readOldTsDeviceMetaData(index);
        if (tsDeviceMetadata == null) {
            return new ArrayList<ChunkMetadata>();
        }
        ArrayList<ChunkMetadataV1> oldChunkMetaDataList = new ArrayList<ChunkMetadataV1>();
        for (ChunkGroupMetaDataV1 chunkGroupMetaData : tsDeviceMetadata.getChunkGroupMetaDataList()) {
            List<ChunkMetadataV1> chunkMetaDataListInOneChunkGroup = chunkGroupMetaData.getChunkMetaDataList();
            for (ChunkMetadataV1 chunkMetaData : chunkMetaDataListInOneChunkGroup) {
                if (!path.getMeasurement().equals(chunkMetaData.getMeasurementUid())) continue;
                chunkMetaData.setVersion(chunkGroupMetaData.getVersion());
                oldChunkMetaDataList.add(chunkMetaData);
            }
        }
        oldChunkMetaDataList.sort(Comparator.comparingLong(ChunkMetadataV1::getStartTime));
        ArrayList<ChunkMetadata> chunkMetadataList = new ArrayList<ChunkMetadata>();
        for (ChunkMetadataV1 oldChunkMetaData : oldChunkMetaDataList) {
            chunkMetadataList.add(oldChunkMetaData.upgradeToChunkMetadata());
        }
        return chunkMetadataList;
    }
}

