/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common;

import java.util.LinkedList;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.DescReadBatchData;
import org.apache.iotdb.tsfile.utils.Binary;

public class DescReadWriteBatchData
extends DescReadBatchData {
    public DescReadWriteBatchData(TSDataType dataType) {
        this.dataType = dataType;
        this.readCurListIndex = 0;
        this.readCurArrayIndex = 0;
        this.writeCurListIndex = 0;
        this.writeCurArrayIndex = this.capacity - 1;
        this.timeRet = new LinkedList();
        this.timeRet.add(new long[this.capacity]);
        this.count = 0;
        switch (dataType) {
            case BOOLEAN: {
                this.booleanRet = new LinkedList();
                this.booleanRet.add(new boolean[this.capacity]);
                break;
            }
            case INT32: {
                this.intRet = new LinkedList();
                this.intRet.add(new int[this.capacity]);
                break;
            }
            case INT64: {
                this.longRet = new LinkedList();
                this.longRet.add(new long[this.capacity]);
                break;
            }
            case FLOAT: {
                this.floatRet = new LinkedList();
                this.floatRet.add(new float[this.capacity]);
                break;
            }
            case DOUBLE: {
                this.doubleRet = new LinkedList();
                this.doubleRet.add(new double[this.capacity]);
                break;
            }
            case TEXT: {
                this.binaryRet = new LinkedList();
                this.binaryRet.add(new Binary[this.capacity]);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.valueOf((Object)dataType));
            }
        }
    }

    @Override
    public void putBoolean(long t, boolean v) {
        if (this.writeCurArrayIndex == -1) {
            if (this.capacity >= 1000) {
                ((LinkedList)this.timeRet).addFirst(new long[this.capacity]);
                ((LinkedList)this.booleanRet).addFirst(new boolean[this.capacity]);
                ++this.writeCurListIndex;
                this.writeCurArrayIndex = this.capacity - 1;
            } else {
                int newCapacity = this.capacity << 1;
                long[] newTimeData = new long[newCapacity];
                boolean[] newValueData = new boolean[newCapacity];
                System.arraycopy(this.timeRet.get(0), 0, newTimeData, newCapacity - this.capacity, this.capacity);
                System.arraycopy(this.booleanRet.get(0), 0, newValueData, newCapacity - this.capacity, this.capacity);
                this.timeRet.set(0, newTimeData);
                this.booleanRet.set(0, newValueData);
                this.writeCurArrayIndex = newCapacity - this.capacity - 1;
                this.capacity = newCapacity;
            }
        }
        ((long[])this.timeRet.get((int)0))[this.writeCurArrayIndex] = t;
        ((boolean[])this.booleanRet.get((int)0))[this.writeCurArrayIndex] = v;
        --this.writeCurArrayIndex;
        ++this.count;
    }

    @Override
    public void putInt(long t, int v) {
        if (this.writeCurArrayIndex == -1) {
            if (this.capacity >= 1000) {
                ((LinkedList)this.timeRet).addFirst(new long[this.capacity]);
                ((LinkedList)this.intRet).addFirst(new int[this.capacity]);
                ++this.writeCurListIndex;
                this.writeCurArrayIndex = this.capacity - 1;
            } else {
                int newCapacity = this.capacity << 1;
                long[] newTimeData = new long[newCapacity];
                int[] newValueData = new int[newCapacity];
                System.arraycopy(this.timeRet.get(0), 0, newTimeData, newCapacity - this.capacity, this.capacity);
                System.arraycopy(this.intRet.get(0), 0, newValueData, newCapacity - this.capacity, this.capacity);
                this.timeRet.set(0, newTimeData);
                this.intRet.set(0, newValueData);
                this.writeCurArrayIndex = newCapacity - this.capacity - 1;
                this.capacity = newCapacity;
            }
        }
        ((long[])this.timeRet.get((int)0))[this.writeCurArrayIndex] = t;
        ((int[])this.intRet.get((int)0))[this.writeCurArrayIndex] = v;
        --this.writeCurArrayIndex;
        ++this.count;
    }

    @Override
    public void putLong(long t, long v) {
        if (this.writeCurArrayIndex == -1) {
            if (this.capacity >= 1000) {
                ((LinkedList)this.timeRet).addFirst(new long[this.capacity]);
                ((LinkedList)this.longRet).addFirst(new long[this.capacity]);
                ++this.writeCurListIndex;
                this.writeCurArrayIndex = this.capacity - 1;
            } else {
                int newCapacity = this.capacity << 1;
                long[] newTimeData = new long[newCapacity];
                long[] newValueData = new long[newCapacity];
                System.arraycopy(this.timeRet.get(0), 0, newTimeData, newCapacity - this.capacity, this.capacity);
                System.arraycopy(this.longRet.get(0), 0, newValueData, newCapacity - this.capacity, this.capacity);
                this.timeRet.set(0, newTimeData);
                this.longRet.set(0, newValueData);
                this.writeCurArrayIndex = newCapacity - this.capacity - 1;
                this.capacity = newCapacity;
            }
        }
        ((long[])this.timeRet.get((int)0))[this.writeCurArrayIndex] = t;
        ((long[])this.longRet.get((int)0))[this.writeCurArrayIndex] = v;
        --this.writeCurArrayIndex;
        ++this.count;
    }

    @Override
    public void putFloat(long t, float v) {
        if (this.writeCurArrayIndex == -1) {
            if (this.capacity >= 1000) {
                ((LinkedList)this.timeRet).addFirst(new long[this.capacity]);
                ((LinkedList)this.floatRet).addFirst(new float[this.capacity]);
                ++this.writeCurListIndex;
                this.writeCurArrayIndex = this.capacity - 1;
            } else {
                int newCapacity = this.capacity << 1;
                long[] newTimeData = new long[newCapacity];
                float[] newValueData = new float[newCapacity];
                System.arraycopy(this.timeRet.get(0), 0, newTimeData, newCapacity - this.capacity, this.capacity);
                System.arraycopy(this.floatRet.get(0), 0, newValueData, newCapacity - this.capacity, this.capacity);
                this.timeRet.set(0, newTimeData);
                this.floatRet.set(0, newValueData);
                this.writeCurArrayIndex = newCapacity - this.capacity - 1;
                this.capacity = newCapacity;
            }
        }
        ((long[])this.timeRet.get((int)0))[this.writeCurArrayIndex] = t;
        ((float[])this.floatRet.get((int)0))[this.writeCurArrayIndex] = v;
        --this.writeCurArrayIndex;
        ++this.count;
    }

    @Override
    public void putDouble(long t, double v) {
        if (this.writeCurArrayIndex == -1) {
            if (this.capacity >= 1000) {
                ((LinkedList)this.timeRet).addFirst(new long[this.capacity]);
                ((LinkedList)this.doubleRet).addFirst(new double[this.capacity]);
                ++this.writeCurListIndex;
                this.writeCurArrayIndex = this.capacity - 1;
            } else {
                int newCapacity = this.capacity << 1;
                long[] newTimeData = new long[newCapacity];
                double[] newValueData = new double[newCapacity];
                System.arraycopy(this.timeRet.get(0), 0, newTimeData, newCapacity - this.capacity, this.capacity);
                System.arraycopy(this.doubleRet.get(0), 0, newValueData, newCapacity - this.capacity, this.capacity);
                this.timeRet.set(0, newTimeData);
                this.doubleRet.set(0, newValueData);
                this.writeCurArrayIndex = newCapacity - this.capacity - 1;
                this.capacity = newCapacity;
            }
        }
        ((long[])this.timeRet.get((int)0))[this.writeCurArrayIndex] = t;
        ((double[])this.doubleRet.get((int)0))[this.writeCurArrayIndex] = v;
        --this.writeCurArrayIndex;
        ++this.count;
    }

    @Override
    public void putBinary(long t, Binary v) {
        if (this.writeCurArrayIndex == -1) {
            if (this.capacity >= 1000) {
                ((LinkedList)this.timeRet).addFirst(new long[this.capacity]);
                ((LinkedList)this.binaryRet).addFirst(new Binary[this.capacity]);
                ++this.writeCurListIndex;
                this.writeCurArrayIndex = this.capacity - 1;
            } else {
                int newCapacity = this.capacity << 1;
                long[] newTimeData = new long[newCapacity];
                Binary[] newValueData = new Binary[newCapacity];
                System.arraycopy(this.timeRet.get(0), 0, newTimeData, newCapacity - this.capacity, this.capacity);
                System.arraycopy(this.binaryRet.get(0), 0, newValueData, newCapacity - this.capacity, this.capacity);
                this.timeRet.set(0, newTimeData);
                this.binaryRet.set(0, newValueData);
                this.writeCurArrayIndex = newCapacity - this.capacity - 1;
                this.capacity = newCapacity;
            }
        }
        ((long[])this.timeRet.get((int)0))[this.writeCurArrayIndex] = t;
        ((Binary[])this.binaryRet.get((int)0))[this.writeCurArrayIndex] = v;
        --this.writeCurArrayIndex;
        ++this.count;
    }

    @Override
    public boolean hasCurrent() {
        return this.readCurListIndex == 0 && this.readCurArrayIndex > this.writeCurArrayIndex || this.readCurListIndex > 0 && this.readCurArrayIndex >= 0;
    }

    @Override
    public void next() {
        --this.readCurArrayIndex;
        if (this.readCurListIndex == 0 && this.readCurArrayIndex <= this.writeCurArrayIndex || this.readCurArrayIndex == -1) {
            --this.readCurListIndex;
            this.readCurArrayIndex = this.capacity - 1;
        }
    }

    @Override
    public void resetBatchData() {
        this.readCurArrayIndex = this.capacity - 1;
        this.readCurListIndex = this.writeCurListIndex;
    }

    @Override
    public long getTimeByIndex(int idx) {
        return ((long[])this.timeRet.get((idx + this.writeCurArrayIndex + 1) / this.capacity))[(idx + this.writeCurArrayIndex + 1) % this.capacity];
    }

    @Override
    public long getLongByIndex(int idx) {
        return ((long[])this.longRet.get((idx + this.writeCurArrayIndex + 1) / this.capacity))[(idx + this.writeCurArrayIndex + 1) % this.capacity];
    }

    @Override
    public double getDoubleByIndex(int idx) {
        return ((double[])this.doubleRet.get((idx + this.writeCurArrayIndex + 1) / this.capacity))[(idx + this.writeCurArrayIndex + 1) % this.capacity];
    }

    @Override
    public int getIntByIndex(int idx) {
        return ((int[])this.intRet.get((idx + this.writeCurArrayIndex + 1) / this.capacity))[(idx + this.writeCurArrayIndex + 1) % this.capacity];
    }

    @Override
    public float getFloatByIndex(int idx) {
        return ((float[])this.floatRet.get((idx + this.writeCurArrayIndex + 1) / this.capacity))[(idx + this.writeCurArrayIndex + 1) % this.capacity];
    }

    @Override
    public Binary getBinaryByIndex(int idx) {
        return ((Binary[])this.binaryRet.get((idx + this.writeCurArrayIndex + 1) / this.capacity))[(idx + this.writeCurArrayIndex + 1) % this.capacity];
    }

    @Override
    public boolean getBooleanByIndex(int idx) {
        return ((boolean[])this.booleanRet.get((idx + this.writeCurArrayIndex + 1) / this.capacity))[(idx + this.writeCurArrayIndex + 1) % this.capacity];
    }

    @Override
    public BatchData flip() {
        this.readCurArrayIndex = this.capacity - 1;
        this.readCurListIndex = this.writeCurListIndex;
        return this;
    }
}

