/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.exception.filter.StatisticsClassException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class BooleanStatistics
extends Statistics<Boolean> {
    private boolean firstValue;
    private boolean lastValue;
    static final int BOOLEAN_STATISTICS_FIXED_RAM_SIZE = 48;

    @Override
    public TSDataType getType() {
        return TSDataType.BOOLEAN;
    }

    @Override
    public int getStatsSize() {
        return 2;
    }

    public void initializeStats(boolean firstValue, boolean lastValue) {
        this.firstValue = firstValue;
        this.lastValue = lastValue;
    }

    private void updateStats(boolean firstValue, boolean lastValue) {
        this.lastValue = lastValue;
    }

    private void updateStats(boolean firstValue, boolean lastValue, long startTime, long endTime) {
        if (startTime <= this.getStartTime()) {
            this.firstValue = firstValue;
        }
        if (endTime >= this.getEndTime()) {
            this.lastValue = lastValue;
        }
    }

    @Override
    void updateStats(boolean value) {
        if (this.isEmpty) {
            this.initializeStats(value, value);
            this.isEmpty = false;
        } else {
            this.updateStats(value, value);
        }
    }

    @Override
    void updateStats(boolean[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.updateStats(values[i]);
        }
    }

    @Override
    public long calculateRamSize() {
        return 48L;
    }

    @Override
    public void setMinMaxFromBytes(byte[] minBytes, byte[] maxBytes) {
    }

    @Override
    public Boolean getMinValue() {
        throw new StatisticsClassException("Boolean statistics does not support: min");
    }

    @Override
    public Boolean getMaxValue() {
        throw new StatisticsClassException("Boolean statistics does not support: max");
    }

    @Override
    public Boolean getFirstValue() {
        return this.firstValue;
    }

    @Override
    public Boolean getLastValue() {
        return this.lastValue;
    }

    @Override
    public double getSumValue() {
        throw new StatisticsClassException("Boolean statistics does not support: sum");
    }

    @Override
    public ByteBuffer getMinValueBuffer() {
        throw new StatisticsClassException("Boolean statistics do not support: min");
    }

    @Override
    public ByteBuffer getMaxValueBuffer() {
        throw new StatisticsClassException("Boolean statistics do not support: max");
    }

    @Override
    public ByteBuffer getFirstValueBuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.firstValue);
    }

    @Override
    public ByteBuffer getLastValueBuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.lastValue);
    }

    @Override
    public ByteBuffer getSumValueBuffer() {
        throw new StatisticsClassException("Boolean statistics do not support: sum");
    }

    @Override
    protected void mergeStatisticsValue(Statistics stats) {
        BooleanStatistics boolStats = (BooleanStatistics)stats;
        if (this.isEmpty) {
            this.initializeStats(boolStats.getFirstValue(), boolStats.getLastValue());
            this.isEmpty = false;
        } else {
            this.updateStats(boolStats.getFirstValue(), boolStats.getLastValue(), stats.getStartTime(), stats.getEndTime());
        }
    }

    @Override
    public byte[] getMinValueBytes() {
        throw new StatisticsClassException("Boolean statistics does not support: min");
    }

    @Override
    public byte[] getMaxValueBytes() {
        throw new StatisticsClassException("Boolean statistics does not support: max");
    }

    @Override
    public byte[] getFirstValueBytes() {
        return BytesUtils.boolToBytes(this.firstValue);
    }

    @Override
    public byte[] getLastValueBytes() {
        return BytesUtils.boolToBytes(this.lastValue);
    }

    @Override
    public byte[] getSumValueBytes() {
        throw new StatisticsClassException("Boolean statistics does not support: sum");
    }

    @Override
    public int serializeStats(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write((Boolean)this.firstValue, outputStream);
        return byteLen += ReadWriteIOUtils.write((Boolean)this.lastValue, outputStream);
    }

    @Override
    void deserialize(InputStream inputStream) throws IOException {
        this.firstValue = ReadWriteIOUtils.readBool(inputStream);
        this.lastValue = ReadWriteIOUtils.readBool(inputStream);
    }

    @Override
    void deserialize(ByteBuffer byteBuffer) {
        this.firstValue = ReadWriteIOUtils.readBool(byteBuffer);
        this.lastValue = ReadWriteIOUtils.readBool(byteBuffer);
    }

    @Override
    public String toString() {
        return super.toString() + " [firstValue:" + this.firstValue + ",lastValue:" + this.lastValue + "]";
    }
}

