/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.iotdb.db.engine.merge.manage.MergeResource;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeUtils {
    private static final Logger logger = LoggerFactory.getLogger(MergeUtils.class);

    private MergeUtils() {
    }

    public static void writeTVPair(TimeValuePair timeValuePair, IChunkWriter chunkWriter) {
        switch (chunkWriter.getDataType()) {
            case TEXT: {
                chunkWriter.write(timeValuePair.getTimestamp(), timeValuePair.getValue().getBinary());
                break;
            }
            case DOUBLE: {
                chunkWriter.write(timeValuePair.getTimestamp(), timeValuePair.getValue().getDouble());
                break;
            }
            case BOOLEAN: {
                chunkWriter.write(timeValuePair.getTimestamp(), timeValuePair.getValue().getBoolean());
                break;
            }
            case INT64: {
                chunkWriter.write(timeValuePair.getTimestamp(), timeValuePair.getValue().getLong());
                break;
            }
            case INT32: {
                chunkWriter.write(timeValuePair.getTimestamp(), timeValuePair.getValue().getInt());
                break;
            }
            case FLOAT: {
                chunkWriter.write(timeValuePair.getTimestamp(), timeValuePair.getValue().getFloat());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown data type " + chunkWriter.getDataType());
            }
        }
    }

    private static List<Path> collectFileSeries(TsFileSequenceReader sequenceReader) throws IOException {
        return sequenceReader.getAllPaths();
    }

    public static long collectFileSizes(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles) {
        long totalSize = 0L;
        for (TsFileResource tsFileResource : seqFiles) {
            totalSize += tsFileResource.getTsFileSize();
        }
        for (TsFileResource tsFileResource : unseqFiles) {
            totalSize += tsFileResource.getTsFileSize();
        }
        return totalSize;
    }

    public static int writeChunkWithoutUnseq(Chunk chunk, IChunkWriter chunkWriter) throws IOException {
        ChunkReader chunkReader = new ChunkReader(chunk, null);
        int ptWritten = 0;
        while (chunkReader.hasNextSatisfiedPage()) {
            BatchData batchData = chunkReader.nextPageData();
            for (int i = 0; i < batchData.length(); ++i) {
                MergeUtils.writeBatchPoint(batchData, i, chunkWriter);
            }
            ptWritten += batchData.length();
        }
        return ptWritten;
    }

    public static void writeBatchPoint(BatchData batchData, int i, IChunkWriter chunkWriter) {
        switch (chunkWriter.getDataType()) {
            case TEXT: {
                chunkWriter.write(batchData.getTimeByIndex(i), batchData.getBinaryByIndex(i));
                break;
            }
            case DOUBLE: {
                chunkWriter.write(batchData.getTimeByIndex(i), batchData.getDoubleByIndex(i));
                break;
            }
            case BOOLEAN: {
                chunkWriter.write(batchData.getTimeByIndex(i), batchData.getBooleanByIndex(i));
                break;
            }
            case INT64: {
                chunkWriter.write(batchData.getTimeByIndex(i), batchData.getLongByIndex(i));
                break;
            }
            case INT32: {
                chunkWriter.write(batchData.getTimeByIndex(i), batchData.getIntByIndex(i));
                break;
            }
            case FLOAT: {
                chunkWriter.write(batchData.getTimeByIndex(i), batchData.getFloatByIndex(i));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown data type " + chunkWriter.getDataType());
            }
        }
    }

    public static long[] findTotalAndLargestSeriesChunkNum(TsFileResource tsFileResource, TsFileSequenceReader sequenceReader) throws IOException {
        long totalChunkNum = 0L;
        long maxChunkNum = Long.MIN_VALUE;
        List<Path> paths = MergeUtils.collectFileSeries(sequenceReader);
        for (Path path : paths) {
            List chunkMetadataList = sequenceReader.getChunkMetadataList(path, true);
            totalChunkNum += (long)chunkMetadataList.size();
            maxChunkNum = (long)chunkMetadataList.size() > maxChunkNum ? (long)chunkMetadataList.size() : maxChunkNum;
        }
        logger.debug("In file {}, total chunk num {}, series max chunk num {}", new Object[]{tsFileResource, totalChunkNum, maxChunkNum});
        return new long[]{totalChunkNum, maxChunkNum};
    }

    public static long getFileMetaSize(TsFileResource seqFile, TsFileSequenceReader sequenceReader) {
        return seqFile.getTsFileSize() - sequenceReader.getFileMetadataPos();
    }

    public static List<Chunk>[] collectUnseqChunks(List<PartialPath> paths, List<TsFileResource> unseqResources, MergeResource mergeResource) throws IOException {
        List[] ret = new List[paths.size()];
        for (int i = 0; i < paths.size(); ++i) {
            ret[i] = new ArrayList();
        }
        PriorityQueue<MetaListEntry> chunkMetaHeap = new PriorityQueue<MetaListEntry>();
        for (TsFileResource tsFileResource : unseqResources) {
            TsFileSequenceReader tsFileReader = mergeResource.getFileReader(tsFileResource);
            MergeUtils.buildMetaHeap(paths, tsFileReader, mergeResource, tsFileResource, chunkMetaHeap);
            MergeUtils.collectUnseqChunks(chunkMetaHeap, tsFileReader, ret);
        }
        return ret;
    }

    private static void buildMetaHeap(List<PartialPath> paths, TsFileSequenceReader tsFileReader, MergeResource resource, TsFileResource tsFileResource, PriorityQueue<MetaListEntry> chunkMetaHeap) throws IOException {
        for (int i = 0; i < paths.size(); ++i) {
            MetaListEntry entry;
            PartialPath path = paths.get(i);
            List metaDataList = tsFileReader.getChunkMetadataList((Path)path, true);
            if (metaDataList.isEmpty()) continue;
            List<Modification> pathModifications = resource.getModifications(tsFileResource, path);
            if (!pathModifications.isEmpty()) {
                QueryUtils.modifyChunkMetaData(metaDataList, pathModifications);
            }
            if (!(entry = new MetaListEntry(i, metaDataList)).hasNext()) continue;
            entry.next();
            chunkMetaHeap.add(entry);
        }
    }

    private static void collectUnseqChunks(PriorityQueue<MetaListEntry> chunkMetaHeap, TsFileSequenceReader tsFileReader, List<Chunk>[] ret) throws IOException {
        while (!chunkMetaHeap.isEmpty()) {
            MetaListEntry metaListEntry = chunkMetaHeap.poll();
            ChunkMetadata currMeta = metaListEntry.current();
            Chunk chunk = tsFileReader.readMemChunk(currMeta);
            ret[metaListEntry.pathId].add(chunk);
            if (!metaListEntry.hasNext()) continue;
            metaListEntry.next();
            chunkMetaHeap.add(metaListEntry);
        }
    }

    public static boolean isChunkOverflowed(TimeValuePair timeValuePair, ChunkMetadata metaData) {
        return timeValuePair != null && timeValuePair.getTimestamp() <= metaData.getEndTime();
    }

    public static boolean isChunkTooSmall(int ptWritten, ChunkMetadata chunkMetaData, boolean isLastChunk, int minChunkPointNum) {
        return ptWritten > 0 || minChunkPointNum >= 0 && chunkMetaData.getNumOfPoints() < (long)minChunkPointNum && !isLastChunk;
    }

    public static List<List<PartialPath>> splitPathsByDevice(List<PartialPath> paths) {
        if (paths.isEmpty()) {
            return Collections.emptyList();
        }
        paths.sort(Comparator.comparing(PartialPath::getDevice));
        String currDevice = null;
        ArrayList<PartialPath> currList = null;
        ArrayList<List<PartialPath>> ret = new ArrayList<List<PartialPath>>();
        for (PartialPath path : paths) {
            if (currDevice == null) {
                currDevice = path.getDevice();
                currList = new ArrayList<PartialPath>();
                currList.add(path);
                continue;
            }
            if (path.getDevice().equals(currDevice)) {
                currList.add(path);
                continue;
            }
            ret.add(currList);
            currDevice = path.getDevice();
            currList = new ArrayList();
            currList.add(path);
        }
        ret.add(currList);
        return ret;
    }

    public static class MetaListEntry
    implements Comparable<MetaListEntry> {
        private int pathId;
        private int listIdx;
        private List<ChunkMetadata> chunkMetadataList;

        public MetaListEntry(int pathId, List<ChunkMetadata> chunkMetadataList) {
            this.pathId = pathId;
            this.listIdx = -1;
            this.chunkMetadataList = chunkMetadataList;
        }

        @Override
        public int compareTo(MetaListEntry o) {
            return Long.compare(this.current().getOffsetOfChunkHeader(), o.current().getOffsetOfChunkHeader());
        }

        public ChunkMetadata current() {
            return this.chunkMetadataList.get(this.listIdx);
        }

        public boolean hasNext() {
            return this.listIdx + 1 < this.chunkMetadataList.size();
        }

        public ChunkMetadata next() {
            return this.chunkMetadataList.get(++this.listIdx);
        }

        public int getPathId() {
            return this.pathId;
        }
    }
}

