/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.MetaUtils;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;

public class FilePathUtils {
    private static final String PATH_SPLIT_STRING = File.separator.equals("\\") ? "\\\\" : "/";

    private FilePathUtils() {
    }

    public static String regularizePath(String filePath) {
        if (filePath.length() > 0 && filePath.charAt(filePath.length() - 1) != File.separatorChar) {
            filePath = filePath + File.separatorChar;
        }
        return filePath;
    }

    public static String[] splitTsFilePath(TsFileResource resource) {
        return resource.getTsFile().getAbsolutePath().split(PATH_SPLIT_STRING);
    }

    public static Map<String, Long> getPathByLevel(List<PartialPath> rawPaths, int level, Map<Integer, String> pathIndex) throws QueryProcessException {
        TreeMap<String, Long> finalPaths = new TreeMap<String, Long>();
        int i = 0;
        for (PartialPath value : rawPaths) {
            String key;
            String[] tmpPath;
            try {
                tmpPath = MetaUtils.splitPathToDetachedPath(value.getFullPath());
            }
            catch (IllegalPathException e) {
                throw new QueryProcessException(e.getMessage());
            }
            if (tmpPath.length <= level) {
                key = value.getFullPath();
            } else {
                StringBuilder path = new StringBuilder();
                for (int k = 0; k <= level; ++k) {
                    if (k == 0) {
                        path.append(tmpPath[k]);
                        continue;
                    }
                    path.append(".").append(tmpPath[k]);
                }
                key = path.toString();
            }
            finalPaths.putIfAbsent(key, 0L);
            if (pathIndex == null) continue;
            pathIndex.put(i++, key);
        }
        return finalPaths;
    }

    public static RowRecord mergeRecordByPath(RowRecord newRecord, Map<String, Long> finalPaths, Map<Integer, String> pathIndex) {
        if (newRecord.getFields().size() < finalPaths.size()) {
            return null;
        }
        for (Map.Entry<String, Long> entry : finalPaths.entrySet()) {
            entry.setValue(0L);
        }
        RowRecord tmpRecord = new RowRecord(newRecord.getTimestamp());
        for (int i = 0; i < newRecord.getFields().size(); ++i) {
            if (newRecord.getFields().get(i) == null) continue;
            finalPaths.put(pathIndex.get(i), finalPaths.get(pathIndex.get(i)) + ((Field)newRecord.getFields().get(i)).getLongV());
        }
        for (Map.Entry<String, Long> entry : finalPaths.entrySet()) {
            tmpRecord.addField(Field.getField((Object)entry.getValue(), (TSDataType)TSDataType.INT64));
        }
        return tmpRecord;
    }
}

