/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class FirstValueAggrResult
extends AggregateResult {
    protected long timestamp = Long.MAX_VALUE;

    public FirstValueAggrResult(TSDataType dataType) {
        super(dataType, AggregationType.FIRST_VALUE);
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.timestamp = Long.MAX_VALUE;
    }

    @Override
    public Object getResult() {
        return this.hasCandidateResult() ? this.getValue() : null;
    }

    @Override
    public void updateResultFromStatistics(Statistics statistics) {
        if (this.hasFinalResult()) {
            return;
        }
        Object firstVal = statistics.getFirstValue();
        this.setValue(firstVal);
        this.timestamp = statistics.getStartTime();
    }

    @Override
    public void updateResultFromPageData(BatchData dataInThisPage) {
        if (this.hasFinalResult()) {
            return;
        }
        if (dataInThisPage.hasCurrent()) {
            this.setValue(dataInThisPage.currentValue());
            this.timestamp = dataInThisPage.currentTime();
        }
    }

    @Override
    public void updateResultFromPageData(BatchData dataInThisPage, long minBound, long maxBound) {
        if (this.hasFinalResult()) {
            return;
        }
        if (dataInThisPage.hasCurrent() && dataInThisPage.currentTime() < maxBound && dataInThisPage.currentTime() >= minBound) {
            this.setValue(dataInThisPage.currentValue());
            this.timestamp = dataInThisPage.currentTime();
            dataInThisPage.next();
        }
    }

    @Override
    public void updateResultUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        if (this.hasFinalResult()) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            Object value = dataReader.getValueInTimestamp(timestamps[i]);
            if (value == null) continue;
            this.setValue(value);
            this.timestamp = timestamps[i];
            break;
        }
    }

    @Override
    public boolean hasFinalResult() {
        return this.hasCandidateResult;
    }

    @Override
    public void merge(AggregateResult another) {
        FirstValueAggrResult anotherFirst = (FirstValueAggrResult)another;
        if (this.getValue() == null || this.timestamp > anotherFirst.timestamp) {
            this.setValue(anotherFirst.getValue());
            this.timestamp = anotherFirst.timestamp;
        }
    }

    @Override
    protected void deserializeSpecificFields(ByteBuffer buffer) {
        this.timestamp = buffer.getLong();
    }

    @Override
    protected void serializeSpecificFields(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((long)this.timestamp, (OutputStream)outputStream);
    }
}

