/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.utils.CommonUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertRowPlan
extends InsertPlan {
    private static final Logger logger = LoggerFactory.getLogger(InsertRowPlan.class);
    private static final short TYPE_RAW_STRING = -1;
    private long time;
    private Object[] values;
    private boolean isNeedInferType = false;
    private List<Object> failedValues;

    public InsertRowPlan() {
        super(Operator.OperatorType.INSERT);
    }

    public InsertRowPlan(InsertRowPlan another) {
        super(Operator.OperatorType.INSERT);
        this.deviceId = another.deviceId;
        this.time = another.time;
        this.measurements = new String[another.measurements.length];
        System.arraycopy(another.measurements, 0, this.measurements, 0, another.measurements.length);
        this.values = new Object[another.values.length];
        System.arraycopy(another.values, 0, this.values, 0, another.values.length);
        this.dataTypes = new TSDataType[another.dataTypes.length];
        System.arraycopy(another.dataTypes, 0, this.dataTypes, 0, another.dataTypes.length);
    }

    public InsertRowPlan(PartialPath deviceId, long insertTime, String[] measurementList, String[] insertValues) {
        super(Operator.OperatorType.INSERT);
        this.time = insertTime;
        this.deviceId = deviceId;
        this.measurements = measurementList;
        this.dataTypes = new TSDataType[this.measurements.length];
        this.values = new Object[this.measurements.length];
        System.arraycopy(insertValues, 0, this.values, 0, this.measurements.length);
        this.isNeedInferType = true;
    }

    public InsertRowPlan(PartialPath deviceId, long insertTime, String[] measurementList, ByteBuffer values) throws QueryProcessException {
        super(Operator.OperatorType.INSERT);
        this.time = insertTime;
        this.deviceId = deviceId;
        this.measurements = measurementList;
        this.dataTypes = new TSDataType[measurementList.length];
        this.values = new Object[measurementList.length];
        this.fillValues(values);
        this.isNeedInferType = false;
    }

    public InsertRowPlan(PartialPath deviceId, long insertTime, String[] measurements, TSDataType[] dataTypes, String[] insertValues) {
        super(Operator.OperatorType.INSERT);
        this.time = insertTime;
        this.deviceId = deviceId;
        this.measurements = measurements;
        this.dataTypes = dataTypes;
        this.values = new Object[measurements.length];
        for (int i = 0; i < measurements.length; ++i) {
            try {
                this.values[i] = CommonUtils.parseValueForTest(dataTypes[i], insertValues[i]);
                continue;
            }
            catch (QueryProcessException e) {
                e.printStackTrace();
            }
        }
    }

    public InsertRowPlan(PartialPath deviceId, long insertTime, String measurement, TSDataType type, String insertValue) {
        super(Operator.OperatorType.INSERT);
        this.time = insertTime;
        this.deviceId = deviceId;
        this.measurements = new String[]{measurement};
        this.dataTypes = new TSDataType[]{type};
        this.values = new Object[1];
        try {
            this.values[0] = CommonUtils.parseValueForTest(this.dataTypes[0], insertValue);
        }
        catch (QueryProcessException e) {
            e.printStackTrace();
        }
    }

    public InsertRowPlan(TSRecord tsRecord) throws IllegalPathException {
        super(Operator.OperatorType.INSERT);
        this.deviceId = new PartialPath(tsRecord.deviceId);
        this.time = tsRecord.time;
        this.measurements = new String[tsRecord.dataPointList.size()];
        this.measurementMNodes = new MeasurementMNode[tsRecord.dataPointList.size()];
        this.dataTypes = new TSDataType[tsRecord.dataPointList.size()];
        this.values = new Object[tsRecord.dataPointList.size()];
        for (int i = 0; i < tsRecord.dataPointList.size(); ++i) {
            this.measurements[i] = ((DataPoint)tsRecord.dataPointList.get(i)).getMeasurementId();
            this.measurementMNodes[i] = new MeasurementMNode(null, this.measurements[i], new MeasurementSchema(this.measurements[i], ((DataPoint)tsRecord.dataPointList.get(i)).getType(), TSEncoding.PLAIN), null);
            this.dataTypes[i] = ((DataPoint)tsRecord.dataPointList.get(i)).getType();
            this.values[i] = ((DataPoint)tsRecord.dataPointList.get(i)).getValue();
        }
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public boolean isNeedInferType() {
        return this.isNeedInferType;
    }

    public void setNeedInferType(boolean inferType) {
        this.isNeedInferType = inferType;
    }

    public void transferType() throws QueryProcessException {
        if (this.isNeedInferType) {
            for (int i = 0; i < this.measurementMNodes.length; ++i) {
                if (this.measurementMNodes[i] == null) {
                    if (IoTDBDescriptor.getInstance().getConfig().isEnablePartialInsert()) {
                        this.markFailedMeasurementInsertion(i, new QueryProcessException(new PathNotExistException(this.deviceId.getFullPath() + '.' + this.measurements[i])));
                        continue;
                    }
                    throw new QueryProcessException(new PathNotExistException(this.deviceId.getFullPath() + '.' + this.measurements[i]));
                }
                this.dataTypes[i] = this.measurementMNodes[i].getSchema().getType();
                try {
                    this.values[i] = CommonUtils.parseValue(this.dataTypes[i], this.values[i].toString());
                    continue;
                }
                catch (Exception e) {
                    logger.warn("{}.{} data type is not consistent, input {}, registered {}", new Object[]{this.deviceId, this.measurements[i], this.values[i], this.dataTypes[i]});
                    if (IoTDBDescriptor.getInstance().getConfig().isEnablePartialInsert()) {
                        this.markFailedMeasurementInsertion(i, e);
                        this.measurementMNodes[i] = null;
                        continue;
                    }
                    throw e;
                }
            }
        }
    }

    @Override
    public long getMinTime() {
        return this.getTime();
    }

    @Override
    public void markFailedMeasurementInsertion(int index, Exception e) {
        if (this.measurements[index] == null) {
            return;
        }
        super.markFailedMeasurementInsertion(index, e);
        if (this.failedValues == null) {
            this.failedValues = new ArrayList<Object>();
        }
        this.failedValues.add(this.values[index]);
        this.values[index] = null;
    }

    @Override
    public List<PartialPath> getPaths() {
        ArrayList<PartialPath> ret = new ArrayList<PartialPath>();
        for (String m : this.measurements) {
            PartialPath fullPath = this.deviceId.concatNode(m);
            ret.add(fullPath);
        }
        return ret;
    }

    public Object[] getValues() {
        return this.values;
    }

    public void setValues(Object[] values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsertRowPlan that = (InsertRowPlan)o;
        return this.time == that.time && Objects.equals(this.deviceId, that.deviceId) && Arrays.equals(this.measurements, that.measurements) && Arrays.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.time);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        int type = PhysicalPlan.PhysicalPlanType.INSERT.ordinal();
        stream.writeByte((byte)type);
        stream.writeLong(this.time);
        this.putString(stream, this.deviceId.getFullPath());
        this.serializeMeasurementsAndValues(stream);
    }

    void serializeMeasurementsAndValues(DataOutputStream stream) throws IOException {
        stream.writeInt(this.measurements.length - (this.failedMeasurements == null ? 0 : this.failedMeasurements.size()));
        for (String m : this.measurements) {
            if (m == null) continue;
            this.putString(stream, m);
        }
        try {
            this.putValues(stream);
        }
        catch (QueryProcessException e) {
            throw new IOException(e);
        }
        stream.write((byte)(this.isNeedInferType ? 1 : 0));
        stream.writeLong(this.index);
    }

    private void putValues(DataOutputStream outputStream) throws QueryProcessException, IOException {
        block8: for (int i = 0; i < this.values.length; ++i) {
            if (this.dataTypes == null || this.dataTypes[i] == null) {
                ReadWriteIOUtils.write((short)-1, (OutputStream)outputStream);
                ReadWriteIOUtils.write((String)((String)this.values[i]), (OutputStream)outputStream);
                continue;
            }
            ReadWriteIOUtils.write((TSDataType)this.dataTypes[i], (OutputStream)outputStream);
            switch (this.dataTypes[i]) {
                case BOOLEAN: {
                    ReadWriteIOUtils.write((Boolean)((Boolean)this.values[i]), (OutputStream)outputStream);
                    continue block8;
                }
                case INT32: {
                    ReadWriteIOUtils.write((int)((Integer)this.values[i]), (OutputStream)outputStream);
                    continue block8;
                }
                case INT64: {
                    ReadWriteIOUtils.write((long)((Long)this.values[i]), (OutputStream)outputStream);
                    continue block8;
                }
                case FLOAT: {
                    ReadWriteIOUtils.write((float)((Float)this.values[i]).floatValue(), (OutputStream)outputStream);
                    continue block8;
                }
                case DOUBLE: {
                    ReadWriteIOUtils.write((double)((Double)this.values[i]), (OutputStream)outputStream);
                    continue block8;
                }
                case TEXT: {
                    ReadWriteIOUtils.write((Binary)((Binary)this.values[i]), (OutputStream)outputStream);
                    continue block8;
                }
                default: {
                    throw new QueryProcessException("Unsupported data type:" + this.dataTypes[i]);
                }
            }
        }
    }

    private void putValues(ByteBuffer buffer) throws QueryProcessException {
        block8: for (int i = 0; i < this.values.length; ++i) {
            if (this.dataTypes == null || this.dataTypes[i] == null) {
                ReadWriteIOUtils.write((short)-1, (ByteBuffer)buffer);
                ReadWriteIOUtils.write((String)((String)this.values[i]), (ByteBuffer)buffer);
                continue;
            }
            ReadWriteIOUtils.write((TSDataType)this.dataTypes[i], (ByteBuffer)buffer);
            switch (this.dataTypes[i]) {
                case BOOLEAN: {
                    ReadWriteIOUtils.write((Boolean)((Boolean)this.values[i]), (ByteBuffer)buffer);
                    continue block8;
                }
                case INT32: {
                    ReadWriteIOUtils.write((int)((Integer)this.values[i]), (ByteBuffer)buffer);
                    continue block8;
                }
                case INT64: {
                    ReadWriteIOUtils.write((long)((Long)this.values[i]), (ByteBuffer)buffer);
                    continue block8;
                }
                case FLOAT: {
                    ReadWriteIOUtils.write((float)((Float)this.values[i]).floatValue(), (ByteBuffer)buffer);
                    continue block8;
                }
                case DOUBLE: {
                    ReadWriteIOUtils.write((double)((Double)this.values[i]), (ByteBuffer)buffer);
                    continue block8;
                }
                case TEXT: {
                    ReadWriteIOUtils.write((Binary)((Binary)this.values[i]), (ByteBuffer)buffer);
                    continue block8;
                }
                default: {
                    throw new QueryProcessException("Unsupported data type:" + this.dataTypes[i]);
                }
            }
        }
    }

    public void fillValues(ByteBuffer buffer) throws QueryProcessException {
        block8: for (int i = 0; i < this.measurements.length; ++i) {
            short typeNum = ReadWriteIOUtils.readShort((ByteBuffer)buffer);
            if (typeNum == -1) {
                this.values[i] = ReadWriteIOUtils.readString((ByteBuffer)buffer);
                continue;
            }
            this.dataTypes[i] = TSDataType.values()[typeNum];
            switch (this.dataTypes[i]) {
                case BOOLEAN: {
                    this.values[i] = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
                    continue block8;
                }
                case INT32: {
                    this.values[i] = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
                    continue block8;
                }
                case INT64: {
                    this.values[i] = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
                    continue block8;
                }
                case FLOAT: {
                    this.values[i] = Float.valueOf(ReadWriteIOUtils.readFloat((ByteBuffer)buffer));
                    continue block8;
                }
                case DOUBLE: {
                    this.values[i] = ReadWriteIOUtils.readDouble((ByteBuffer)buffer);
                    continue block8;
                }
                case TEXT: {
                    this.values[i] = ReadWriteIOUtils.readBinary((ByteBuffer)buffer);
                    continue block8;
                }
                default: {
                    throw new QueryProcessException("Unsupported data type:" + this.dataTypes[i]);
                }
            }
        }
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.INSERT.ordinal();
        buffer.put((byte)type);
        buffer.putLong(this.time);
        this.putString(buffer, this.deviceId.getFullPath());
        this.serializeMeasurementsAndValues(buffer);
    }

    void serializeMeasurementsAndValues(ByteBuffer buffer) {
        buffer.putInt(this.measurements.length - (this.failedMeasurements == null ? 0 : this.failedMeasurements.size()));
        for (String measurement : this.measurements) {
            if (measurement == null) continue;
            this.putString(buffer, measurement);
        }
        try {
            this.putValues(buffer);
        }
        catch (QueryProcessException e) {
            logger.error("Failed to serialize values for {}", (Object)this, (Object)e);
        }
        buffer.put((byte)(this.isNeedInferType ? 1 : 0));
        buffer.putLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        this.time = buffer.getLong();
        this.deviceId = new PartialPath(this.readString(buffer));
        this.deserializeMeasurementsAndValues(buffer);
    }

    void deserializeMeasurementsAndValues(ByteBuffer buffer) {
        int measurementSize = buffer.getInt();
        this.measurements = new String[measurementSize];
        for (int i = 0; i < measurementSize; ++i) {
            this.measurements[i] = this.readString(buffer);
        }
        this.dataTypes = new TSDataType[measurementSize];
        this.values = new Object[measurementSize];
        try {
            this.fillValues(buffer);
        }
        catch (QueryProcessException e) {
            e.printStackTrace();
        }
        this.isNeedInferType = buffer.get() == 1;
        this.index = buffer.getLong();
    }

    public String toString() {
        return "deviceId: " + this.deviceId + ", time: " + this.time;
    }

    public TimeValuePair composeTimeValuePair(int measurementIndex) {
        if (measurementIndex >= this.values.length) {
            return null;
        }
        Object value = this.values[measurementIndex];
        return new TimeValuePair(this.time, TsPrimitiveType.getByType((TSDataType)this.measurementMNodes[measurementIndex].getSchema().getType(), (Object)value));
    }

    @Override
    public InsertPlan getPlanFromFailed() {
        if (super.getPlanFromFailed() == null) {
            return null;
        }
        this.values = this.failedValues.toArray(new Object[0]);
        this.failedValues = null;
        return this;
    }

    boolean hasFailedValues() {
        return this.failedValues != null && !this.failedValues.isEmpty();
    }
}

