/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.rescon.CachedStringPool;

public class MNode
implements Serializable {
    private static final long serialVersionUID = -770028375899514063L;
    private static Map<String, String> cachedPathPool = CachedStringPool.getInstance().getCachedPool();
    protected String name;
    protected MNode parent;
    protected String fullPath;
    protected volatile transient ConcurrentMap<String, MNode> children = null;
    private volatile transient ConcurrentMap<String, MNode> aliasChildren = null;

    public MNode(MNode parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public boolean hasChild(String name) {
        return this.children != null && this.children.containsKey(name) || this.aliasChildren != null && this.aliasChildren.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(String name, MNode child) {
        if (this.children == null) {
            MNode mNode = this;
            synchronized (mNode) {
                if (this.children == null) {
                    this.children = new ConcurrentHashMap<String, MNode>();
                }
            }
        }
        this.children.putIfAbsent(name, child);
    }

    public void deleteChild(String name) {
        if (this.children != null) {
            this.children.remove(name);
        }
    }

    public void deleteAliasChild(String alias) {
        if (this.aliasChildren != null) {
            this.aliasChildren.remove(alias);
        }
    }

    public MNode getChild(String name) {
        MNode child = null;
        if (this.children != null) {
            child = (MNode)this.children.get(name);
        }
        if (child != null) {
            return child;
        }
        return this.aliasChildren == null ? null : (MNode)this.aliasChildren.get(name);
    }

    public int getMeasurementMNodeCount() {
        if (this.children == null) {
            return 1;
        }
        int measurementMNodeCount = 0;
        if (this instanceof MeasurementMNode) {
            ++measurementMNodeCount;
        }
        for (MNode child : this.children.values()) {
            measurementMNodeCount += child.getMeasurementMNodeCount();
        }
        return measurementMNodeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAlias(String alias, MNode child) {
        if (this.aliasChildren == null) {
            MNode mNode = this;
            synchronized (mNode) {
                if (this.aliasChildren == null) {
                    this.aliasChildren = new ConcurrentHashMap<String, MNode>();
                }
            }
        }
        return this.aliasChildren.computeIfAbsent(alias, aliasName -> child) == child;
    }

    public String getFullPath() {
        if (this.fullPath == null) {
            this.fullPath = this.concatFullPath();
            String cachedFullPath = cachedPathPool.get(this.fullPath);
            if (cachedFullPath == null) {
                cachedPathPool.put(this.fullPath, this.fullPath);
            } else {
                this.fullPath = cachedFullPath;
            }
        }
        return this.fullPath;
    }

    public PartialPath getPartialPath() {
        ArrayList<String> detachedPath = new ArrayList<String>();
        MNode temp = this;
        detachedPath.add(temp.getName());
        while (temp.getParent() != null) {
            temp = temp.getParent();
            detachedPath.add(0, temp.getName());
        }
        return new PartialPath(detachedPath.toArray(new String[0]));
    }

    String concatFullPath() {
        StringBuilder builder = new StringBuilder(this.name);
        MNode curr = this;
        while (curr.getParent() != null) {
            curr = curr.getParent();
            builder.insert(0, '.').insert(0, curr.name);
        }
        return builder.toString();
    }

    public String toString() {
        return this.getName();
    }

    public MNode getParent() {
        return this.parent;
    }

    public void setParent(MNode parent) {
        this.parent = parent;
    }

    public Map<String, MNode> getChildren() {
        if (this.children == null) {
            return Collections.emptyMap();
        }
        return this.children;
    }

    public void setChildren(ConcurrentMap<String, MNode> children) {
        this.children = children;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void serializeTo(BufferedWriter bw) throws IOException {
        this.serializeChildren(bw);
        String s = String.valueOf(0) + "," + this.name + "," + (this.children == null ? "0" : Integer.valueOf(this.children.size()));
        bw.write(s);
        bw.newLine();
    }

    void serializeChildren(BufferedWriter bw) throws IOException {
        if (this.children == null) {
            return;
        }
        for (Map.Entry entry : this.children.entrySet()) {
            ((MNode)entry.getValue()).serializeTo(bw);
        }
    }
}

