/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.memtable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunk;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.rescon.TVListAllocator;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public abstract class AbstractMemTable
implements IMemTable {
    private final Map<String, Map<String, IWritableMemChunk>> memTableMap;
    private long version = Long.MAX_VALUE;
    private List<Modification> modifications = new ArrayList<Modification>();
    private int avgSeriesPointNumThreshold = IoTDBDescriptor.getInstance().getConfig().getAvgSeriesPointNumberThreshold();
    private long memSize = 0L;
    private long tvListRamCost = 0L;
    protected boolean disableMemControl = true;
    private volatile boolean shouldFlush = false;
    private int seriesNumber = 0;
    private long totalPointsNum = 0L;
    private long totalPointsNumThreshold = 0L;
    private long maxPlanIndex = Long.MIN_VALUE;
    private long minPlanIndex = Long.MAX_VALUE;

    public AbstractMemTable() {
        this.memTableMap = new HashMap<String, Map<String, IWritableMemChunk>>();
    }

    public AbstractMemTable(Map<String, Map<String, IWritableMemChunk>> memTableMap) {
        this.memTableMap = memTableMap;
    }

    @Override
    public Map<String, Map<String, IWritableMemChunk>> getMemTableMap() {
        return this.memTableMap;
    }

    private boolean checkPath(String deviceId, String measurement) {
        return this.memTableMap.containsKey(deviceId) && this.memTableMap.get(deviceId).containsKey(measurement);
    }

    private IWritableMemChunk createIfNotExistAndGet(String deviceId, String measurement, MeasurementSchema schema) {
        Map<String, IWritableMemChunk> memSeries;
        if (!this.memTableMap.containsKey(deviceId)) {
            this.memTableMap.put(deviceId, new HashMap());
        }
        if (!(memSeries = this.memTableMap.get(deviceId)).containsKey(measurement)) {
            memSeries.put(measurement, this.genMemSeries(schema));
            ++this.seriesNumber;
            this.totalPointsNumThreshold += (long)this.avgSeriesPointNumThreshold;
        }
        return memSeries.get(measurement);
    }

    protected abstract IWritableMemChunk genMemSeries(MeasurementSchema var1);

    @Override
    public void insert(InsertRowPlan insertRowPlan) {
        this.updatePlanIndexes(insertRowPlan.getIndex());
        for (int i = 0; i < insertRowPlan.getValues().length; ++i) {
            if (insertRowPlan.getValues()[i] == null) continue;
            Object value = insertRowPlan.getValues()[i];
            this.memSize += MemUtils.getRecordSize(insertRowPlan.getMeasurementMNodes()[i].getSchema().getType(), value, this.disableMemControl);
            this.write(insertRowPlan.getDeviceId().getFullPath(), insertRowPlan.getMeasurements()[i], insertRowPlan.getMeasurementMNodes()[i].getSchema(), insertRowPlan.getTime(), value);
        }
        this.totalPointsNum += (long)(insertRowPlan.getMeasurements().length - insertRowPlan.getFailedMeasurementNumber());
    }

    @Override
    public void insertTablet(InsertTabletPlan insertTabletPlan, int start, int end) throws WriteProcessException {
        this.updatePlanIndexes(insertTabletPlan.getIndex());
        try {
            this.write(insertTabletPlan, start, end);
            this.memSize += MemUtils.getRecordSize(insertTabletPlan, start, end, this.disableMemControl);
            this.totalPointsNum += (long)((insertTabletPlan.getMeasurements().length - insertTabletPlan.getFailedMeasurementNumber()) * (end - start));
        }
        catch (RuntimeException e) {
            throw new WriteProcessException(e);
        }
    }

    @Override
    public void write(String deviceId, String measurement, MeasurementSchema schema, long insertTime, Object objectValue) {
        IWritableMemChunk memSeries = this.createIfNotExistAndGet(deviceId, measurement, schema);
        memSeries.write(insertTime, objectValue);
    }

    @Override
    public void write(InsertTabletPlan insertTabletPlan, int start, int end) {
        this.updatePlanIndexes(insertTabletPlan.getIndex());
        for (int i = 0; i < insertTabletPlan.getMeasurements().length; ++i) {
            if (insertTabletPlan.getColumns()[i] == null) continue;
            IWritableMemChunk memSeries = this.createIfNotExistAndGet(insertTabletPlan.getDeviceId().getFullPath(), insertTabletPlan.getMeasurements()[i], insertTabletPlan.getMeasurementMNodes()[i].getSchema());
            memSeries.write(insertTabletPlan.getTimes(), insertTabletPlan.getColumns()[i], insertTabletPlan.getDataTypes()[i], start, end);
        }
    }

    @Override
    public boolean checkIfChunkDoesNotExist(String deviceId, String measurement) {
        if (!this.memTableMap.containsKey(deviceId)) {
            return true;
        }
        Map<String, IWritableMemChunk> memSeries = this.memTableMap.get(deviceId);
        return !memSeries.containsKey(measurement);
    }

    @Override
    public int getCurrentChunkPointNum(String deviceId, String measurement) {
        Map<String, IWritableMemChunk> memSeries = this.memTableMap.get(deviceId);
        IWritableMemChunk memChunk = memSeries.get(measurement);
        return memChunk.getTVList().size();
    }

    @Override
    public int getSeriesNumber() {
        return this.seriesNumber;
    }

    @Override
    public long getTotalPointsNum() {
        return this.totalPointsNum;
    }

    @Override
    public long size() {
        long sum = 0L;
        for (Map<String, IWritableMemChunk> seriesMap : this.memTableMap.values()) {
            for (IWritableMemChunk writableMemChunk : seriesMap.values()) {
                sum += writableMemChunk.count();
            }
        }
        return sum;
    }

    @Override
    public long memSize() {
        return this.memSize;
    }

    @Override
    public boolean reachTotalPointNumThreshold() {
        if (this.totalPointsNum == 0L) {
            return false;
        }
        return this.totalPointsNum >= this.totalPointsNumThreshold;
    }

    @Override
    public void clear() {
        this.memTableMap.clear();
        this.modifications.clear();
        this.memSize = 0L;
        this.seriesNumber = 0;
        this.totalPointsNum = 0L;
        this.totalPointsNumThreshold = 0L;
        this.tvListRamCost = 0L;
        this.maxPlanIndex = 0L;
    }

    @Override
    public boolean isEmpty() {
        return this.memTableMap.isEmpty();
    }

    @Override
    public ReadOnlyMemChunk query(String deviceId, String measurement, TSDataType dataType, TSEncoding encoding, Map<String, String> props, long timeLowerBound) throws IOException, QueryProcessException, MetadataException {
        if (!this.checkPath(deviceId, measurement)) {
            return null;
        }
        List<TimeRange> deletionList = this.constructDeletionList(deviceId, measurement, timeLowerBound);
        IWritableMemChunk memChunk = this.memTableMap.get(deviceId).get(measurement);
        TVList chunkCopy = memChunk.getTVList().clone();
        chunkCopy.setDeletionList(deletionList);
        return new ReadOnlyMemChunk(measurement, dataType, encoding, chunkCopy, props, this.getVersion());
    }

    private List<TimeRange> constructDeletionList(String deviceId, String measurement, long timeLowerBound) throws MetadataException {
        ArrayList<TimeRange> deletionList = new ArrayList<TimeRange>();
        deletionList.add(new TimeRange(Long.MIN_VALUE, timeLowerBound));
        for (Modification modification : this.modifications) {
            Deletion deletion;
            if (!(modification instanceof Deletion) || !(deletion = (Deletion)modification).getPath().matchFullPath(new PartialPath(deviceId, measurement)) || deletion.getEndTime() <= timeLowerBound) continue;
            long lowerBound = Math.max(deletion.getStartTime(), timeLowerBound);
            deletionList.add(new TimeRange(lowerBound, deletion.getEndTime()));
        }
        return TimeRange.sortAndMerge(deletionList);
    }

    @Override
    public void delete(PartialPath originalPath, PartialPath devicePath, long startTimestamp, long endTimestamp) {
        Map<String, IWritableMemChunk> deviceMap = this.memTableMap.get(devicePath.getFullPath());
        if (deviceMap == null) {
            return;
        }
        Iterator<Map.Entry<String, IWritableMemChunk>> iter = deviceMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, IWritableMemChunk> entry = iter.next();
            IWritableMemChunk chunk = entry.getValue();
            PartialPath fullPath = devicePath.concatNode(entry.getKey());
            if (!originalPath.matchFullPath(fullPath)) continue;
            if (startTimestamp == Long.MIN_VALUE && endTimestamp == Long.MAX_VALUE) {
                iter.remove();
            }
            int deletedPointsNumber = chunk.delete(startTimestamp, endTimestamp);
            this.totalPointsNum -= (long)deletedPointsNumber;
        }
    }

    @Override
    public void delete(Deletion deletion) {
        this.modifications.add(deletion);
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(long version) {
        this.version = version;
    }

    @Override
    public void addTVListRamCost(long cost) {
        this.tvListRamCost += cost;
    }

    @Override
    public long getTVListsRamCost() {
        return this.tvListRamCost;
    }

    @Override
    public void addTextDataSize(long testDataSize) {
        this.memSize += testDataSize;
    }

    @Override
    public void setShouldFlush() {
        this.shouldFlush = true;
    }

    @Override
    public boolean shouldFlush() {
        return this.shouldFlush;
    }

    @Override
    public void release() {
        for (Map.Entry<String, Map<String, IWritableMemChunk>> entry : this.memTableMap.entrySet()) {
            for (Map.Entry<String, IWritableMemChunk> subEntry : entry.getValue().entrySet()) {
                TVListAllocator.getInstance().release(subEntry.getValue().getTVList());
            }
        }
    }

    @Override
    public long getMaxPlanIndex() {
        return this.maxPlanIndex;
    }

    @Override
    public long getMinPlanIndex() {
        return this.minPlanIndex;
    }

    void updatePlanIndexes(long index) {
        this.maxPlanIndex = Math.max(index, this.maxPlanIndex);
        this.minPlanIndex = Math.min(index, this.minPlanIndex);
    }
}

