/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBConstant;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBConfigCheck {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBDescriptor.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final String PROPERTIES_FILE_NAME = "system.properties";
    private static final String SCHEMA_DIR = config.getSchemaDir();
    private static final String WAL_DIR = config.getWalDir();
    private File propertiesFile;
    private File tmpPropertiesFile;
    private Properties properties = new Properties();
    private Map<String, String> systemProperties = new HashMap<String, String>();
    private static final String SYSTEM_PROPERTIES_STRING = "System properties:";
    private static final String TIMESTAMP_PRECISION_STRING = "timestamp_precision";
    private static String timestampPrecision = config.getTimestampPrecision();
    private static final String PARTITION_INTERVAL_STRING = "partition_interval";
    private static long partitionInterval = config.getPartitionInterval();
    private static final String TSFILE_FILE_SYSTEM_STRING = "tsfile_storage_fs";
    private static String tsfileFileSystem = config.getTsFileStorageFs().toString();
    private static final String ENABLE_PARTITION_STRING = "enable_partition";
    private static boolean enablePartition = config.isEnablePartition();
    private static final String TAG_ATTRIBUTE_SIZE_STRING = "tag_attribute_total_size";
    private static String tagAttributeTotalSize = String.valueOf(config.getTagAttributeTotalSize());
    private static final String MAX_DEGREE_OF_INDEX_STRING = "max_degree_of_index_node";
    private static String maxDegreeOfIndexNode = String.valueOf(TSFileDescriptor.getInstance().getConfig().getMaxDegreeOfIndexNode());
    private static final String TIME_ENCODER_KEY = "time_encoder";
    private static String timeEncoderValue = String.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeEncoder());
    private static final String IOTDB_VERSION_STRING = "iotdb_version";

    public static IoTDBConfigCheck getInstance() {
        return IoTDBConfigCheckHolder.INSTANCE;
    }

    private IoTDBConfigCheck() {
        logger.info("Starting IoTDB " + IoTDBConstant.VERSION);
        File dir = SystemFileFactory.INSTANCE.getFile(SCHEMA_DIR);
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                logger.error("can not create schema dir: {}", (Object)SCHEMA_DIR);
                System.exit(-1);
            } else {
                logger.info(" {} dir has been created.", (Object)SCHEMA_DIR);
            }
        }
        if (!(timestampPrecision.equals("ms") || timestampPrecision.equals("us") || timestampPrecision.equals("ns"))) {
            logger.error("Wrong {}, please set as: ms, us or ns ! Current is: {}", (Object)TIMESTAMP_PRECISION_STRING, (Object)timestampPrecision);
            System.exit(-1);
        }
        if (!enablePartition) {
            partitionInterval = Long.MAX_VALUE;
        }
        if (partitionInterval <= 0L) {
            logger.error("Partition interval must larger than 0!");
            System.exit(-1);
        }
        this.systemProperties.put(IOTDB_VERSION_STRING, IoTDBConstant.VERSION);
        this.systemProperties.put(TIMESTAMP_PRECISION_STRING, timestampPrecision);
        this.systemProperties.put(PARTITION_INTERVAL_STRING, String.valueOf(partitionInterval));
        this.systemProperties.put(TSFILE_FILE_SYSTEM_STRING, tsfileFileSystem);
        this.systemProperties.put(ENABLE_PARTITION_STRING, String.valueOf(enablePartition));
        this.systemProperties.put(TAG_ATTRIBUTE_SIZE_STRING, tagAttributeTotalSize);
        this.systemProperties.put(MAX_DEGREE_OF_INDEX_STRING, maxDegreeOfIndexNode);
        this.systemProperties.put(TIME_ENCODER_KEY, timeEncoderValue);
    }

    public void checkConfig() throws IOException {
        this.propertiesFile = SystemFileFactory.INSTANCE.getFile(SCHEMA_DIR + File.separator + PROPERTIES_FILE_NAME);
        this.tmpPropertiesFile = SystemFileFactory.INSTANCE.getFile(SCHEMA_DIR + File.separator + PROPERTIES_FILE_NAME + ".tmp");
        if (!this.propertiesFile.exists() && !this.tmpPropertiesFile.exists()) {
            if (this.propertiesFile.createNewFile()) {
                logger.info(" {} has been created.", (Object)this.propertiesFile.getAbsolutePath());
            } else {
                logger.error("can not create {}", (Object)this.propertiesFile.getAbsolutePath());
                System.exit(-1);
            }
            try (FileOutputStream outputStream = new FileOutputStream(this.propertiesFile);){
                this.systemProperties.forEach((k, v) -> this.properties.setProperty((String)k, (String)v));
                this.properties.store(outputStream, SYSTEM_PROPERTIES_STRING);
            }
            return;
        }
        if (!this.propertiesFile.exists() && this.tmpPropertiesFile.exists()) {
            FileUtils.moveFile((File)this.tmpPropertiesFile, (File)this.propertiesFile);
            logger.info("rename {} to {}", (Object)this.tmpPropertiesFile, (Object)this.propertiesFile);
            return;
        }
        if (this.propertiesFile.exists() && this.tmpPropertiesFile.exists()) {
            FileUtils.forceDelete((File)this.tmpPropertiesFile);
            logger.info("remove {}", (Object)this.tmpPropertiesFile);
        }
        try (FileInputStream inputStream = new FileInputStream(this.propertiesFile);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, TSFileConfig.STRING_CHARSET);){
            this.properties.load(inputStreamReader);
        }
        if (!this.properties.containsKey(IOTDB_VERSION_STRING)) {
            logger.error("DO NOT UPGRADE IoTDB from v0.9 or lower version to v0.11! Please upgrade to v0.10 first");
            System.exit(-1);
        }
        if (this.properties.getProperty(IOTDB_VERSION_STRING).startsWith("0.10")) {
            logger.info("Upgrading IoTDB from v0.10 to v0.11, checking files...");
            this.checkUnClosedTsFileV2();
            this.upgradePropertiesFile();
            logger.info("Upgrade to IoTDB v0.11 successfully!");
        }
        this.checkProperties();
    }

    private void upgradePropertiesFile() throws IOException {
        if (this.tmpPropertiesFile.createNewFile()) {
            logger.info("Create system.properties.tmp {}.", (Object)this.tmpPropertiesFile);
        } else {
            logger.error("Create system.properties.tmp {} failed.", (Object)this.tmpPropertiesFile);
            System.exit(-1);
        }
        try (FileOutputStream tmpFOS = new FileOutputStream(this.tmpPropertiesFile.toString());){
            this.properties.setProperty(PARTITION_INTERVAL_STRING, String.valueOf(partitionInterval));
            this.properties.setProperty(TSFILE_FILE_SYSTEM_STRING, tsfileFileSystem);
            this.properties.setProperty(IOTDB_VERSION_STRING, IoTDBConstant.VERSION);
            this.properties.setProperty(ENABLE_PARTITION_STRING, String.valueOf(enablePartition));
            this.properties.setProperty(TAG_ATTRIBUTE_SIZE_STRING, tagAttributeTotalSize);
            this.properties.setProperty(MAX_DEGREE_OF_INDEX_STRING, maxDegreeOfIndexNode);
            this.properties.store(tmpFOS, SYSTEM_PROPERTIES_STRING);
            if (this.propertiesFile.exists()) {
                Files.delete(this.propertiesFile.toPath());
            }
        }
        FileUtils.moveFile((File)this.tmpPropertiesFile, (File)this.propertiesFile);
    }

    private void upgradePropertiesFileFromBrokenFile() throws IOException {
        if (this.tmpPropertiesFile.createNewFile()) {
            logger.info("Create system.properties.tmp {}.", (Object)this.tmpPropertiesFile);
        } else {
            logger.error("Create system.properties.tmp {} failed.", (Object)this.tmpPropertiesFile);
            System.exit(-1);
        }
        try (FileOutputStream tmpFOS = new FileOutputStream(this.tmpPropertiesFile.toString());){
            this.systemProperties.forEach((k, v) -> {
                if (!this.properties.containsKey(k)) {
                    this.properties.setProperty((String)k, (String)v);
                }
            });
            this.properties.store(tmpFOS, SYSTEM_PROPERTIES_STRING);
            if (this.propertiesFile.exists()) {
                Files.delete(this.propertiesFile.toPath());
            }
        }
        FileUtils.moveFile((File)this.tmpPropertiesFile, (File)this.propertiesFile);
    }

    private void checkProperties() throws IOException {
        for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
            if (this.properties.containsKey(entry.getKey())) continue;
            this.upgradePropertiesFileFromBrokenFile();
            logger.info("repair system.properties, lack {}", (Object)entry.getKey());
        }
        if (!this.properties.getProperty(TIMESTAMP_PRECISION_STRING).equals(timestampPrecision)) {
            this.printErrorLogAndExit(TIMESTAMP_PRECISION_STRING);
        }
        if (Long.parseLong(this.properties.getProperty(PARTITION_INTERVAL_STRING)) != partitionInterval) {
            this.printErrorLogAndExit(PARTITION_INTERVAL_STRING);
        }
        if (!this.properties.getProperty(TSFILE_FILE_SYSTEM_STRING).equals(tsfileFileSystem)) {
            this.printErrorLogAndExit(TSFILE_FILE_SYSTEM_STRING);
        }
        if (!this.properties.getProperty(TAG_ATTRIBUTE_SIZE_STRING).equals(tagAttributeTotalSize)) {
            this.printErrorLogAndExit(TAG_ATTRIBUTE_SIZE_STRING);
        }
        if (!this.properties.getProperty(MAX_DEGREE_OF_INDEX_STRING).equals(maxDegreeOfIndexNode)) {
            this.printErrorLogAndExit(MAX_DEGREE_OF_INDEX_STRING);
        }
        if (!this.properties.getProperty(TIME_ENCODER_KEY).equals(timeEncoderValue)) {
            this.printErrorLogAndExit(TIME_ENCODER_KEY);
        }
    }

    private void printErrorLogAndExit(String property) {
        logger.error("Wrong {}, please set as: {} !", (Object)property, (Object)this.properties.getProperty(property));
        System.exit(-1);
    }

    private void checkUnClosedTsFileV2() {
        if (SystemFileFactory.INSTANCE.getFile(WAL_DIR).isDirectory() && SystemFileFactory.INSTANCE.getFile(WAL_DIR).list().length != 0) {
            logger.error("Unclosed Version-2 TsFile detected, please run 'flush' on v0.10 IoTDB before upgrading to v0.11");
            System.exit(-1);
        }
        this.checkUnClosedTsFileV2InFolders(DirectoryManager.getInstance().getAllSequenceFileFolders());
        this.checkUnClosedTsFileV2InFolders(DirectoryManager.getInstance().getAllUnSequenceFileFolders());
    }

    private void checkUnClosedTsFileV2InFolders(List<String> folders) {
        for (String baseDir : folders) {
            File fileFolder = FSFactoryProducer.getFSFactory().getFile(baseDir);
            if (!fileFolder.isDirectory()) continue;
            for (File storageGroup : fileFolder.listFiles()) {
                if (!storageGroup.isDirectory()) continue;
                for (File partitionDir : storageGroup.listFiles()) {
                    File[] resources;
                    File[] tsfiles;
                    if (!partitionDir.isDirectory() || (tsfiles = FSFactoryProducer.getFSFactory().listFilesBySuffix(partitionDir.toString(), ".tsfile")).length == (resources = FSFactoryProducer.getFSFactory().listFilesBySuffix(partitionDir.toString(), ".resource")).length) continue;
                    logger.error("Unclosed Version-2 TsFile detected, please run 'flush' on v0.10 IoTDB before upgrading to v0.11");
                    System.exit(-1);
                }
            }
        }
    }

    private static class IoTDBConfigCheckHolder {
        private static final IoTDBConfigCheck INSTANCE = new IoTDBConfigCheck();

        private IoTDBConfigCheckHolder() {
        }
    }
}

