/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.v1.file.metadata;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.tsfile.utils.BloomFilter;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.v1.file.metadata.TsDeviceMetadataIndexV1;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class TsFileMetadataV1 {
    private Map<String, TsDeviceMetadataIndexV1> deviceIndexMap = new HashMap<String, TsDeviceMetadataIndexV1>();
    private Map<String, MeasurementSchema> measurementSchema = new HashMap<String, MeasurementSchema>();
    private BloomFilter bloomFilter;

    public static TsFileMetadataV1 deserializeFrom(ByteBuffer buffer) {
        TsFileMetadataV1 fileMetaData = new TsFileMetadataV1();
        int size = ReadWriteIOUtils.readInt(buffer);
        if (size > 0) {
            HashMap<String, TsDeviceMetadataIndexV1> deviceMap = new HashMap<String, TsDeviceMetadataIndexV1>();
            for (int i = 0; i < size; ++i) {
                String key = ReadWriteIOUtils.readString(buffer);
                TsDeviceMetadataIndexV1 value = TsDeviceMetadataIndexV1.deserializeFrom(buffer);
                deviceMap.put(key, value);
            }
            fileMetaData.deviceIndexMap = deviceMap;
        }
        if ((size = ReadWriteIOUtils.readInt(buffer)) > 0) {
            fileMetaData.measurementSchema = new HashMap<String, MeasurementSchema>();
            for (int i = 0; i < size; ++i) {
                String key = ReadWriteIOUtils.readString(buffer);
                MeasurementSchema value = MeasurementSchema.deserializeFrom(buffer);
                fileMetaData.measurementSchema.put(key, value);
            }
        }
        if (ReadWriteIOUtils.readIsNull(buffer)) {
            ReadWriteIOUtils.readString(buffer);
        }
        ReadWriteIOUtils.readInt(buffer);
        ReadWriteIOUtils.readInt(buffer);
        if (buffer.hasRemaining()) {
            byte[] bytes = ReadWriteIOUtils.readByteBufferWithSelfDescriptionLength(buffer).array();
            int filterSize = ReadWriteIOUtils.readInt(buffer);
            int hashFunctionSize = ReadWriteIOUtils.readInt(buffer);
            fileMetaData.bloomFilter = BloomFilter.buildBloomFilter(bytes, filterSize, hashFunctionSize);
        }
        return fileMetaData;
    }

    public BloomFilter getBloomFilter() {
        return this.bloomFilter;
    }

    public Map<String, TsDeviceMetadataIndexV1> getDeviceMap() {
        return this.deviceIndexMap;
    }

    public boolean containsDevice(String deltaObjUid) {
        return this.deviceIndexMap.containsKey(deltaObjUid);
    }

    public TsDeviceMetadataIndexV1 getDeviceMetadataIndex(String deviceUid) {
        return this.deviceIndexMap.get(deviceUid);
    }
}

