/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.writelog.io;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.zip.CRC32;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.writelog.io.BatchLogReader;
import org.apache.iotdb.db.writelog.io.ILogReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleFileLogReader
implements ILogReader {
    public static final int LEAST_LOG_SIZE = 12;
    private static final Logger logger = LoggerFactory.getLogger(SingleFileLogReader.class);
    private DataInputStream logStream;
    private String filepath;
    private byte[] buffer;
    private CRC32 checkSummer = new CRC32();
    private int idx;
    private BatchLogReader batchLogReader;
    private boolean fileCorrupted = false;

    public SingleFileLogReader(File logFile) throws FileNotFoundException {
        this.open(logFile);
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.batchLogReader != null && this.batchLogReader.hasNext()) {
                return true;
            }
            if (this.logStream.available() < 12) {
                return false;
            }
            int logSize = this.logStream.readInt();
            if (logSize <= 0) {
                return false;
            }
            this.buffer = new byte[logSize];
            int readLen = this.logStream.read(this.buffer, 0, logSize);
            if (readLen < logSize) {
                throw new IOException("Reach eof");
            }
            long checkSum = this.logStream.readLong();
            this.checkSummer.reset();
            this.checkSummer.update(this.buffer, 0, logSize);
            if (this.checkSummer.getValue() != checkSum) {
                throw new IOException(String.format("The check sum of the No.%d log batch is incorrect! In file: %d Calculated: %d.", this.idx, checkSum, this.checkSummer.getValue()));
            }
            this.batchLogReader = new BatchLogReader(ByteBuffer.wrap(this.buffer));
            this.fileCorrupted = this.fileCorrupted || this.batchLogReader.isFileCorrupted();
        }
        catch (Exception e) {
            logger.error("Cannot read more PhysicalPlans from {}, successfully read index is {}. The reason is", new Object[]{this.idx, this.filepath, e});
            this.fileCorrupted = true;
            return false;
        }
        return true;
    }

    @Override
    public PhysicalPlan next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.idx;
        return this.batchLogReader.next();
    }

    @Override
    public void close() {
        if (this.logStream != null) {
            try {
                this.logStream.close();
            }
            catch (IOException e) {
                logger.error("Cannot close log file {}", (Object)this.filepath, (Object)e);
            }
        }
    }

    public void open(File logFile) throws FileNotFoundException {
        this.close();
        this.logStream = new DataInputStream(new BufferedInputStream(new FileInputStream(logFile)));
        logger.info("WAL file: {} size is {}", (Object)logFile.getName(), (Object)logFile.length());
        this.filepath = logFile.getPath();
        this.idx = 0;
    }

    public boolean isFileCorrupted() {
        return this.fileCorrupted;
    }
}

