/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.rescon.PrimitiveArrayManager;
import org.apache.iotdb.db.utils.MathUtils;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class DoubleTVList
extends TVList {
    private List<double[]> values = new ArrayList<double[]>();
    private double[][] sortedValues;
    private double pivotValue;

    DoubleTVList() {
    }

    @Override
    public void putDouble(long timestamp, double value) {
        this.checkExpansion();
        int arrayIndex = this.size / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = this.size % PrimitiveArrayManager.ARRAY_SIZE;
        this.minTime = this.minTime <= timestamp ? this.minTime : timestamp;
        ((long[])this.timestamps.get((int)arrayIndex))[elementIndex] = timestamp;
        this.values.get((int)arrayIndex)[elementIndex] = value;
        ++this.size;
        if (this.sorted && this.size > 1 && timestamp < this.getTime(this.size - 2)) {
            this.sorted = false;
        }
    }

    @Override
    public double getDouble(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = index % PrimitiveArrayManager.ARRAY_SIZE;
        return this.values.get(arrayIndex)[elementIndex];
    }

    protected void set(int index, long timestamp, double value) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = index % PrimitiveArrayManager.ARRAY_SIZE;
        ((long[])this.timestamps.get((int)arrayIndex))[elementIndex] = timestamp;
        this.values.get((int)arrayIndex)[elementIndex] = value;
    }

    @Override
    public DoubleTVList clone() {
        DoubleTVList cloneList = new DoubleTVList();
        this.cloneAs(cloneList);
        for (double[] valueArray : this.values) {
            cloneList.values.add(this.cloneValue(valueArray));
        }
        return cloneList;
    }

    private double[] cloneValue(double[] array) {
        double[] cloneArray = new double[array.length];
        System.arraycopy(array, 0, cloneArray, 0, array.length);
        return cloneArray;
    }

    @Override
    public void sort() {
        if (this.sortedTimestamps == null || this.sortedTimestamps.length < this.size) {
            this.sortedTimestamps = (long[][])PrimitiveArrayManager.createDataListsByType(TSDataType.INT64, this.size);
        }
        if (this.sortedValues == null || this.sortedValues.length < this.size) {
            this.sortedValues = (double[][])PrimitiveArrayManager.createDataListsByType(TSDataType.DOUBLE, this.size);
        }
        this.sort(0, this.size);
        this.clearSortedValue();
        this.clearSortedTime();
        this.sorted = true;
    }

    @Override
    void clearValue() {
        if (this.values != null) {
            for (double[] dataArray : this.values) {
                PrimitiveArrayManager.release(dataArray);
            }
            this.values.clear();
        }
    }

    @Override
    void clearSortedValue() {
        if (this.sortedValues != null) {
            this.sortedValues = null;
        }
    }

    @Override
    protected void setFromSorted(int src, int dest) {
        this.set(dest, this.sortedTimestamps[src / PrimitiveArrayManager.ARRAY_SIZE][src % PrimitiveArrayManager.ARRAY_SIZE], this.sortedValues[src / PrimitiveArrayManager.ARRAY_SIZE][src % PrimitiveArrayManager.ARRAY_SIZE]);
    }

    @Override
    protected void set(int src, int dest) {
        long srcT = this.getTime(src);
        double srcV = this.getDouble(src);
        this.set(dest, srcT, srcV);
    }

    @Override
    protected void setToSorted(int src, int dest) {
        this.sortedTimestamps[dest / PrimitiveArrayManager.ARRAY_SIZE][dest % PrimitiveArrayManager.ARRAY_SIZE] = this.getTime(src);
        this.sortedValues[dest / PrimitiveArrayManager.ARRAY_SIZE][dest % PrimitiveArrayManager.ARRAY_SIZE] = this.getDouble(src);
    }

    @Override
    protected void reverseRange(int lo, int hi) {
        --hi;
        while (lo < hi) {
            long loT = this.getTime(lo);
            double loV = this.getDouble(lo);
            long hiT = this.getTime(hi);
            double hiV = this.getDouble(hi);
            this.set(lo++, hiT, hiV);
            this.set(hi--, loT, loV);
        }
    }

    @Override
    protected void expandValues() {
        this.values.add((double[])this.getPrimitiveArraysByType(TSDataType.DOUBLE));
    }

    @Override
    protected void saveAsPivot(int pos) {
        this.pivotTime = this.getTime(pos);
        this.pivotValue = this.getDouble(pos);
    }

    @Override
    protected void setPivotTo(int pos) {
        this.set(pos, this.pivotTime, this.pivotValue);
    }

    @Override
    public TimeValuePair getTimeValuePair(int index) {
        return new TimeValuePair(this.getTime(index), TsPrimitiveType.getByType((TSDataType)TSDataType.DOUBLE, (Object)this.getDouble(index)));
    }

    @Override
    protected TimeValuePair getTimeValuePair(int index, long time, Integer floatPrecision, TSEncoding encoding) {
        double value = this.getDouble(index);
        if (!(Double.isNaN(value) || encoding != TSEncoding.RLE && encoding != TSEncoding.TS_2DIFF)) {
            value = MathUtils.roundWithGivenPrecision(value, (int)floatPrecision);
        }
        return new TimeValuePair(time, TsPrimitiveType.getByType((TSDataType)TSDataType.DOUBLE, (Object)value));
    }

    @Override
    protected void releaseLastValueArray() {
        PrimitiveArrayManager.release(this.values.remove(this.values.size() - 1));
    }

    @Override
    public void putDoubles(long[] time, double[] value, int start, int end) {
        this.checkExpansion();
        int idx = start;
        this.updateMinTimeAndSorted(time, start, end);
        while (idx < end) {
            int inputRemaining = end - idx;
            int arrayIdx = this.size / PrimitiveArrayManager.ARRAY_SIZE;
            int elementIdx = this.size % PrimitiveArrayManager.ARRAY_SIZE;
            int internalRemaining = PrimitiveArrayManager.ARRAY_SIZE - elementIdx;
            if (internalRemaining >= inputRemaining) {
                System.arraycopy(time, idx, this.timestamps.get(arrayIdx), elementIdx, inputRemaining);
                System.arraycopy(value, idx, this.values.get(arrayIdx), elementIdx, inputRemaining);
                this.size += inputRemaining;
                break;
            }
            System.arraycopy(time, idx, this.timestamps.get(arrayIdx), elementIdx, internalRemaining);
            System.arraycopy(value, idx, this.values.get(arrayIdx), elementIdx, internalRemaining);
            idx += internalRemaining;
            this.size += internalRemaining;
            this.checkExpansion();
        }
    }
}

