/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.JMXService;
import org.apache.iotdb.db.service.MonitorMBean;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.db.utils.OpenFileNumUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Monitor
implements MonitorMBean,
IService {
    private static final Logger logger = LoggerFactory.getLogger(Monitor.class);
    public static final Monitor INSTANCE = new Monitor();
    private final String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.service", "type", this.getID().getJmxName());
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    public static Monitor getInstance() {
        return INSTANCE;
    }

    @Override
    public long getDataSizeInByte() {
        try {
            long totalSize = 0L;
            for (String dataDir : this.config.getDataDirs()) {
                totalSize += FileUtils.sizeOfDirectory((File)SystemFileFactory.INSTANCE.getFile(dataDir));
            }
            return totalSize;
        }
        catch (Exception e) {
            logger.error("meet error while trying to get data size.", (Throwable)e);
            return -1L;
        }
    }

    @Override
    public int getFileNodeNum() {
        return 0;
    }

    @Override
    public long getOverflowCacheSize() {
        return 0L;
    }

    @Override
    public long getBufferWriteCacheSize() {
        return 0L;
    }

    @Override
    public String getSystemDirectory() {
        try {
            File file = SystemFileFactory.INSTANCE.getFile(this.config.getSystemDir());
            return file.getAbsolutePath();
        }
        catch (Exception e) {
            logger.error("meet error while trying to get base dir.", (Throwable)e);
            return "Unavailable";
        }
    }

    @Override
    public boolean getWriteAheadLogStatus() {
        return this.config.isEnableWal();
    }

    @Override
    public int getTotalOpenFileNum() {
        return OpenFileNumUtil.getInstance().get(OpenFileNumUtil.OpenFileNumStatistics.TOTAL_OPEN_FILE_NUM);
    }

    @Override
    public int getDataOpenFileNum() {
        return OpenFileNumUtil.getInstance().get(OpenFileNumUtil.OpenFileNumStatistics.SEQUENCE_FILE_OPEN_NUM);
    }

    @Override
    public int getWalOpenFileNum() {
        return OpenFileNumUtil.getInstance().get(OpenFileNumUtil.OpenFileNumStatistics.WAL_OPEN_FILE_NUM);
    }

    @Override
    public int getMetadataOpenFileNum() {
        return 0;
    }

    @Override
    public int getDigestOpenFileNum() {
        return OpenFileNumUtil.getInstance().get(OpenFileNumUtil.OpenFileNumStatistics.DIGEST_OPEN_FILE_NUM);
    }

    @Override
    public int getSocketOpenFileNum() {
        return OpenFileNumUtil.getInstance().get(OpenFileNumUtil.OpenFileNumStatistics.SOCKET_OPEN_FILE_NUM);
    }

    @Override
    public void start() throws StartupException {
        try {
            JMXService.registerMBean(INSTANCE, this.mbeanName);
        }
        catch (Exception e) {
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
    }

    @Override
    public void stop() {
        JMXService.deregisterMBean(this.mbeanName);
    }

    @Override
    public ServiceType getID() {
        return ServiceType.MONITOR_SERVICE;
    }
}

