/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.reader.page;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.BatchDataFactory;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IPageReader;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;

public class PageReader
implements IPageReader {
    private PageHeader pageHeader;
    private TSDataType dataType;
    private Decoder valueDecoder;
    private Decoder timeDecoder;
    private ByteBuffer timeBuffer;
    private ByteBuffer valueBuffer;
    private Filter filter;
    private List<TimeRange> deleteIntervalList;
    private int deleteCursor = 0;

    public PageReader(ByteBuffer pageData, TSDataType dataType, Decoder valueDecoder, Decoder timeDecoder, Filter filter) {
        this(null, pageData, dataType, valueDecoder, timeDecoder, filter);
    }

    public PageReader(PageHeader pageHeader, ByteBuffer pageData, TSDataType dataType, Decoder valueDecoder, Decoder timeDecoder, Filter filter) {
        this.dataType = dataType;
        this.valueDecoder = valueDecoder;
        this.timeDecoder = timeDecoder;
        this.filter = filter;
        this.pageHeader = pageHeader;
        this.splitDataToTimeStampAndValue(pageData);
    }

    private void splitDataToTimeStampAndValue(ByteBuffer pageData) {
        int timeBufferLength = ReadWriteForEncodingUtils.readUnsignedVarInt(pageData);
        this.timeBuffer = pageData.slice();
        this.timeBuffer.limit(timeBufferLength);
        this.valueBuffer = pageData.slice();
        this.valueBuffer.position(timeBufferLength);
    }

    @Override
    public BatchData getAllSatisfiedPageData(boolean ascending) throws IOException {
        BatchData pageData = BatchDataFactory.createBatchData(this.dataType, ascending, false);
        block8: while (this.timeDecoder.hasNext(this.timeBuffer)) {
            long timestamp = this.timeDecoder.readLong(this.timeBuffer);
            switch (this.dataType) {
                case BOOLEAN: {
                    boolean aBoolean = this.valueDecoder.readBoolean(this.valueBuffer);
                    if (this.isDeleted(timestamp) || this.filter != null && !this.filter.satisfy(timestamp, aBoolean)) continue block8;
                    pageData.putBoolean(timestamp, aBoolean);
                    continue block8;
                }
                case INT32: {
                    int anInt = this.valueDecoder.readInt(this.valueBuffer);
                    if (this.isDeleted(timestamp) || this.filter != null && !this.filter.satisfy(timestamp, anInt)) continue block8;
                    pageData.putInt(timestamp, anInt);
                    continue block8;
                }
                case INT64: {
                    long aLong = this.valueDecoder.readLong(this.valueBuffer);
                    if (this.isDeleted(timestamp) || this.filter != null && !this.filter.satisfy(timestamp, aLong)) continue block8;
                    pageData.putLong(timestamp, aLong);
                    continue block8;
                }
                case FLOAT: {
                    float aFloat = this.valueDecoder.readFloat(this.valueBuffer);
                    if (this.isDeleted(timestamp) || this.filter != null && !this.filter.satisfy(timestamp, Float.valueOf(aFloat))) continue block8;
                    pageData.putFloat(timestamp, aFloat);
                    continue block8;
                }
                case DOUBLE: {
                    double aDouble = this.valueDecoder.readDouble(this.valueBuffer);
                    if (this.isDeleted(timestamp) || this.filter != null && !this.filter.satisfy(timestamp, aDouble)) continue block8;
                    pageData.putDouble(timestamp, aDouble);
                    continue block8;
                }
                case TEXT: {
                    Binary aBinary = this.valueDecoder.readBinary(this.valueBuffer);
                    if (this.isDeleted(timestamp) || this.filter != null && !this.filter.satisfy(timestamp, aBinary)) continue block8;
                    pageData.putBinary(timestamp, aBinary);
                    continue block8;
                }
            }
            throw new UnSupportedDataTypeException(String.valueOf((Object)this.dataType));
        }
        return pageData.flip();
    }

    @Override
    public Statistics getStatistics() {
        return this.pageHeader.getStatistics();
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void setDeleteIntervalList(List<TimeRange> list) {
        this.deleteIntervalList = list;
    }

    public List<TimeRange> getDeleteIntervalList() {
        return this.deleteIntervalList;
    }

    @Override
    public boolean isModified() {
        return this.pageHeader.isModified();
    }

    private boolean isDeleted(long timestamp) {
        while (this.deleteIntervalList != null && this.deleteCursor < this.deleteIntervalList.size()) {
            if (this.deleteIntervalList.get(this.deleteCursor).contains(timestamp)) {
                return true;
            }
            if (this.deleteIntervalList.get(this.deleteCursor).getMax() < timestamp) {
                ++this.deleteCursor;
                continue;
            }
            return false;
        }
        return false;
    }
}

