/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common;

import java.io.Serializable;

public class Path
implements Serializable,
Comparable<Path> {
    private static final long serialVersionUID = 3405277066329298200L;
    private String measurement;
    protected String device;
    protected String fullPath;
    private static final String ILLEGAL_PATH_ARGUMENT = "Path parameter is null";

    public Path() {
    }

    public Path(String pathSc) {
        this(pathSc, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Path(String pathSc, boolean needSplit) {
        if (pathSc == null) {
            throw new IllegalArgumentException(ILLEGAL_PATH_ARGUMENT);
        }
        if (!needSplit) {
            this.fullPath = pathSc;
            return;
        } else if (pathSc.length() > 0) {
            if (pathSc.charAt(pathSc.length() - 1) == '\"') {
                int endIndex = pathSc.lastIndexOf(34, pathSc.length() - 2);
                while (endIndex != -1 && pathSc.charAt(endIndex - 1) == '\\') {
                    endIndex = pathSc.lastIndexOf(34, endIndex - 2);
                }
                if (endIndex == -1 || endIndex != 0 && pathSc.charAt(endIndex - 1) != '.') throw new IllegalArgumentException(ILLEGAL_PATH_ARGUMENT);
                this.fullPath = pathSc;
                this.device = pathSc.substring(0, endIndex - 1);
                this.measurement = pathSc.substring(endIndex);
                return;
            } else {
                if (pathSc.charAt(pathSc.length() - 1) == '\"' || pathSc.charAt(pathSc.length() - 1) == '.') throw new IllegalArgumentException(ILLEGAL_PATH_ARGUMENT);
                int endIndex = pathSc.lastIndexOf(46);
                if (endIndex < 0) {
                    this.fullPath = pathSc;
                    this.device = "";
                    this.measurement = pathSc;
                    return;
                } else {
                    this.fullPath = pathSc;
                    this.device = pathSc.substring(0, endIndex);
                    this.measurement = pathSc.substring(endIndex + 1);
                }
            }
            return;
        } else {
            this.fullPath = pathSc;
            this.device = "";
            this.measurement = pathSc;
        }
    }

    public Path(String device, String measurement) {
        if (device == null || measurement == null) {
            throw new IllegalArgumentException(ILLEGAL_PATH_ARGUMENT);
        }
        this.device = device;
        this.measurement = measurement;
        this.fullPath = !device.equals("") ? device + "." + measurement : measurement;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public String getDevice() {
        return this.device;
    }

    public String getMeasurement() {
        return this.measurement;
    }

    public String getFullPathWithAlias() {
        throw new IllegalArgumentException("doesn't alias in TSFile Path");
    }

    public int hashCode() {
        return this.fullPath.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Path && this.fullPath.equals(((Path)obj).fullPath);
    }

    public boolean equals(String obj) {
        return this.fullPath.equals(obj);
    }

    @Override
    public int compareTo(Path path) {
        return this.fullPath.compareTo(path.getFullPath());
    }

    public String toString() {
        return this.fullPath;
    }

    public Path clone() {
        return new Path(this.fullPath);
    }
}

