/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.fileSystem.fsFactory;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSFactory
implements FSFactory {
    private static final Logger logger = LoggerFactory.getLogger(HDFSFactory.class);
    private static Constructor constructorWithPathname;
    private static Constructor constructorWithParentStringAndChild;
    private static Constructor constructorWithParentFileAndChild;
    private static Constructor constructorWithUri;
    private static Method getBufferedReader;
    private static Method getBufferedWriter;
    private static Method getBufferedInputStream;
    private static Method getBufferedOutputStream;
    private static Method listFilesBySuffix;
    private static Method listFilesByPrefix;
    private static Method renameTo;

    @Override
    public File getFileWithParent(String pathname) {
        try {
            File res = (File)constructorWithPathname.newInstance(pathname);
            if (!res.exists()) {
                res.getParentFile().mkdirs();
            }
            return res;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get file: {}. Please check your dependency of Hadoop module.", (Object)pathname, (Object)e);
            return null;
        }
    }

    @Override
    public File getFile(String pathname) {
        try {
            return (File)constructorWithPathname.newInstance(pathname);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get file: {}. Please check your dependency of Hadoop module.", (Object)pathname, (Object)e);
            return null;
        }
    }

    @Override
    public File getFile(String parent, String child) {
        try {
            return (File)constructorWithParentStringAndChild.newInstance(parent, child);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get file: {}. Please check your dependency of Hadoop module.", (Object)(parent + File.separator + child), (Object)e);
            return null;
        }
    }

    @Override
    public File getFile(File parent, String child) {
        try {
            return (File)constructorWithParentFileAndChild.newInstance(parent, child);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get file: {}. Please check your dependency of Hadoop module.", (Object)(parent.getAbsolutePath() + File.separator + child), (Object)e);
            return null;
        }
    }

    @Override
    public File getFile(URI uri) {
        try {
            return (File)constructorWithUri.newInstance(uri);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get file: {}. Please check your dependency of Hadoop module.", (Object)uri, (Object)e);
            return null;
        }
    }

    @Override
    public BufferedReader getBufferedReader(String filePath) {
        try {
            return (BufferedReader)getBufferedReader.invoke(constructorWithPathname.newInstance(filePath), filePath);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get buffered reader for {}. Please check your dependency of Hadoop module.", (Object)filePath, (Object)e);
            return null;
        }
    }

    @Override
    public BufferedWriter getBufferedWriter(String filePath, boolean append) {
        try {
            return (BufferedWriter)getBufferedWriter.invoke(constructorWithPathname.newInstance(filePath), filePath, append);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get buffered writer for {}. Please check your dependency of Hadoop module.", (Object)filePath, (Object)e);
            return null;
        }
    }

    @Override
    public BufferedInputStream getBufferedInputStream(String filePath) {
        try {
            return (BufferedInputStream)getBufferedInputStream.invoke(constructorWithPathname.newInstance(filePath), filePath);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get buffered input stream for {}. Please check your dependency of Hadoop module.", (Object)filePath, (Object)e);
            return null;
        }
    }

    @Override
    public BufferedOutputStream getBufferedOutputStream(String filePath) {
        try {
            return (BufferedOutputStream)getBufferedOutputStream.invoke(constructorWithPathname.newInstance(filePath), filePath);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get buffered output stream for {}. Please check your dependency of Hadoop module.", (Object)filePath, (Object)e);
            return null;
        }
    }

    @Override
    public void moveFile(File srcFile, File destFile) {
        try {
            renameTo.invoke(constructorWithPathname.newInstance(srcFile.getAbsolutePath()), destFile);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to rename file from {} to {}. Please check your dependency of Hadoop module.", (Object)srcFile.getName(), (Object)destFile.getName());
        }
    }

    @Override
    public File[] listFilesBySuffix(String fileFolder, String suffix) {
        try {
            return (File[])listFilesBySuffix.invoke(constructorWithPathname.newInstance(fileFolder), fileFolder, suffix);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to list files in {} with SUFFIX {}. Please check your dependency of Hadoop module.", new Object[]{fileFolder, suffix, e});
            return null;
        }
    }

    @Override
    public File[] listFilesByPrefix(String fileFolder, String prefix) {
        try {
            return (File[])listFilesByPrefix.invoke(constructorWithPathname.newInstance(fileFolder), fileFolder, prefix);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to list files in {} with PREFIX {}. Please check your dependency of Hadoop module.", new Object[]{fileFolder, prefix, e});
            return null;
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("org.apache.iotdb.hadoop.fileSystem.HDFSFile");
            constructorWithPathname = clazz.getConstructor(String.class);
            constructorWithParentStringAndChild = clazz.getConstructor(String.class, String.class);
            constructorWithParentFileAndChild = clazz.getConstructor(File.class, String.class);
            constructorWithUri = clazz.getConstructor(URI.class);
            getBufferedReader = clazz.getMethod("getBufferedReader", String.class);
            getBufferedWriter = clazz.getMethod("getBufferedWriter", String.class, Boolean.TYPE);
            getBufferedInputStream = clazz.getMethod("getBufferedInputStream", String.class);
            getBufferedOutputStream = clazz.getMethod("getBufferedOutputStream", String.class);
            listFilesBySuffix = clazz.getMethod("listFilesBySuffix", String.class, String.class);
            listFilesByPrefix = clazz.getMethod("listFilesByPrefix", String.class, String.class);
            renameTo = clazz.getMethod("renameTo", File.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            logger.error("Failed to get Hadoop file system. Please check your dependency of Hadoop module.", (Throwable)e);
        }
    }
}

