/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class FloatStatistics
extends Statistics<Float> {
    private float minValue;
    private float maxValue;
    private float firstValue;
    private float lastValue;
    private double sumValue;
    static final int FLOAT_STATISTICS_FIXED_RAM_SIZE = 64;

    @Override
    public TSDataType getType() {
        return TSDataType.FLOAT;
    }

    @Override
    public int getStatsSize() {
        return 24;
    }

    public void initializeStats(float min, float max, float first, float last, double sum) {
        this.minValue = min;
        this.maxValue = max;
        this.firstValue = first;
        this.lastValue = last;
        this.sumValue = sum;
    }

    private void updateStats(float minValue, float maxValue, float last, double sumValue) {
        if (minValue < this.minValue) {
            this.minValue = minValue;
        }
        if (maxValue > this.maxValue) {
            this.maxValue = maxValue;
        }
        this.sumValue += sumValue;
        this.lastValue = last;
    }

    private void updateStats(float minValue, float maxValue, float first, float last, double sumValue, long startTime, long endTime) {
        if (minValue < this.minValue) {
            this.minValue = minValue;
        }
        if (maxValue > this.maxValue) {
            this.maxValue = maxValue;
        }
        this.sumValue += sumValue;
        if (startTime <= this.getStartTime()) {
            this.firstValue = first;
        }
        if (endTime >= this.getEndTime()) {
            this.lastValue = last;
        }
    }

    @Override
    public void setMinMaxFromBytes(byte[] minBytes, byte[] maxBytes) {
        this.minValue = BytesUtils.bytesToFloat(minBytes);
        this.maxValue = BytesUtils.bytesToFloat(maxBytes);
    }

    @Override
    void updateStats(float value) {
        if (this.isEmpty) {
            this.initializeStats(value, value, value, value, value);
            this.isEmpty = false;
        } else {
            this.updateStats(value, value, value, value);
        }
    }

    @Override
    void updateStats(float[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.updateStats(values[i]);
        }
    }

    @Override
    public long calculateRamSize() {
        return 64L;
    }

    @Override
    public Float getMinValue() {
        return Float.valueOf(this.minValue);
    }

    @Override
    public Float getMaxValue() {
        return Float.valueOf(this.maxValue);
    }

    @Override
    public Float getFirstValue() {
        return Float.valueOf(this.firstValue);
    }

    @Override
    public Float getLastValue() {
        return Float.valueOf(this.lastValue);
    }

    @Override
    public double getSumValue() {
        return this.sumValue;
    }

    @Override
    protected void mergeStatisticsValue(Statistics stats) {
        FloatStatistics floatStats = (FloatStatistics)stats;
        if (this.isEmpty) {
            this.initializeStats(floatStats.getMinValue().floatValue(), floatStats.getMaxValue().floatValue(), floatStats.getFirstValue().floatValue(), floatStats.getLastValue().floatValue(), floatStats.getSumValue());
            this.isEmpty = false;
        } else {
            this.updateStats(floatStats.getMinValue().floatValue(), floatStats.getMaxValue().floatValue(), floatStats.getFirstValue().floatValue(), floatStats.getLastValue().floatValue(), floatStats.getSumValue(), stats.getStartTime(), stats.getEndTime());
        }
    }

    @Override
    public byte[] getMinValueBytes() {
        return BytesUtils.floatToBytes(this.minValue);
    }

    @Override
    public byte[] getMaxValueBytes() {
        return BytesUtils.floatToBytes(this.maxValue);
    }

    @Override
    public byte[] getFirstValueBytes() {
        return BytesUtils.floatToBytes(this.firstValue);
    }

    @Override
    public byte[] getLastValueBytes() {
        return BytesUtils.floatToBytes(this.lastValue);
    }

    @Override
    public byte[] getSumValueBytes() {
        return BytesUtils.doubleToBytes(this.sumValue);
    }

    @Override
    public ByteBuffer getMinValueBuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.minValue);
    }

    @Override
    public ByteBuffer getMaxValueBuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.maxValue);
    }

    @Override
    public ByteBuffer getFirstValueBuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.firstValue);
    }

    @Override
    public ByteBuffer getLastValueBuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.lastValue);
    }

    @Override
    public ByteBuffer getSumValueBuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.sumValue);
    }

    @Override
    public int serializeStats(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.minValue, outputStream);
        byteLen += ReadWriteIOUtils.write(this.maxValue, outputStream);
        byteLen += ReadWriteIOUtils.write(this.firstValue, outputStream);
        byteLen += ReadWriteIOUtils.write(this.lastValue, outputStream);
        return byteLen += ReadWriteIOUtils.write(this.sumValue, outputStream);
    }

    @Override
    void deserialize(InputStream inputStream) throws IOException {
        this.minValue = ReadWriteIOUtils.readFloat(inputStream);
        this.maxValue = ReadWriteIOUtils.readFloat(inputStream);
        this.firstValue = ReadWriteIOUtils.readFloat(inputStream);
        this.lastValue = ReadWriteIOUtils.readFloat(inputStream);
        this.sumValue = ReadWriteIOUtils.readDouble(inputStream);
    }

    @Override
    void deserialize(ByteBuffer byteBuffer) {
        this.minValue = ReadWriteIOUtils.readFloat(byteBuffer);
        this.maxValue = ReadWriteIOUtils.readFloat(byteBuffer);
        this.firstValue = ReadWriteIOUtils.readFloat(byteBuffer);
        this.lastValue = ReadWriteIOUtils.readFloat(byteBuffer);
        this.sumValue = ReadWriteIOUtils.readDouble(byteBuffer);
    }

    @Override
    public String toString() {
        return super.toString() + " [minValue:" + this.minValue + ",maxValue:" + this.maxValue + ",firstValue:" + this.firstValue + ",lastValue:" + this.lastValue + ",sumValue:" + this.sumValue + "]";
    }
}

