/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.header;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PageHeader {
    private int uncompressedSize;
    private int compressedSize;
    private Statistics statistics;
    private boolean modified;

    public PageHeader(int uncompressedSize, int compressedSize, Statistics statistics) {
        this.uncompressedSize = uncompressedSize;
        this.compressedSize = compressedSize;
        this.statistics = statistics;
    }

    public static int calculatePageHeaderSizeWithoutStatistics() {
        return 8;
    }

    public static PageHeader deserializeFrom(InputStream inputStream, TSDataType dataType) throws IOException {
        int uncompressedSize = ReadWriteIOUtils.readInt(inputStream);
        int compressedSize = ReadWriteIOUtils.readInt(inputStream);
        Statistics statistics = Statistics.deserialize(inputStream, dataType);
        return new PageHeader(uncompressedSize, compressedSize, statistics);
    }

    public static PageHeader deserializeFrom(ByteBuffer buffer, TSDataType dataType) {
        int uncompressedSize = ReadWriteIOUtils.readInt(buffer);
        int compressedSize = ReadWriteIOUtils.readInt(buffer);
        Statistics statistics = Statistics.deserialize(buffer, dataType);
        return new PageHeader(uncompressedSize, compressedSize, statistics);
    }

    public int getUncompressedSize() {
        return this.uncompressedSize;
    }

    public void setUncompressedSize(int uncompressedSize) {
        this.uncompressedSize = uncompressedSize;
    }

    public int getCompressedSize() {
        return this.compressedSize;
    }

    public void setCompressedSize(int compressedSize) {
        this.compressedSize = compressedSize;
    }

    public long getNumOfValues() {
        return this.statistics.getCount();
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public long getEndTime() {
        return this.statistics.getEndTime();
    }

    public long getStartTime() {
        return this.statistics.getStartTime();
    }

    public void serializeTo(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write(this.uncompressedSize, outputStream);
        ReadWriteIOUtils.write(this.compressedSize, outputStream);
        this.statistics.serialize(outputStream);
    }

    public String toString() {
        return "PageHeader{uncompressedSize=" + this.uncompressedSize + ", compressedSize=" + this.compressedSize + ", statistics=" + this.statistics + "}";
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }
}

