/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.compress;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import org.apache.iotdb.tsfile.exception.compress.CompressionTypeNotSupportedException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.xerial.snappy.Snappy;

public interface ICompressor
extends Serializable {
    public static ICompressor getCompressor(String name) {
        return ICompressor.getCompressor(CompressionType.valueOf(name));
    }

    public static ICompressor getCompressor(CompressionType name) {
        if (name == null) {
            throw new CompressionTypeNotSupportedException("NULL");
        }
        switch (name) {
            case UNCOMPRESSED: {
                return new NoCompressor();
            }
            case SNAPPY: {
                return new SnappyCompressor();
            }
            case LZ4: {
                return new IOTDBLZ4Compressor();
            }
        }
        throw new CompressionTypeNotSupportedException(name.toString());
    }

    public byte[] compress(byte[] var1) throws IOException;

    public int compress(byte[] var1, int var2, int var3, byte[] var4) throws IOException;

    public int compress(ByteBuffer var1, ByteBuffer var2) throws IOException;

    public int getMaxBytesForCompression(int var1);

    public CompressionType getType();

    public static class IOTDBLZ4Compressor
    implements ICompressor {
        private LZ4Compressor compressor;

        public IOTDBLZ4Compressor() {
            LZ4Factory factory = LZ4Factory.fastestInstance();
            this.compressor = factory.fastCompressor();
        }

        @Override
        public byte[] compress(byte[] data) throws IOException {
            if (data == null) {
                return new byte[0];
            }
            return this.compressor.compress(data);
        }

        @Override
        public int compress(byte[] data, int offset, int length, byte[] compressed) throws IOException {
            return this.compressor.compress(data, offset, length, compressed, 0);
        }

        @Override
        public int compress(ByteBuffer data, ByteBuffer compressed) throws IOException {
            this.compressor.compress(data, compressed);
            return data.limit();
        }

        @Override
        public int getMaxBytesForCompression(int uncompressedDataSize) {
            return this.compressor.maxCompressedLength(uncompressedDataSize);
        }

        @Override
        public CompressionType getType() {
            return CompressionType.LZ4;
        }
    }

    public static class SnappyCompressor
    implements ICompressor {
        @Override
        public byte[] compress(byte[] data) throws IOException {
            if (data == null) {
                return new byte[0];
            }
            return Snappy.compress((byte[])data);
        }

        @Override
        public int compress(byte[] data, int offset, int length, byte[] compressed) throws IOException {
            return Snappy.compress((byte[])data, (int)offset, (int)length, (byte[])compressed, (int)0);
        }

        @Override
        public int compress(ByteBuffer data, ByteBuffer compressed) throws IOException {
            return Snappy.compress((ByteBuffer)data, (ByteBuffer)compressed);
        }

        @Override
        public int getMaxBytesForCompression(int uncompressedDataSize) {
            return Snappy.maxCompressedLength((int)uncompressedDataSize);
        }

        @Override
        public CompressionType getType() {
            return CompressionType.SNAPPY;
        }
    }

    public static class NoCompressor
    implements ICompressor {
        @Override
        public byte[] compress(byte[] data) {
            return data;
        }

        @Override
        public int compress(byte[] data, int offset, int length, byte[] compressed) throws IOException {
            throw new IOException("No Compressor does not support compression function");
        }

        @Override
        public int compress(ByteBuffer data, ByteBuffer compressed) throws IOException {
            throw new IOException("No Compressor does not support compression function");
        }

        @Override
        public int getMaxBytesForCompression(int uncompressedDataSize) {
            return uncompressedDataSize;
        }

        @Override
        public CompressionType getType() {
            return CompressionType.UNCOMPRESSED;
        }
    }
}

