/*
 * Decompiled with CFR 0.152.
 */
package com.librato.metrics.client;

import com.librato.metrics.client.Duration;
import com.librato.metrics.client.HttpResponse;
import com.librato.metrics.client.IPoster;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPoster
implements IPoster {
    private static final Logger log = LoggerFactory.getLogger(DefaultPoster.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse post(String uri, Duration connectTimeout, Duration readTimeout, Map<String, String> headers, byte[] payload) {
        try {
            byte[] responseBody;
            HttpURLConnection connection = this.open(uri);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setConnectTimeout((int)connectTimeout.to(TimeUnit.MILLISECONDS));
            connection.setReadTimeout((int)readTimeout.to(TimeUnit.MILLISECONDS));
            connection.setRequestMethod("POST");
            connection.setInstanceFollowRedirects(false);
            for (String header : headers.keySet()) {
                connection.setRequestProperty(header, headers.get(header));
            }
            connection.connect();
            OutputStream outputStream = connection.getOutputStream();
            try {
                outputStream.write(payload);
            }
            finally {
                this.close(outputStream);
            }
            final int responseCode = connection.getResponseCode();
            InputStream responseStream = responseCode / 100 == 2 ? connection.getInputStream() : connection.getErrorStream();
            if (responseStream == null) {
                log.warn("responseStream null for {} responseCode {}", (Object)uri, (Object)responseCode);
                responseBody = new byte[]{};
            } else {
                responseBody = this.readResponse(responseStream);
            }
            return new HttpResponse(){

                @Override
                public int getResponseCode() {
                    return responseCode;
                }

                @Override
                public byte[] getResponseBody() {
                    return responseBody;
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    HttpURLConnection open(String url) throws IOException {
        try {
            return (HttpURLConnection)new URL(url).openConnection();
        }
        catch (ClassCastException ignore) {
            throw new RuntimeException("URL " + url + " must use either http or https");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readResponse(InputStream in) throws IOException {
        try {
            int bytesRead;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((bytesRead = in.read(buffer)) > 0) {
                bos.write(buffer, 0, bytesRead);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            this.close(in);
        }
    }

    void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            log.warn("Could not close " + closeable, (Throwable)e);
        }
    }
}

