/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

public class IoTDBResultMetadata
implements ResultSetMetaData {
    private List<String> columnInfoList;
    private List<String> columnTypeList;
    private boolean ignoreTimestamp;

    public IoTDBResultMetadata(List<String> columnInfoList, List<String> columnTypeList, boolean ignoreTimestamp) {
        this.columnInfoList = columnInfoList;
        this.columnTypeList = columnTypeList;
        this.ignoreTimestamp = ignoreTimestamp;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getCatalogName(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        String columnTypeName;
        switch (columnTypeName = this.getColumnTypeName(column)) {
            case "TIMESTAMP": 
            case "INT64": {
                return Long.class.getName();
            }
            case "BOOLEAN": {
                return Boolean.class.getName();
            }
            case "INT32": {
                return Integer.class.getName();
            }
            case "FLOAT": {
                return Float.class.getName();
            }
            case "DOUBLE": {
                return Double.class.getName();
            }
            case "TEXT": {
                return String.class.getName();
            }
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return this.columnInfoList == null ? 0 : this.columnInfoList.size();
    }

    @Override
    public int getColumnDisplaySize(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.columnInfoList.get(column - 1);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumnLabel(column);
    }

    private void checkColumnIndex(int column) throws SQLException {
        if (this.columnInfoList == null || this.columnInfoList.isEmpty()) {
            throw new SQLException("No column exists");
        }
        if (column > this.columnInfoList.size()) {
            throw new SQLException(String.format("column %d does not exist", column));
        }
        if (column <= 0) {
            throw new SQLException("column index should start from 1");
        }
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        this.checkColumnIndex(column);
        if (column == 1 && !this.ignoreTimestamp) {
            return 93;
        }
        String columnType = !this.ignoreTimestamp ? this.columnTypeList.get(column - 2) : this.columnTypeList.get(column - 1);
        switch (columnType.toUpperCase()) {
            case "BOOLEAN": {
                return 16;
            }
            case "INT32": {
                return 4;
            }
            case "INT64": {
                return -5;
            }
            case "FLOAT": {
                return 6;
            }
            case "DOUBLE": {
                return 8;
            }
            case "TEXT": {
                return 12;
            }
        }
        return 0;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        this.checkColumnIndex(column);
        if (column == 1 && !this.ignoreTimestamp) {
            return "TIMESTAMP";
        }
        String columnType = !this.ignoreTimestamp ? this.columnTypeList.get(column - 2) : this.columnTypeList.get(column - 1);
        String typeString = columnType.toUpperCase();
        if (typeString.equals("BOOLEAN") || typeString.equals("INT32") || typeString.equals("INT64") || typeString.equals("FLOAT") || typeString.equals("DOUBLE") || typeString.equals("TEXT")) {
            return typeString;
        }
        return null;
    }

    @Override
    public int getPrecision(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getScale(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getSchemaName(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getTableName(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isAutoIncrement(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isCaseSensitive(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isCurrency(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isDefinitelyWritable(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int isNullable(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isReadOnly(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isSearchable(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isSigned(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isWritable(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }
}

