/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.series;

import java.io.IOException;
import java.util.Set;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.series.SeriesReader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class SeriesReaderByTimestamp
implements IReaderByTimestamp {
    private SeriesReader seriesReader;
    private BatchData batchData;
    private boolean ascending;

    public SeriesReaderByTimestamp(PartialPath seriesPath, Set<String> allSensors, TSDataType dataType, QueryContext context, QueryDataSource dataSource, TsFileFilter fileFilter, boolean ascending) {
        TimeFilter.TimeGtEq timeFilter = ascending ? TimeFilter.gtEq((long)Long.MIN_VALUE) : TimeFilter.ltEq((long)Long.MAX_VALUE);
        this.seriesReader = new SeriesReader(seriesPath, allSensors, dataType, context, dataSource, (Filter)timeFilter, null, fileFilter, ascending);
        this.ascending = ascending;
    }

    @Override
    public Object getValueInTimestamp(long timestamp) throws IOException {
        this.seriesReader.setTimeFilter(timestamp);
        if (!(this.batchData != null && this.hasAvailableData(this.batchData, timestamp) || this.hasNext(timestamp))) {
            return null;
        }
        return this.batchData.getValueInTimestamp(timestamp);
    }

    @Override
    public boolean readerIsEmpty() throws IOException {
        return this.seriesReader.isEmpty() && this.isEmpty(this.batchData);
    }

    protected boolean hasNext(long timestamp) throws IOException {
        if (this.readPageData(timestamp)) {
            return true;
        }
        if (this.readChunkData(timestamp)) {
            return true;
        }
        while (this.seriesReader.hasNextFile()) {
            Statistics statistics = this.seriesReader.currentFileStatistics();
            if (!this.satisfyTimeFilter(statistics)) {
                this.seriesReader.skipCurrentFile();
                continue;
            }
            if (!this.readChunkData(timestamp)) continue;
            return true;
        }
        return false;
    }

    private boolean readChunkData(long timestamp) throws IOException {
        while (this.seriesReader.hasNextChunk()) {
            Statistics statistics = this.seriesReader.currentChunkStatistics();
            if (!this.satisfyTimeFilter(statistics)) {
                this.seriesReader.skipCurrentChunk();
                continue;
            }
            if (!this.readPageData(timestamp)) continue;
            return true;
        }
        return false;
    }

    private boolean readPageData(long timestamp) throws IOException {
        while (this.seriesReader.hasNextPage()) {
            if (!this.seriesReader.isPageOverlapped() && !this.satisfyTimeFilter(this.seriesReader.currentPageStatistics())) {
                this.seriesReader.skipCurrentPage();
                continue;
            }
            this.batchData = this.seriesReader.nextPage();
            if (this.isEmpty(this.batchData) || !this.hasAvailableData(this.batchData, timestamp)) continue;
            return true;
        }
        return false;
    }

    private boolean satisfyTimeFilter(Statistics statistics) {
        return this.seriesReader.getTimeFilter().satisfy(statistics);
    }

    private boolean isEmpty(BatchData batchData) {
        return batchData == null || !batchData.hasCurrent();
    }

    private boolean hasAvailableData(BatchData data, long time) {
        return this.ascending ? data.getMaxTimestamp() >= time : data.getMinTimestamp() <= time;
    }
}

