/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.tsfile.exception.filter.StatisticsClassException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class AvgAggrResult
extends AggregateResult {
    private TSDataType seriesDataType;
    private double avg = 0.0;
    private long cnt = 0L;

    public AvgAggrResult(TSDataType seriesDataType) {
        super(TSDataType.DOUBLE, AggregationType.AVG);
        this.seriesDataType = seriesDataType;
        this.reset();
        this.avg = 0.0;
        this.cnt = 0L;
    }

    @Override
    protected boolean hasCandidateResult() {
        return this.cnt > 0L;
    }

    @Override
    public Double getResult() {
        if (this.cnt > 0L) {
            this.setDoubleValue(this.avg);
        }
        return this.hasCandidateResult() ? Double.valueOf(this.getDoubleValue()) : null;
    }

    @Override
    public void updateResultFromStatistics(Statistics statistics) {
        long preCnt = this.cnt;
        if (statistics.getType().equals((Object)TSDataType.BOOLEAN)) {
            throw new StatisticsClassException("Boolean statistics does not support: avg");
        }
        if (statistics.getType().equals((Object)TSDataType.TEXT)) {
            throw new StatisticsClassException("Binary statistics does not support: avg");
        }
        this.cnt += statistics.getCount();
        this.avg = this.avg * ((double)preCnt / (double)this.cnt) + (double)statistics.getCount() / (double)this.cnt * statistics.getSumValue() / (double)statistics.getCount();
    }

    @Override
    public void updateResultFromPageData(BatchData dataInThisPage) throws IOException {
        this.updateResultFromPageData(dataInThisPage, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    public void updateResultFromPageData(BatchData dataInThisPage, long minBound, long maxBound) throws IOException {
        while (dataInThisPage.hasCurrent() && dataInThisPage.currentTime() < maxBound && dataInThisPage.currentTime() >= minBound) {
            this.updateAvg(this.seriesDataType, dataInThisPage.currentValue());
            dataInThisPage.next();
        }
    }

    @Override
    public void updateResultUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        for (int i = 0; i < length; ++i) {
            Object value = dataReader.getValueInTimestamp(timestamps[i]);
            if (value == null) continue;
            this.updateAvg(this.seriesDataType, value);
        }
    }

    private void updateAvg(TSDataType type, Object sumVal) throws IOException {
        double val;
        switch (type) {
            case INT32: {
                val = ((Integer)sumVal).intValue();
                break;
            }
            case INT64: {
                val = ((Long)sumVal).longValue();
                break;
            }
            case FLOAT: {
                val = ((Float)sumVal).floatValue();
                break;
            }
            case DOUBLE: {
                val = (Double)sumVal;
                break;
            }
            default: {
                throw new IOException(String.format("Unsupported data type in aggregation AVG : %s", type));
            }
        }
        this.avg = this.avg * ((double)this.cnt / (double)(this.cnt + 1L)) + val * (1.0 / (double)(this.cnt + 1L));
        ++this.cnt;
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public void merge(AggregateResult another) {
        AvgAggrResult anotherAvg = (AvgAggrResult)another;
        if (anotherAvg.cnt == 0L) {
            return;
        }
        this.avg = this.avg * ((double)this.cnt / (double)(this.cnt + anotherAvg.cnt)) + anotherAvg.avg * ((double)anotherAvg.cnt / (double)(this.cnt + anotherAvg.cnt));
        this.cnt += anotherAvg.cnt;
    }

    @Override
    protected void deserializeSpecificFields(ByteBuffer buffer) {
        this.seriesDataType = TSDataType.deserialize((short)buffer.getShort());
        this.avg = buffer.getDouble();
        this.cnt = buffer.getLong();
    }

    @Override
    protected void serializeSpecificFields(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((TSDataType)this.seriesDataType, (OutputStream)outputStream);
        ReadWriteIOUtils.write((double)this.avg, (OutputStream)outputStream);
        ReadWriteIOUtils.write((long)this.cnt, (OutputStream)outputStream);
    }

    public long getCnt() {
        return this.cnt;
    }

    @Override
    public void reset() {
        super.reset();
        this.cnt = 0L;
        this.avg = 0.0;
    }
}

