/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.sql;

import java.io.File;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.runtime.SQLParserException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.constant.DatetimeUtils;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.DeleteDataOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.FromOperator;
import org.apache.iotdb.db.qp.logical.crud.InOperator;
import org.apache.iotdb.db.qp.logical.crud.InsertOperator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.logical.crud.SelectOperator;
import org.apache.iotdb.db.qp.logical.crud.UpdateOperator;
import org.apache.iotdb.db.qp.logical.sys.AlterTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.AuthorOperator;
import org.apache.iotdb.db.qp.logical.sys.ClearCacheOperator;
import org.apache.iotdb.db.qp.logical.sys.CountOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateSnapshotOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.DataAuthOperator;
import org.apache.iotdb.db.qp.logical.sys.DeletePartitionOperator;
import org.apache.iotdb.db.qp.logical.sys.DeleteStorageGroupOperator;
import org.apache.iotdb.db.qp.logical.sys.DeleteTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.FlushOperator;
import org.apache.iotdb.db.qp.logical.sys.LoadConfigurationOperator;
import org.apache.iotdb.db.qp.logical.sys.LoadDataOperator;
import org.apache.iotdb.db.qp.logical.sys.LoadFilesOperator;
import org.apache.iotdb.db.qp.logical.sys.MergeOperator;
import org.apache.iotdb.db.qp.logical.sys.MoveFileOperator;
import org.apache.iotdb.db.qp.logical.sys.RemoveFileOperator;
import org.apache.iotdb.db.qp.logical.sys.SetStorageGroupOperator;
import org.apache.iotdb.db.qp.logical.sys.SetTTLOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowChildPathsOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowDevicesOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowMergeStatusOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowStorageGroupOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowTTLOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.TracingOperator;
import org.apache.iotdb.db.qp.sql.SqlBaseBaseVisitor;
import org.apache.iotdb.db.qp.sql.SqlBaseParser;
import org.apache.iotdb.db.query.executor.fill.IFill;
import org.apache.iotdb.db.query.executor.fill.LinearFill;
import org.apache.iotdb.db.query.executor.fill.PreviousFill;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.StringContainer;

public class IoTDBSqlVisitor
extends SqlBaseBaseVisitor<Operator> {
    private static final String DELETE_RANGE_ERROR_MSG = "For delete statement, where clause can only contain atomic expressions like : time > XXX, time <= XXX, or two atomic expressions connected by 'AND'";
    private ZoneId zoneId;
    QueryOperator queryOp;

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public Operator visitSingleStatement(SqlBaseParser.SingleStatementContext ctx) {
        return (Operator)this.visit((ParseTree)ctx.statement());
    }

    public Operator visitCreateTimeseries(SqlBaseParser.CreateTimeseriesContext ctx) {
        CreateTimeSeriesOperator createTimeSeriesOperator = new CreateTimeSeriesOperator(51);
        createTimeSeriesOperator.setPath(this.parseFullPath(ctx.fullPath()));
        if (ctx.alias() != null) {
            createTimeSeriesOperator.setAlias(ctx.alias().ID().getText());
        }
        if (ctx.attributeClauses() != null) {
            this.parseAttributeClauses(ctx.attributeClauses(), createTimeSeriesOperator);
        }
        return createTimeSeriesOperator;
    }

    public Operator visitDeleteTimeseries(SqlBaseParser.DeleteTimeseriesContext ctx) {
        ArrayList<PartialPath> deletePaths = new ArrayList<PartialPath>();
        List prefixPaths = ctx.prefixPath();
        for (SqlBaseParser.PrefixPathContext prefixPath : prefixPaths) {
            deletePaths.add(this.parsePrefixPath(prefixPath));
        }
        DeleteTimeSeriesOperator deleteTimeSeriesOperator = new DeleteTimeSeriesOperator(52);
        deleteTimeSeriesOperator.setDeletePathList(deletePaths);
        return deleteTimeSeriesOperator;
    }

    public Operator visitAlterTimeseries(SqlBaseParser.AlterTimeseriesContext ctx) {
        AlterTimeSeriesOperator alterTimeSeriesOperator = new AlterTimeSeriesOperator(80);
        alterTimeSeriesOperator.setPath(this.parseFullPath(ctx.fullPath()));
        this.parseAlterClause(ctx.alterClause(), alterTimeSeriesOperator);
        return alterTimeSeriesOperator;
    }

    public Operator visitInsertStatement(SqlBaseParser.InsertStatementContext ctx) {
        InsertOperator insertOp = new InsertOperator(24);
        SelectOperator selectOp = new SelectOperator(21);
        selectOp.addSelectPath(this.parsePrefixPath(ctx.prefixPath()));
        insertOp.setSelectOperator(selectOp);
        this.parseInsertColumnSpec(ctx.insertColumnSpec(), insertOp);
        this.parseInsertValuesSpec(ctx.insertValuesSpec(), insertOp);
        return insertOp;
    }

    public Operator visitUpdateStatement(SqlBaseParser.UpdateStatementContext ctx) {
        UpdateOperator updateOp = new UpdateOperator(26);
        FromOperator fromOp = new FromOperator(22);
        fromOp.addPrefixTablePath(this.parsePrefixPath(ctx.prefixPath()));
        SelectOperator selectOp = new SelectOperator(27);
        for (SqlBaseParser.SetColContext colContext : ctx.setClause().setCol()) {
            this.parseSetCol(colContext, selectOp, updateOp);
        }
        FilterOperator whereOp = (FilterOperator)this.visit((ParseTree)ctx.whereClause());
        updateOp.setFilterOperator(whereOp.getChildren().get(0));
        updateOp.setSelectOperator(selectOp);
        return updateOp;
    }

    public Operator visitDeleteStatement(SqlBaseParser.DeleteStatementContext ctx) {
        DeleteDataOperator deleteDataOp = new DeleteDataOperator(25);
        SelectOperator selectOp = new SelectOperator(21);
        List prefixPaths = ctx.prefixPath();
        for (SqlBaseParser.PrefixPathContext prefixPath : prefixPaths) {
            PartialPath path = this.parsePrefixPath(prefixPath);
            selectOp.addSelectPath(path);
        }
        deleteDataOp.setSelectOperator(selectOp);
        if (ctx.whereClause() != null) {
            FilterOperator whereOp = (FilterOperator)this.visit((ParseTree)ctx.whereClause());
            deleteDataOp.setFilterOperator(whereOp.getChildren().get(0));
            Pair<Long, Long> timeInterval = this.parseDeleteTimeInterval(deleteDataOp);
            deleteDataOp.setStartTime((Long)timeInterval.left);
            deleteDataOp.setEndTime((Long)timeInterval.right);
        } else {
            deleteDataOp.setStartTime(Long.MIN_VALUE);
            deleteDataOp.setEndTime(Long.MAX_VALUE);
        }
        return deleteDataOp;
    }

    public Operator visitSetStorageGroup(SqlBaseParser.SetStorageGroupContext ctx) {
        SetStorageGroupOperator setStorageGroupOperator = new SetStorageGroupOperator(53);
        PartialPath path = this.parsePrefixPath(ctx.prefixPath());
        setStorageGroupOperator.setPath(path);
        return setStorageGroupOperator;
    }

    public Operator visitDeleteStorageGroup(SqlBaseParser.DeleteStorageGroupContext ctx) {
        ArrayList<PartialPath> deletePaths = new ArrayList<PartialPath>();
        List prefixPaths = ctx.prefixPath();
        for (SqlBaseParser.PrefixPathContext prefixPath : prefixPaths) {
            deletePaths.add(this.parsePrefixPath(prefixPath));
        }
        DeleteStorageGroupOperator deleteStorageGroupOperator = new DeleteStorageGroupOperator(62);
        deleteStorageGroupOperator.setDeletePathList(deletePaths);
        return deleteStorageGroupOperator;
    }

    public Operator visitMerge(SqlBaseParser.MergeContext ctx) {
        return new MergeOperator(82);
    }

    public Operator visitFlush(SqlBaseParser.FlushContext ctx) {
        FlushOperator flushOperator = new FlushOperator(81);
        if (ctx.booleanClause() != null) {
            flushOperator.setSeq(Boolean.parseBoolean(ctx.booleanClause().getText()));
        }
        if (ctx.prefixPath(0) != null) {
            ArrayList<PartialPath> storageGroups = new ArrayList<PartialPath>();
            for (SqlBaseParser.PrefixPathContext prefixPathContext : ctx.prefixPath()) {
                storageGroups.add(this.parsePrefixPath(prefixPathContext));
            }
            flushOperator.setStorageGroupList(storageGroups);
        }
        return flushOperator;
    }

    public Operator visitFullMerge(SqlBaseParser.FullMergeContext ctx) {
        return new MergeOperator(83);
    }

    public Operator visitClearcache(SqlBaseParser.ClearcacheContext ctx) {
        return new ClearCacheOperator(84);
    }

    public Operator visitCreateUser(SqlBaseParser.CreateUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(41, AuthorOperator.AuthorType.CREATE_USER);
        authorOperator.setUserName(ctx.ID().getText());
        authorOperator.setPassWord(this.removeStringQuote(ctx.password.getText()));
        return authorOperator;
    }

    public Operator visitAlterUser(SqlBaseParser.AlterUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(46, AuthorOperator.AuthorType.UPDATE_USER);
        if (ctx.ID() != null) {
            authorOperator.setUserName(ctx.ID().getText());
        } else {
            authorOperator.setUserName(ctx.ROOT().getText());
        }
        authorOperator.setNewPassword(this.removeStringQuote(ctx.password.getText()));
        return authorOperator;
    }

    public Operator visitDropUser(SqlBaseParser.DropUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(42, AuthorOperator.AuthorType.DROP_USER);
        authorOperator.setUserName(ctx.ID().getText());
        return authorOperator;
    }

    public Operator visitCreateRole(SqlBaseParser.CreateRoleContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(41, AuthorOperator.AuthorType.CREATE_ROLE);
        authorOperator.setRoleName(ctx.ID().getText());
        return authorOperator;
    }

    public Operator visitDropRole(SqlBaseParser.DropRoleContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(42, AuthorOperator.AuthorType.DROP_ROLE);
        authorOperator.setRoleName(ctx.ID().getText());
        return authorOperator;
    }

    public Operator visitGrantUser(SqlBaseParser.GrantUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.GRANT_USER);
        authorOperator.setUserName(ctx.ID().getText());
        authorOperator.setPrivilegeList(this.parsePrivilege(ctx.privileges()));
        authorOperator.setNodeNameList(this.parsePrefixPath(ctx.prefixPath()));
        return authorOperator;
    }

    public Operator visitGrantRole(SqlBaseParser.GrantRoleContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.GRANT_ROLE);
        authorOperator.setRoleName(ctx.ID().getText());
        authorOperator.setPrivilegeList(this.parsePrivilege(ctx.privileges()));
        authorOperator.setNodeNameList(this.parsePrefixPath(ctx.prefixPath()));
        return authorOperator;
    }

    public Operator visitRevokeUser(SqlBaseParser.RevokeUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.REVOKE_USER);
        authorOperator.setUserName(ctx.ID().getText());
        authorOperator.setPrivilegeList(this.parsePrivilege(ctx.privileges()));
        authorOperator.setNodeNameList(this.parsePrefixPath(ctx.prefixPath()));
        return authorOperator;
    }

    public Operator visitRevokeRole(SqlBaseParser.RevokeRoleContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.REVOKE_ROLE);
        authorOperator.setRoleName(ctx.ID().getText());
        authorOperator.setPrivilegeList(this.parsePrivilege(ctx.privileges()));
        authorOperator.setNodeNameList(this.parsePrefixPath(ctx.prefixPath()));
        return authorOperator;
    }

    public Operator visitGrantRoleToUser(SqlBaseParser.GrantRoleToUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.GRANT_ROLE_TO_USER);
        authorOperator.setRoleName(ctx.roleName.getText());
        authorOperator.setUserName(ctx.userName.getText());
        return authorOperator;
    }

    public Operator visitRevokeRoleFromUser(SqlBaseParser.RevokeRoleFromUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.REVOKE_ROLE_FROM_USER);
        authorOperator.setRoleName(ctx.roleName.getText());
        authorOperator.setUserName(ctx.userName.getText());
        return authorOperator;
    }

    public Operator visitLoadStatement(SqlBaseParser.LoadStatementContext ctx) {
        if (ctx.prefixPath().nodeName().size() < 3) {
            throw new SQLParserException("data load command: child count < 3\n");
        }
        String csvPath = ctx.stringLiteral().getText();
        StringContainer sc = new StringContainer(".");
        List nodeNames = ctx.prefixPath().nodeName();
        sc.addTail(new String[]{ctx.prefixPath().ROOT().getText()});
        for (SqlBaseParser.NodeNameContext nodeName : nodeNames) {
            sc.addTail(new String[]{nodeName.getText()});
        }
        return new LoadDataOperator(45, this.removeStringQuote(csvPath), sc.toString());
    }

    public Operator visitGrantWatermarkEmbedding(SqlBaseParser.GrantWatermarkEmbeddingContext ctx) {
        List rootOrIdList = ctx.rootOrId();
        ArrayList<String> users = new ArrayList<String>();
        for (SqlBaseParser.RootOrIdContext rootOrId : rootOrIdList) {
            users.add(rootOrId.getText());
        }
        return new DataAuthOperator(34, users);
    }

    public Operator visitRevokeWatermarkEmbedding(SqlBaseParser.RevokeWatermarkEmbeddingContext ctx) {
        List rootOrIdList = ctx.rootOrId();
        ArrayList<String> users = new ArrayList<String>();
        for (SqlBaseParser.RootOrIdContext rootOrId : rootOrIdList) {
            users.add(rootOrId.getText());
        }
        return new DataAuthOperator(35, users);
    }

    public Operator visitListUser(SqlBaseParser.ListUserContext ctx) {
        return new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER);
    }

    public Operator visitListRole(SqlBaseParser.ListRoleContext ctx) {
        return new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE);
    }

    public Operator visitListPrivilegesUser(SqlBaseParser.ListPrivilegesUserContext ctx) {
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER_PRIVILEGE);
        operator.setUserName(ctx.rootOrId().getText());
        operator.setNodeNameList(this.parsePrefixPath(ctx.prefixPath()));
        return operator;
    }

    public Operator visitListPrivilegesRole(SqlBaseParser.ListPrivilegesRoleContext ctx) {
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE_PRIVILEGE);
        operator.setRoleName(ctx.ID().getText());
        operator.setNodeNameList(this.parsePrefixPath(ctx.prefixPath()));
        return operator;
    }

    public Operator visitListUserPrivileges(SqlBaseParser.ListUserPrivilegesContext ctx) {
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER_PRIVILEGE);
        operator.setUserName(ctx.rootOrId().getText());
        return operator;
    }

    public Operator visitListRolePrivileges(SqlBaseParser.ListRolePrivilegesContext ctx) {
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE_PRIVILEGE);
        operator.setRoleName(ctx.ID().getText());
        return operator;
    }

    public Operator visitListAllRoleOfUser(SqlBaseParser.ListAllRoleOfUserContext ctx) {
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER_ROLES);
        operator.setUserName(ctx.rootOrId().getText());
        return operator;
    }

    public Operator visitListAllUserOfRole(SqlBaseParser.ListAllUserOfRoleContext ctx) {
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE_USERS);
        operator.setRoleName(ctx.ID().getText());
        return operator;
    }

    public Operator visitSetTTLStatement(SqlBaseParser.SetTTLStatementContext ctx) {
        SetTTLOperator operator = new SetTTLOperator(63);
        operator.setStorageGroup(this.parsePrefixPath(ctx.prefixPath()));
        operator.setDataTTL(Long.parseLong(ctx.INT().getText()));
        return operator;
    }

    public Operator visitUnsetTTLStatement(SqlBaseParser.UnsetTTLStatementContext ctx) {
        SetTTLOperator operator = new SetTTLOperator(64);
        operator.setStorageGroup(this.parsePrefixPath(ctx.prefixPath()));
        return operator;
    }

    public Operator visitShowTTLStatement(SqlBaseParser.ShowTTLStatementContext ctx) {
        ArrayList<PartialPath> storageGroups = new ArrayList<PartialPath>();
        List prefixPathList = ctx.prefixPath();
        for (SqlBaseParser.PrefixPathContext prefixPath : prefixPathList) {
            storageGroups.add(this.parsePrefixPath(prefixPath));
        }
        return new ShowTTLOperator(storageGroups);
    }

    public Operator visitShowAllTTLStatement(SqlBaseParser.ShowAllTTLStatementContext ctx) {
        ArrayList<PartialPath> storageGroups = new ArrayList<PartialPath>();
        return new ShowTTLOperator(storageGroups);
    }

    public Operator visitShowFlushTaskInfo(SqlBaseParser.ShowFlushTaskInfoContext ctx) {
        return new ShowOperator(67);
    }

    public Operator visitShowVersion(SqlBaseParser.ShowVersionContext ctx) {
        return new ShowOperator(72);
    }

    public Operator visitShowTimeseries(SqlBaseParser.ShowTimeseriesContext ctx) {
        boolean orderByHeat = ctx.LATEST() != null;
        ShowTimeSeriesOperator showTimeSeriesOperator = ctx.prefixPath() != null ? new ShowTimeSeriesOperator(73, this.parsePrefixPath(ctx.prefixPath()), orderByHeat) : new ShowTimeSeriesOperator(73, new PartialPath(SQLConstant.getSingleRootArray()), orderByHeat);
        if (ctx.showWhereClause() != null) {
            this.parseShowWhereClause(ctx.showWhereClause(), showTimeSeriesOperator);
        }
        if (ctx.limitClause() != null) {
            this.parseLimitClause(ctx.limitClause(), showTimeSeriesOperator);
        }
        return showTimeSeriesOperator;
    }

    public Operator visitShowStorageGroup(SqlBaseParser.ShowStorageGroupContext ctx) {
        if (ctx.prefixPath() != null) {
            return new ShowStorageGroupOperator(74, this.parsePrefixPath(ctx.prefixPath()));
        }
        return new ShowStorageGroupOperator(74, new PartialPath(SQLConstant.getSingleRootArray()));
    }

    public Operator visitShowChildPaths(SqlBaseParser.ShowChildPathsContext ctx) {
        if (ctx.prefixPath() != null) {
            return new ShowChildPathsOperator(75, this.parsePrefixPath(ctx.prefixPath()));
        }
        return new ShowChildPathsOperator(75, new PartialPath(SQLConstant.getSingleRootArray()));
    }

    public Operator visitShowDevices(SqlBaseParser.ShowDevicesContext ctx) {
        if (ctx.prefixPath() != null) {
            return new ShowDevicesOperator(76, this.parsePrefixPath(ctx.prefixPath()));
        }
        return new ShowDevicesOperator(76, new PartialPath(SQLConstant.getSingleRootArray()));
    }

    public Operator visitShowMergeStatus(SqlBaseParser.ShowMergeStatusContext ctx) {
        return new ShowMergeStatusOperator(87);
    }

    public Operator visitTracingOn(SqlBaseParser.TracingOnContext ctx) {
        return new TracingOperator(91, true);
    }

    public Operator visitTracingOff(SqlBaseParser.TracingOffContext ctx) {
        return new TracingOperator(91, false);
    }

    public Operator visitCountTimeseries(SqlBaseParser.CountTimeseriesContext ctx) {
        PartialPath path;
        SqlBaseParser.PrefixPathContext pathContext = ctx.prefixPath();
        PartialPath partialPath = path = pathContext != null ? this.parsePrefixPath(pathContext) : new PartialPath(SQLConstant.getSingleRootArray());
        if (ctx.INT() != null) {
            return new CountOperator(78, path, Integer.parseInt(ctx.INT().getText()));
        }
        return new CountOperator(77, path);
    }

    public Operator visitCountDevices(SqlBaseParser.CountDevicesContext ctx) {
        SqlBaseParser.PrefixPathContext pathContext = ctx.prefixPath();
        PartialPath path = pathContext != null ? this.parsePrefixPath(pathContext) : new PartialPath(SQLConstant.getSingleRootArray());
        return new CountOperator(92, path);
    }

    public Operator visitCountStorageGroup(SqlBaseParser.CountStorageGroupContext ctx) {
        SqlBaseParser.PrefixPathContext pathContext = ctx.prefixPath();
        PartialPath path = pathContext != null ? this.parsePrefixPath(pathContext) : new PartialPath(SQLConstant.getSingleRootArray());
        return new CountOperator(93, path);
    }

    public Operator visitCountNodes(SqlBaseParser.CountNodesContext ctx) {
        return new CountOperator(79, this.parsePrefixPath(ctx.prefixPath()), Integer.parseInt(ctx.INT().getText()));
    }

    public Operator visitLoadConfigurationStatement(SqlBaseParser.LoadConfigurationStatementContext ctx) {
        if (ctx.GLOBAL() != null) {
            return new LoadConfigurationOperator(LoadConfigurationOperator.LoadConfigurationOperatorType.GLOBAL);
        }
        return new LoadConfigurationOperator(LoadConfigurationOperator.LoadConfigurationOperatorType.LOCAL);
    }

    public Operator visitLoadFiles(SqlBaseParser.LoadFilesContext ctx) {
        if (ctx.autoCreateSchema() != null) {
            if (ctx.autoCreateSchema().INT() != null) {
                return new LoadFilesOperator(new File(this.removeStringQuote(ctx.stringLiteral().getText())), Boolean.parseBoolean(ctx.autoCreateSchema().booleanClause().getText()), Integer.parseInt(ctx.autoCreateSchema().INT().getText()));
            }
            return new LoadFilesOperator(new File(this.removeStringQuote(ctx.stringLiteral().getText())), Boolean.parseBoolean(ctx.autoCreateSchema().booleanClause().getText()), IoTDBDescriptor.getInstance().getConfig().getDefaultStorageGroupLevel());
        }
        return new LoadFilesOperator(new File(this.removeStringQuote(ctx.stringLiteral().getText())), true, IoTDBDescriptor.getInstance().getConfig().getDefaultStorageGroupLevel());
    }

    public Operator visitRemoveFile(SqlBaseParser.RemoveFileContext ctx) {
        return new RemoveFileOperator(new File(this.removeStringQuote(ctx.stringLiteral().getText())));
    }

    public Operator visitMoveFile(SqlBaseParser.MoveFileContext ctx) {
        return new MoveFileOperator(new File(this.removeStringQuote(ctx.stringLiteral(0).getText())), new File(this.removeStringQuote(ctx.stringLiteral(1).getText())));
    }

    public Operator visitDeletePartition(SqlBaseParser.DeletePartitionContext ctx) {
        DeletePartitionOperator deletePartitionOperator = new DeletePartitionOperator(88);
        deletePartitionOperator.setStorageGroupName(this.parsePrefixPath(ctx.prefixPath()));
        HashSet<Long> idSet = new HashSet<Long>();
        for (TerminalNode terminalNode : ctx.INT()) {
            idSet.add(Long.parseLong(terminalNode.getText()));
        }
        deletePartitionOperator.setPartitionIds(idSet);
        return deletePartitionOperator;
    }

    public Operator visitCreateSnapshot(SqlBaseParser.CreateSnapshotContext ctx) {
        return new CreateSnapshotOperator(89);
    }

    public Operator visitSelectStatement(SqlBaseParser.SelectStatementContext ctx) {
        this.queryOp = new QueryOperator(27);
        SelectOperator selectOp = (SelectOperator)this.visit((ParseTree)ctx.selectElements());
        this.queryOp.setSelectOperator(selectOp);
        FromOperator fromOp = (FromOperator)this.visit((ParseTree)ctx.fromClause());
        this.queryOp.setFromOperator(fromOp);
        if (ctx.whereClause() != null) {
            FilterOperator whereOp = (FilterOperator)this.visit((ParseTree)ctx.whereClause());
            this.queryOp.setFilterOperator(whereOp.getChildren().get(0));
        }
        if (ctx.specialClause() != null) {
            this.visit((ParseTree)ctx.specialClause());
        }
        return this.queryOp;
    }

    public Operator visitFunctionElement(SqlBaseParser.FunctionElementContext ctx) {
        SelectOperator selectOp = new SelectOperator(21);
        List functionCallContextList = ctx.functionCall();
        for (SqlBaseParser.FunctionCallContext functionCallContext : functionCallContextList) {
            PartialPath path = this.parseSuffixPath(functionCallContext.suffixPath());
            selectOp.addClusterPath(path, functionCallContext.functionName().getText());
        }
        return selectOp;
    }

    public Operator visitLastElement(SqlBaseParser.LastElementContext ctx) {
        SelectOperator selectOp = new SelectOperator(21);
        selectOp.setLastQuery();
        SqlBaseParser.LastClauseContext lastClauseContext = ctx.lastClause();
        if (lastClauseContext.asClause().size() != 0) {
            this.parseAsClause(lastClauseContext.asClause(), selectOp);
        } else {
            List suffixPaths = lastClauseContext.suffixPath();
            for (SqlBaseParser.SuffixPathContext suffixPath : suffixPaths) {
                PartialPath path = this.parseSuffixPath(suffixPath);
                selectOp.addSelectPath(path);
            }
        }
        return selectOp;
    }

    public Operator visitAsElement(SqlBaseParser.AsElementContext ctx) {
        SelectOperator selectOp = new SelectOperator(21);
        this.parseAsClause(ctx.asClause(), selectOp);
        return selectOp;
    }

    public Operator visitFunctionAsElement(SqlBaseParser.FunctionAsElementContext ctx) {
        SelectOperator selectOp = new SelectOperator(21);
        List functionAsClauseContexts = ctx.functionAsClause();
        for (SqlBaseParser.FunctionAsClauseContext functionAsClauseContext : functionAsClauseContexts) {
            SqlBaseParser.FunctionCallContext functionCallContext = functionAsClauseContext.functionCall();
            PartialPath path = this.parseSuffixPath(functionCallContext.suffixPath());
            if (functionAsClauseContext.ID() != null) {
                path.setTsAlias(functionAsClauseContext.ID().toString());
            }
            selectOp.addClusterPath(path, functionCallContext.functionName().getText());
        }
        return selectOp;
    }

    public void parseAsClause(List<SqlBaseParser.AsClauseContext> asClauseContexts, SelectOperator selectOp) {
        for (SqlBaseParser.AsClauseContext asClauseContext : asClauseContexts) {
            PartialPath path = this.parseSuffixPath(asClauseContext.suffixPath());
            if (asClauseContext.ID() != null) {
                path.setTsAlias(asClauseContext.ID().toString());
            }
            selectOp.addSelectPath(path);
        }
    }

    public Operator visitSpecialLimitStatement(SqlBaseParser.SpecialLimitStatementContext ctx) {
        return (Operator)this.visit((ParseTree)ctx.specialLimit());
    }

    public Operator visitLimitStatement(SqlBaseParser.LimitStatementContext ctx) {
        this.parseLimitClause(ctx.limitClause(), this.queryOp);
        if (ctx.slimitClause() != null) {
            this.parseSlimitClause(ctx.slimitClause(), this.queryOp);
        }
        if (ctx.alignByDeviceClauseOrDisableAlign() != null) {
            if (ctx.alignByDeviceClauseOrDisableAlign().alignByDeviceClause() != null) {
                this.parseAlignByDeviceClause(this.queryOp);
            } else {
                this.parseDisableAlign(this.queryOp);
            }
        }
        return this.queryOp;
    }

    public Operator visitSlimitStatement(SqlBaseParser.SlimitStatementContext ctx) {
        this.parseSlimitClause(ctx.slimitClause(), this.queryOp);
        if (ctx.limitClause() != null) {
            this.parseLimitClause(ctx.limitClause(), this.queryOp);
        }
        if (ctx.alignByDeviceClauseOrDisableAlign() != null) {
            if (ctx.alignByDeviceClauseOrDisableAlign().alignByDeviceClause() != null) {
                this.parseAlignByDeviceClause(this.queryOp);
            } else {
                this.parseDisableAlign(this.queryOp);
            }
        }
        return this.queryOp;
    }

    public Operator visitAlignByDeviceClauseOrDisableAlignInSpecialLimit(SqlBaseParser.AlignByDeviceClauseOrDisableAlignInSpecialLimitContext ctx) {
        if (ctx.alignByDeviceClauseOrDisableAlign().alignByDeviceClause() != null) {
            this.parseAlignByDeviceClause(this.queryOp);
        } else {
            this.parseDisableAlign(this.queryOp);
        }
        return this.queryOp;
    }

    public Operator visitOrderByTimeStatement(SqlBaseParser.OrderByTimeStatementContext ctx) {
        this.parseOrderByTimeClause(ctx.orderByTimeClause(), this.queryOp);
        if (ctx.specialLimit() != null) {
            return (Operator)this.visit((ParseTree)ctx.specialLimit());
        }
        return this.queryOp;
    }

    public Operator visitGroupByTimeStatement(SqlBaseParser.GroupByTimeStatementContext ctx) {
        this.parseGroupByTimeClause(ctx.groupByTimeClause(), this.queryOp);
        if (ctx.orderByTimeClause() != null) {
            this.parseOrderByTimeClause(ctx.orderByTimeClause(), this.queryOp);
        }
        if (ctx.specialLimit() != null) {
            return (Operator)this.visit((ParseTree)ctx.specialLimit());
        }
        return this.queryOp;
    }

    public Operator visitGroupByFillStatement(SqlBaseParser.GroupByFillStatementContext ctx) {
        this.parseGroupByFillClause(ctx.groupByFillClause(), this.queryOp);
        if (ctx.orderByTimeClause() != null) {
            this.parseOrderByTimeClause(ctx.orderByTimeClause(), this.queryOp);
        }
        if (ctx.specialLimit() != null) {
            return (Operator)this.visit((ParseTree)ctx.specialLimit());
        }
        return this.queryOp;
    }

    public Operator visitFillStatement(SqlBaseParser.FillStatementContext ctx) {
        this.parseFillClause(ctx.fillClause(), this.queryOp);
        if (ctx.slimitClause() != null) {
            this.parseSlimitClause(ctx.slimitClause(), this.queryOp);
        }
        if (ctx.alignByDeviceClauseOrDisableAlign() != null) {
            if (ctx.alignByDeviceClauseOrDisableAlign().alignByDeviceClause() != null) {
                this.parseAlignByDeviceClause(this.queryOp);
            } else {
                this.parseDisableAlign(this.queryOp);
            }
        }
        return this.queryOp;
    }

    public Operator visitAlignByDeviceStatementOrDisableAlignInSpecialClause(SqlBaseParser.AlignByDeviceStatementOrDisableAlignInSpecialClauseContext ctx) {
        if (ctx.alignByDeviceClauseOrDisableAlign() != null) {
            if (ctx.alignByDeviceClauseOrDisableAlign().alignByDeviceClause() != null) {
                this.parseAlignByDeviceClause(this.queryOp);
            } else {
                this.parseDisableAlign(this.queryOp);
            }
        }
        return this.queryOp;
    }

    public Operator visitGroupByLevelStatement(SqlBaseParser.GroupByLevelStatementContext ctx) {
        this.parseGroupByLevelClause(ctx.groupByLevelClause(), this.queryOp);
        if (ctx.orderByTimeClause() != null) {
            this.parseOrderByTimeClause(ctx.orderByTimeClause(), this.queryOp);
        }
        if (ctx.specialLimit() != null) {
            return (Operator)this.visit((ParseTree)ctx.specialLimit());
        }
        return this.queryOp;
    }

    public Operator visitSelectElement(SqlBaseParser.SelectElementContext ctx) {
        SelectOperator selectOp = new SelectOperator(21);
        List suffixPathOrConstants = ctx.suffixPathOrConstant();
        for (SqlBaseParser.SuffixPathOrConstantContext suffixPathOrConstant : suffixPathOrConstants) {
            PartialPath path;
            if (suffixPathOrConstant.suffixPath() != null) {
                path = this.parseSuffixPath(suffixPathOrConstant.suffixPath());
                selectOp.addSelectPath(path);
                continue;
            }
            path = new PartialPath(new String[]{suffixPathOrConstant.SINGLE_QUOTE_STRING_LITERAL().getText()});
            selectOp.addSelectPath(path);
        }
        return selectOp;
    }

    public Operator visitFromClause(SqlBaseParser.FromClauseContext ctx) {
        FromOperator fromOp = new FromOperator(22);
        List prefixFromPaths = ctx.prefixPath();
        for (SqlBaseParser.PrefixPathContext prefixFromPath : prefixFromPaths) {
            PartialPath path = this.parsePrefixPath(prefixFromPath);
            fromOp.addPrefixTablePath(path);
        }
        return fromOp;
    }

    public void parseGroupByLevelClause(SqlBaseParser.GroupByLevelClauseContext ctx, QueryOperator queryOp) {
        queryOp.setGroupByLevel(true);
        queryOp.setLevel(Integer.parseInt(ctx.INT().getText()));
    }

    public void parseFillClause(SqlBaseParser.FillClauseContext ctx, QueryOperator queryOp) {
        FilterOperator filterOperator = queryOp.getFilterOperator();
        if (!filterOperator.isLeaf() || filterOperator.getTokenIntType() != 131) {
            throw new SQLParserException("Only \"=\" can be used in fill function");
        }
        List list = ctx.typeClause();
        EnumMap<TSDataType, IFill> fillTypes = new EnumMap<TSDataType, IFill>(TSDataType.class);
        for (SqlBaseParser.TypeClauseContext typeClause : list) {
            this.parseTypeClause(typeClause, fillTypes);
        }
        queryOp.setFill(true);
        queryOp.setFillTypes(fillTypes);
    }

    private void parseLimitClause(SqlBaseParser.LimitClauseContext ctx, Operator operator) {
        int limit;
        try {
            limit = Integer.parseInt(ctx.INT().getText());
        }
        catch (NumberFormatException e) {
            throw new SQLParserException("Out of range. LIMIT <N>: N should be Int32.");
        }
        if (limit <= 0) {
            throw new SQLParserException("LIMIT <N>: N should be greater than 0.");
        }
        if (operator instanceof ShowTimeSeriesOperator) {
            ((ShowTimeSeriesOperator)operator).setLimit(limit);
        } else {
            ((QueryOperator)operator).setRowLimit(limit);
        }
        if (ctx.offsetClause() != null) {
            this.parseOffsetClause(ctx.offsetClause(), operator);
        }
    }

    private void parseOffsetClause(SqlBaseParser.OffsetClauseContext ctx, Operator operator) {
        int offset;
        try {
            offset = Integer.parseInt(ctx.INT().getText());
        }
        catch (NumberFormatException e) {
            throw new SQLParserException("Out of range. OFFSET <OFFSETValue>: OFFSETValue should be Int32.");
        }
        if (offset < 0) {
            throw new SQLParserException("OFFSET <OFFSETValue>: OFFSETValue should >= 0.");
        }
        if (operator instanceof ShowTimeSeriesOperator) {
            ((ShowTimeSeriesOperator)operator).setOffset(offset);
        } else {
            ((QueryOperator)operator).setRowOffset(offset);
        }
    }

    private void parseSlimitClause(SqlBaseParser.SlimitClauseContext ctx, QueryOperator queryOp) {
        int slimit;
        try {
            slimit = Integer.parseInt(ctx.INT().getText());
        }
        catch (NumberFormatException e) {
            throw new SQLParserException("Out of range. SLIMIT <SN>: SN should be Int32.");
        }
        if (slimit <= 0) {
            throw new SQLParserException("SLIMIT <SN>: SN should be greater than 0.");
        }
        queryOp.setSeriesLimit(slimit);
        if (ctx.soffsetClause() != null) {
            this.parseSoffsetClause(ctx.soffsetClause(), queryOp);
        }
    }

    public void parseSoffsetClause(SqlBaseParser.SoffsetClauseContext ctx, QueryOperator queryOp) {
        int soffset;
        try {
            soffset = Integer.parseInt(ctx.INT().getText());
        }
        catch (NumberFormatException e) {
            throw new SQLParserException("Out of range. SOFFSET <SOFFSETValue>: SOFFSETValue should be Int32.");
        }
        if (soffset < 0) {
            throw new SQLParserException("SOFFSET <SOFFSETValue>: SOFFSETValue should >= 0.");
        }
        queryOp.setSeriesOffset(soffset);
    }

    private void parseGroupByTimeClause(SqlBaseParser.GroupByTimeClauseContext ctx, QueryOperator queryOp) {
        queryOp.setGroupByTime(true);
        queryOp.setLeftCRightO(ctx.timeInterval().LS_BRACKET() != null);
        queryOp.setUnit(this.parseDuration(ctx.DURATION(0).getText()));
        queryOp.setSlidingStep(queryOp.getUnit());
        if (ctx.DURATION().size() == 2) {
            queryOp.setSlidingStep(this.parseDuration(ctx.DURATION(1).getText()));
            if (queryOp.getSlidingStep() < queryOp.getUnit()) {
                throw new SQLParserException("The third parameter sliding step shouldn't be smaller than the second parameter time interval.");
            }
        }
        this.parseTimeInterval(ctx.timeInterval(), queryOp);
        if (ctx.INT() != null) {
            queryOp.setLevel(Integer.parseInt(ctx.INT().getText()));
        }
    }

    private void parseGroupByFillClause(SqlBaseParser.GroupByFillClauseContext ctx, QueryOperator queryOp) {
        queryOp.setGroupByTime(true);
        queryOp.setFill(true);
        queryOp.setLeftCRightO(ctx.timeInterval().LS_BRACKET() != null);
        queryOp.setUnit(this.parseDuration(ctx.DURATION().getText()));
        queryOp.setSlidingStep(queryOp.getUnit());
        this.parseTimeInterval(ctx.timeInterval(), queryOp);
        List list = ctx.typeClause();
        EnumMap<TSDataType, IFill> fillTypes = new EnumMap<TSDataType, IFill>(TSDataType.class);
        for (SqlBaseParser.TypeClauseContext typeClause : list) {
            if (typeClause.linearClause() != null) {
                throw new SQLParserException("group by fill doesn't support linear fill");
            }
            if ("all".equalsIgnoreCase(typeClause.dataType().getText())) {
                PreviousFill fill;
                long preRange;
                if (typeClause.previousUntilLastClause() != null) {
                    preRange = typeClause.previousUntilLastClause().DURATION() != null ? this.parseDuration(typeClause.previousUntilLastClause().DURATION().getText()) : (long)IoTDBDescriptor.getInstance().getConfig().getDefaultFillInterval();
                    fill = new PreviousFill(preRange, true);
                } else {
                    preRange = typeClause.previousClause().DURATION() != null ? this.parseDuration(typeClause.previousClause().DURATION().getText()) : (long)IoTDBDescriptor.getInstance().getConfig().getDefaultFillInterval();
                    fill = new PreviousFill(preRange);
                }
                for (TSDataType tsDataType : TSDataType.values()) {
                    fillTypes.put(tsDataType, ((IFill)fill).copy());
                }
                break;
            }
            this.parseTypeClause(typeClause, fillTypes);
        }
        queryOp.setFill(true);
        queryOp.setFillTypes(fillTypes);
    }

    private void parseTypeClause(SqlBaseParser.TypeClauseContext ctx, Map<TSDataType, IFill> fillTypes) {
        TSDataType dataType = this.parseType(ctx.dataType().getText());
        if (ctx.linearClause() != null && dataType == TSDataType.TEXT) {
            throw new SQLParserException(String.format("type %s cannot use %s fill function", dataType, ctx.linearClause().LINEAR().getText()));
        }
        int defaultFillInterval = IoTDBDescriptor.getInstance().getConfig().getDefaultFillInterval();
        if (ctx.linearClause() != null) {
            if (ctx.linearClause().DURATION(0) != null) {
                long beforeRange = this.parseDuration(ctx.linearClause().DURATION(0).getText());
                long afterRange = this.parseDuration(ctx.linearClause().DURATION(1).getText());
                fillTypes.put(dataType, new LinearFill(beforeRange, afterRange));
            } else {
                fillTypes.put(dataType, new LinearFill(defaultFillInterval, (long)defaultFillInterval));
            }
        } else if (ctx.previousClause() != null) {
            if (ctx.previousClause().DURATION() != null) {
                long preRange = this.parseDuration(ctx.previousClause().DURATION().getText());
                fillTypes.put(dataType, new PreviousFill(preRange));
            } else {
                fillTypes.put(dataType, new PreviousFill(defaultFillInterval));
            }
        } else if (ctx.previousUntilLastClause().DURATION() != null) {
            long preRange = this.parseDuration(ctx.previousUntilLastClause().DURATION().getText());
            fillTypes.put(dataType, new PreviousFill(preRange, true));
        } else {
            fillTypes.put(dataType, new PreviousFill(defaultFillInterval, true));
        }
    }

    private TSDataType parseType(String datatype) {
        String type;
        switch (type = datatype.toLowerCase()) {
            case "int32": {
                return TSDataType.INT32;
            }
            case "int64": {
                return TSDataType.INT64;
            }
            case "float": {
                return TSDataType.FLOAT;
            }
            case "double": {
                return TSDataType.DOUBLE;
            }
            case "boolean": {
                return TSDataType.BOOLEAN;
            }
            case "text": {
                return TSDataType.TEXT;
            }
        }
        throw new SQLParserException("not a valid fill type : " + type);
    }

    private void parseOrderByTimeClause(SqlBaseParser.OrderByTimeClauseContext ctx, QueryOperator queryOp) {
        queryOp.setColumn(ctx.TIME().getText());
        if (ctx.DESC() != null) {
            queryOp.setAscending(false);
        }
    }

    private void parseAlignByDeviceClause(QueryOperator queryOp) {
        queryOp.setAlignByDevice(true);
    }

    private void parseDisableAlign(QueryOperator queryOp) {
        queryOp.setAlignByTime(false);
    }

    private void parseTimeInterval(SqlBaseParser.TimeIntervalContext timeInterval, QueryOperator queryOp) {
        long startTime = timeInterval.timeValue(0).INT() != null ? Long.parseLong(timeInterval.timeValue(0).INT().getText()) : (timeInterval.timeValue(0).dateExpression() != null ? this.parseDateExpression(timeInterval.timeValue(0).dateExpression()).longValue() : this.parseTimeFormat(timeInterval.timeValue(0).dateFormat().getText()));
        long endTime = timeInterval.timeValue(1).INT() != null ? Long.parseLong(timeInterval.timeValue(1).INT().getText()) : (timeInterval.timeValue(1).dateExpression() != null ? this.parseDateExpression(timeInterval.timeValue(1).dateExpression()).longValue() : this.parseTimeFormat(timeInterval.timeValue(1).dateFormat().getText()));
        queryOp.setStartTime(startTime);
        queryOp.setEndTime(endTime);
        if (startTime >= endTime) {
            throw new SQLParserException("start time should be smaller than endTime in GroupBy");
        }
    }

    private void parseShowWhereClause(SqlBaseParser.ShowWhereClauseContext ctx, ShowTimeSeriesOperator operator) {
        SqlBaseParser.PropertyValueContext propertyValueContext;
        if (ctx.containsExpression() != null) {
            operator.setContains(true);
            propertyValueContext = ctx.containsExpression().propertyValue();
            operator.setKey(ctx.containsExpression().ID().getText());
        } else {
            operator.setContains(false);
            propertyValueContext = ctx.property().propertyValue();
            operator.setKey(ctx.property().ID().getText());
        }
        String value = propertyValueContext.stringLiteral() != null ? this.removeStringQuote(propertyValueContext.getText()) : propertyValueContext.getText();
        operator.setValue(value);
    }

    private String[] parsePrivilege(SqlBaseParser.PrivilegesContext ctx) {
        List privilegeList = ctx.stringLiteral();
        ArrayList<String> privileges = new ArrayList<String>();
        for (SqlBaseParser.StringLiteralContext privilege : privilegeList) {
            privileges.add(this.removeStringQuote(privilege.getText()));
        }
        return privileges.toArray(new String[0]);
    }

    private Pair<Long, Long> parseDeleteTimeInterval(DeleteDataOperator operator) {
        FilterOperator filterOperator = operator.getFilterOperator();
        if (!filterOperator.isLeaf() && filterOperator.getTokenIntType() != 1) {
            throw new SQLParserException(DELETE_RANGE_ERROR_MSG);
        }
        if (filterOperator.isLeaf()) {
            return this.calcOperatorInterval(filterOperator);
        }
        List<FilterOperator> children = filterOperator.getChildren();
        FilterOperator lOperator = children.get(0);
        FilterOperator rOperator = children.get(1);
        if (!lOperator.isLeaf() || !rOperator.isLeaf()) {
            throw new SQLParserException(DELETE_RANGE_ERROR_MSG);
        }
        Pair<Long, Long> leftOpInterval = this.calcOperatorInterval(lOperator);
        Pair<Long, Long> rightOpInterval = this.calcOperatorInterval(rOperator);
        Pair parsedInterval = new Pair((Object)Math.max((Long)leftOpInterval.left, (Long)rightOpInterval.left), (Object)Math.min((Long)leftOpInterval.right, (Long)rightOpInterval.right));
        if ((Long)parsedInterval.left > (Long)parsedInterval.right) {
            throw new SQLParserException("Invalid delete range: [" + parsedInterval.left + ", " + parsedInterval.right + "]");
        }
        return parsedInterval;
    }

    private Pair<Long, Long> calcOperatorInterval(FilterOperator filterOperator) {
        long time = Long.parseLong(((BasicFunctionOperator)filterOperator).getValue());
        switch (filterOperator.getTokenIntType()) {
            case 134: {
                return new Pair((Object)Long.MIN_VALUE, (Object)(time - 1L));
            }
            case 135: {
                return new Pair((Object)Long.MIN_VALUE, (Object)time);
            }
            case 132: {
                return new Pair((Object)(time + 1L), (Object)Long.MAX_VALUE);
            }
            case 133: {
                return new Pair((Object)time, (Object)Long.MAX_VALUE);
            }
            case 131: {
                return new Pair((Object)time, (Object)time);
            }
        }
        throw new SQLParserException(DELETE_RANGE_ERROR_MSG);
    }

    public Operator visitWhereClause(SqlBaseParser.WhereClauseContext ctx) {
        FilterOperator whereOp = new FilterOperator(23);
        whereOp.addChildOperator(this.parseOrExpression(ctx.orExpression()));
        return whereOp;
    }

    private FilterOperator parseOrExpression(SqlBaseParser.OrExpressionContext ctx) {
        if (ctx.andExpression().size() == 1) {
            return this.parseAndExpression(ctx.andExpression(0));
        }
        FilterOperator binaryOp = new FilterOperator(2);
        if (ctx.andExpression().size() > 2) {
            binaryOp.addChildOperator(this.parseAndExpression(ctx.andExpression(0)));
            binaryOp.addChildOperator(this.parseAndExpression(ctx.andExpression(1)));
            for (int i = 2; i < ctx.andExpression().size(); ++i) {
                FilterOperator op = new FilterOperator(2);
                op.addChildOperator(binaryOp);
                op.addChildOperator(this.parseAndExpression(ctx.andExpression(i)));
                binaryOp = op;
            }
        } else {
            for (SqlBaseParser.AndExpressionContext andExpressionContext : ctx.andExpression()) {
                binaryOp.addChildOperator(this.parseAndExpression(andExpressionContext));
            }
        }
        return binaryOp;
    }

    private FilterOperator parseAndExpression(SqlBaseParser.AndExpressionContext ctx) {
        if (ctx.predicate().size() == 1) {
            return this.parsePredicate(ctx.predicate(0));
        }
        FilterOperator binaryOp = new FilterOperator(1);
        int size = ctx.predicate().size();
        if (size > 2) {
            binaryOp.addChildOperator(this.parsePredicate(ctx.predicate(0)));
            binaryOp.addChildOperator(this.parsePredicate(ctx.predicate(1)));
            for (int i = 2; i < size; ++i) {
                FilterOperator op = new FilterOperator(1);
                op.addChildOperator(binaryOp);
                op.addChildOperator(this.parsePredicate(ctx.predicate(i)));
                binaryOp = op;
            }
        } else {
            for (SqlBaseParser.PredicateContext predicateContext : ctx.predicate()) {
                binaryOp.addChildOperator(this.parsePredicate(predicateContext));
            }
        }
        return binaryOp;
    }

    private FilterOperator parsePredicate(SqlBaseParser.PredicateContext ctx) {
        if (ctx.OPERATOR_NOT() != null) {
            FilterOperator notOp = new FilterOperator(3);
            notOp.addChildOperator(this.parseOrExpression(ctx.orExpression()));
            return notOp;
        }
        if (ctx.LR_BRACKET() != null && ctx.OPERATOR_NOT() == null) {
            return this.parseOrExpression(ctx.orExpression());
        }
        PartialPath path = null;
        if (ctx.TIME() != null || ctx.TIMESTAMP() != null) {
            path = new PartialPath(SQLConstant.getSingleTimeArray());
        }
        if (ctx.fullPath() != null) {
            path = this.parseFullPath(ctx.fullPath());
        }
        if (ctx.suffixPath() != null) {
            path = this.parseSuffixPath(ctx.suffixPath());
        }
        if (path == null) {
            throw new SQLParserException("Path is null, please check the sql.");
        }
        if (ctx.inClause() != null) {
            return this.parseInOperator(ctx.inClause(), path);
        }
        return this.parseBasicFunctionOperator(ctx, path);
    }

    private FilterOperator parseInOperator(SqlBaseParser.InClauseContext ctx, PartialPath path) {
        HashSet<String> values = new HashSet<String>();
        boolean not = ctx.OPERATOR_NOT() != null;
        for (SqlBaseParser.ConstantContext constant : ctx.constant()) {
            if (constant.dateExpression() != null) {
                if (!path.equals(SQLConstant.TIME_PATH)) {
                    throw new SQLParserException(path.getFullPath(), "Date can only be used to time");
                }
                values.add(Long.toString(this.parseDateExpression(constant.dateExpression())));
                continue;
            }
            values.add(constant.getText());
        }
        return new InOperator(ctx.OPERATOR_IN().getSymbol().getType(), path, not, values);
    }

    private FilterOperator parseBasicFunctionOperator(SqlBaseParser.PredicateContext ctx, PartialPath path) {
        BasicFunctionOperator basic;
        if (ctx.constant().dateExpression() != null) {
            if (!path.equals(SQLConstant.TIME_PATH)) {
                throw new SQLParserException(path.getFullPath(), "Date can only be used to time");
            }
            basic = new BasicFunctionOperator(ctx.comparisonOperator().type.getType(), path, Long.toString(this.parseDateExpression(ctx.constant().dateExpression())));
        } else {
            basic = new BasicFunctionOperator(ctx.comparisonOperator().type.getType(), path, ctx.constant().getText());
        }
        return basic;
    }

    private Long parseDateExpression(SqlBaseParser.DateExpressionContext ctx) {
        long time = this.parseTimeFormat(ctx.getChild(0).getText());
        for (int i = 1; i < ctx.getChildCount(); i += 2) {
            if (ctx.getChild(i).getText().equals("+")) {
                time += this.parseDuration(ctx.getChild(i + 1).getText()).longValue();
                continue;
            }
            time -= this.parseDuration(ctx.getChild(i + 1).getText()).longValue();
        }
        return time;
    }

    private Long parseDuration(String durationStr) {
        String timestampPrecision = IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision();
        long total = 0L;
        long tmp = 0L;
        for (int i = 0; i < durationStr.length(); ++i) {
            char ch = durationStr.charAt(i);
            if (Character.isDigit(ch)) {
                tmp *= 10L;
                tmp += (long)(ch - 48);
                continue;
            }
            String unit = durationStr.charAt(i) + "";
            if (i + 1 < durationStr.length() && !Character.isDigit(durationStr.charAt(i + 1))) {
                unit = unit + durationStr.charAt(++i);
            }
            total += DatetimeUtils.convertDurationStrToLong(tmp, unit.toLowerCase(), timestampPrecision);
            tmp = 0L;
        }
        if (total <= 0L) {
            throw new SQLParserException("Interval must more than 0.");
        }
        return total;
    }

    private void parseSetCol(SqlBaseParser.SetColContext ctx, SelectOperator selectOp, UpdateOperator updateOp) {
        selectOp.addSelectPath(this.parseSuffixPath(ctx.suffixPath()));
        updateOp.setValue(ctx.constant().getText());
    }

    private PartialPath parseSuffixPath(SqlBaseParser.SuffixPathContext ctx) {
        List nodeNames = ctx.nodeName();
        String[] path = new String[nodeNames.size()];
        for (int i = 0; i < nodeNames.size(); ++i) {
            path[i] = ((SqlBaseParser.NodeNameContext)nodeNames.get(i)).getText();
        }
        return new PartialPath(path);
    }

    private void parseInsertColumnSpec(SqlBaseParser.InsertColumnSpecContext ctx, InsertOperator insertOp) {
        List nodeNamesWithoutStar = ctx.nodeNameWithoutStar();
        ArrayList<String> measurementList = new ArrayList<String>();
        for (SqlBaseParser.NodeNameWithoutStarContext nodeNameWithoutStar : nodeNamesWithoutStar) {
            String measurement = nodeNameWithoutStar.getText();
            measurementList.add(measurement);
        }
        insertOp.setMeasurementList(measurementList.toArray(new String[0]));
    }

    private void parseInsertValuesSpec(SqlBaseParser.InsertValuesSpecContext ctx, InsertOperator insertOp) {
        long timestamp = ctx.dateFormat() != null ? this.parseTimeFormat(ctx.dateFormat().getText()) : Long.parseLong(ctx.INT().getText());
        insertOp.setTime(timestamp);
        ArrayList<String> valueList = new ArrayList<String>();
        List values = ctx.constant();
        for (SqlBaseParser.ConstantContext value : values) {
            valueList.add(value.getText());
        }
        insertOp.setValueList(valueList.toArray(new String[0]));
    }

    private void parseAlterClause(SqlBaseParser.AlterClauseContext ctx, AlterTimeSeriesOperator alterTimeSeriesOperator) {
        HashMap<String, String> alterMap = new HashMap<String, String>();
        if (ctx.RENAME() != null) {
            alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.RENAME);
            alterMap.put(ctx.beforeName.getText(), ctx.currentName.getText());
        } else if (ctx.SET() != null) {
            alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.SET);
            this.setMap(ctx, alterMap);
        } else if (ctx.DROP() != null) {
            alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.DROP);
            for (TerminalNode dropId : ctx.ID()) {
                alterMap.put(dropId.getText(), null);
            }
        } else if (ctx.TAGS() != null) {
            alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.ADD_TAGS);
            this.setMap(ctx, alterMap);
        } else if (ctx.ATTRIBUTES() != null) {
            alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.ADD_ATTRIBUTES);
            this.setMap(ctx, alterMap);
        } else {
            alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.UPSERT);
            if (ctx.aliasClause() != null) {
                this.parseAliasClause(ctx.aliasClause(), alterTimeSeriesOperator);
            }
            if (ctx.tagClause() != null) {
                this.parseTagClause(ctx.tagClause(), alterTimeSeriesOperator);
            }
            if (ctx.attributeClause() != null) {
                this.parseAttributeClause(ctx.attributeClause(), alterTimeSeriesOperator);
            }
        }
        alterTimeSeriesOperator.setAlterMap(alterMap);
    }

    public void parseAliasClause(SqlBaseParser.AliasClauseContext ctx, AlterTimeSeriesOperator alterTimeSeriesOperator) {
        if (alterTimeSeriesOperator != null && ctx.ID() != null) {
            alterTimeSeriesOperator.setAlias(ctx.ID().getText());
        }
    }

    private void setMap(SqlBaseParser.AlterClauseContext ctx, Map<String, String> alterMap) {
        List tagsList = ctx.property();
        if (ctx.property(0) != null) {
            for (SqlBaseParser.PropertyContext property : tagsList) {
                String value = property.propertyValue().stringLiteral() != null ? this.removeStringQuote(property.propertyValue().getText()) : property.propertyValue().getText();
                alterMap.put(property.ID().getText(), value);
            }
        }
    }

    private String removeStringQuote(String src) {
        if (src.charAt(0) == '\'' && src.charAt(src.length() - 1) == '\'') {
            return src.substring(1, src.length() - 1);
        }
        if (src.charAt(0) == '\"' && src.charAt(src.length() - 1) == '\"') {
            return src.substring(1, src.length() - 1);
        }
        throw new SQLParserException("error format for string with quote:" + src);
    }

    private PartialPath parsePrefixPath(SqlBaseParser.PrefixPathContext ctx) {
        List nodeNames = ctx.nodeName();
        String[] path = new String[nodeNames.size() + 1];
        path[0] = ctx.ROOT().getText();
        for (int i = 0; i < nodeNames.size(); ++i) {
            path[i + 1] = ((SqlBaseParser.NodeNameContext)nodeNames.get(i)).getText();
        }
        return new PartialPath(path);
    }

    public void parseAttributeClauses(SqlBaseParser.AttributeClausesContext ctx, CreateTimeSeriesOperator createTimeSeriesOperator) {
        String dataType = ctx.dataType().getChild(0).getText().toUpperCase();
        TSDataType tsDataType = TSDataType.valueOf((String)dataType);
        createTimeSeriesOperator.setDataType(tsDataType);
        IoTDBDescriptor ioTDBDescriptor = IoTDBDescriptor.getInstance();
        TSEncoding encoding = ioTDBDescriptor.getDefualtEncodingByType(tsDataType);
        if (Objects.nonNull(ctx.encoding())) {
            String encodingString = ctx.encoding().getChild(0).getText().toUpperCase();
            encoding = TSEncoding.valueOf((String)encodingString);
        }
        createTimeSeriesOperator.setEncoding(encoding);
        List properties = ctx.property();
        CompressionType compressor = ctx.compressor() != null ? CompressionType.valueOf((String)ctx.compressor().getText().toUpperCase()) : TSFileDescriptor.getInstance().getConfig().getCompressor();
        HashMap<String, String> props = null;
        if (ctx.property(0) != null) {
            props = new HashMap<String, String>(properties.size());
            for (SqlBaseParser.PropertyContext property : properties) {
                props.put(property.ID().getText().toLowerCase(), property.propertyValue().getText().toLowerCase());
            }
        }
        createTimeSeriesOperator.setCompressor(compressor);
        createTimeSeriesOperator.setProps(props);
        if (ctx.tagClause() != null) {
            this.parseTagClause(ctx.tagClause(), createTimeSeriesOperator);
        }
        if (ctx.attributeClause() != null) {
            this.parseAttributeClause(ctx.attributeClause(), createTimeSeriesOperator);
        }
    }

    public void parseAttributeClause(SqlBaseParser.AttributeClauseContext ctx, Operator operator) {
        Map<String, String> attributes = this.extractMap(ctx.property(), ctx.property(0));
        if (operator instanceof CreateTimeSeriesOperator) {
            ((CreateTimeSeriesOperator)operator).setAttributes(attributes);
        } else if (operator instanceof AlterTimeSeriesOperator) {
            ((AlterTimeSeriesOperator)operator).setAttributesMap(attributes);
        }
    }

    public void parseTagClause(SqlBaseParser.TagClauseContext ctx, Operator operator) {
        Map<String, String> tags = this.extractMap(ctx.property(), ctx.property(0));
        if (operator instanceof CreateTimeSeriesOperator) {
            ((CreateTimeSeriesOperator)operator).setTags(tags);
        } else if (operator instanceof AlterTimeSeriesOperator) {
            ((AlterTimeSeriesOperator)operator).setTagsMap(tags);
        }
    }

    private Map<String, String> extractMap(List<SqlBaseParser.PropertyContext> property2, SqlBaseParser.PropertyContext property3) {
        HashMap<String, String> tags = new HashMap<String, String>(property2.size());
        if (property3 != null) {
            for (SqlBaseParser.PropertyContext property : property2) {
                String value = property.propertyValue().stringLiteral() != null ? this.removeStringQuote(property.propertyValue().getText()) : property.propertyValue().getText();
                tags.put(property.ID().getText(), value);
            }
        }
        return tags;
    }

    private PartialPath parseFullPath(SqlBaseParser.FullPathContext ctx) {
        List nodeNamesWithoutStar = ctx.nodeNameWithoutStar();
        String[] path = new String[nodeNamesWithoutStar.size() + 1];
        int i = 0;
        if (ctx.ROOT() != null) {
            path[0] = ctx.ROOT().getText();
        }
        for (SqlBaseParser.NodeNameWithoutStarContext nodeNameWithoutStar : nodeNamesWithoutStar) {
            path[++i] = nodeNameWithoutStar.getText();
        }
        return new PartialPath(path);
    }

    public long parseTimeFormat(String timestampStr) throws SQLParserException {
        if (timestampStr == null || timestampStr.trim().equals("")) {
            throw new SQLParserException("input timestamp cannot be empty");
        }
        long startupNano = IoTDBDescriptor.getInstance().getConfig().getStartUpNanosecond();
        if (timestampStr.equalsIgnoreCase("now()")) {
            String timePrecision;
            switch (timePrecision = IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision()) {
                case "ns": {
                    return System.currentTimeMillis() * 1000000L + (System.nanoTime() - startupNano) % 1000000L;
                }
                case "us": {
                    return System.currentTimeMillis() * 1000L + (System.nanoTime() - startupNano) / 1000L % 1000L;
                }
            }
            return System.currentTimeMillis();
        }
        try {
            return DatetimeUtils.convertDatetimeStrToLong(timestampStr, this.zoneId);
        }
        catch (Exception e) {
            throw new SQLParserException(String.format("Input time format %s error. Input like yyyy-MM-dd HH:mm:ss, yyyy-MM-ddTHH:mm:ss or refer to user document for more info.", timestampStr));
        }
    }
}

