/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mqtt;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.mqtt.Message;
import org.apache.iotdb.db.mqtt.PayloadFormatter;

public class JSONPayloadFormatter
implements PayloadFormatter {
    private static final String JSON_KEY_DEVICE = "device";
    private static final String JSON_KEY_TIMESTAMP = "timestamp";
    private static final String JSON_KEY_TIMESTAMPS = "timestamps";
    private static final String JSON_KEY_MEASUREMENTS = "measurements";
    private static final String JSON_KEY_VALUES = "values";
    private static final Gson GSON = new GsonBuilder().create();

    @Override
    public List<Message> format(ByteBuf payload) {
        if (payload == null) {
            return null;
        }
        String txt = payload.toString(StandardCharsets.UTF_8);
        JsonObject jsonObject = (JsonObject)GSON.fromJson(txt, JsonObject.class);
        JsonElement timestamp = jsonObject.get(JSON_KEY_TIMESTAMP);
        if (timestamp != null) {
            return Lists.newArrayList((Object[])new Message[]{(Message)GSON.fromJson(txt, Message.class)});
        }
        String device = jsonObject.get(JSON_KEY_DEVICE).getAsString();
        JsonArray timestamps = jsonObject.getAsJsonArray(JSON_KEY_TIMESTAMPS);
        JsonArray measurements = jsonObject.getAsJsonArray(JSON_KEY_MEASUREMENTS);
        JsonArray values = jsonObject.getAsJsonArray(JSON_KEY_VALUES);
        ArrayList<Message> ret = new ArrayList<Message>();
        for (int i = 0; i < timestamps.size(); ++i) {
            Long ts = timestamps.get(i).getAsLong();
            Message message = new Message();
            message.setDevice(device);
            message.setTimestamp(ts);
            message.setMeasurements((List)GSON.fromJson((JsonElement)measurements, new TypeToken<List<String>>(){}.getType()));
            message.setValues((List)GSON.fromJson(values.get(i), new TypeToken<List<String>>(){}.getType()));
            ret.add(message);
        }
        return ret;
    }

    @Override
    public String getName() {
        return "json";
    }
}

