/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class MeasurementMeta {
    private MeasurementSchema measurementSchema = null;
    private String alias = null;
    private TimeValuePair timeValuePair = null;

    public MeasurementMeta(MeasurementSchema measurementSchema, String alias, TimeValuePair timeValuePair) {
        this.measurementSchema = measurementSchema;
        this.alias = alias;
        this.timeValuePair = timeValuePair;
    }

    public MeasurementMeta(MeasurementSchema measurementSchema, String alias) {
        this.measurementSchema = measurementSchema;
        this.alias = alias;
    }

    public MeasurementMeta(MeasurementSchema measurementSchema) {
        this.measurementSchema = measurementSchema;
    }

    public MeasurementSchema getMeasurementSchema() {
        return this.measurementSchema;
    }

    public void setMeasurementSchema(MeasurementSchema measurementSchema) {
        this.measurementSchema = measurementSchema;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public TimeValuePair getTimeValuePair() {
        return this.timeValuePair;
    }

    public synchronized void updateCachedLast(TimeValuePair timeValuePair, boolean highPriorityUpdate, Long latestFlushedTime) {
        if (timeValuePair == null || timeValuePair.getValue() == null) {
            return;
        }
        if (this.timeValuePair == null) {
            if (!highPriorityUpdate || latestFlushedTime <= timeValuePair.getTimestamp()) {
                this.timeValuePair = new TimeValuePair(timeValuePair.getTimestamp(), timeValuePair.getValue());
            }
        } else if (timeValuePair.getTimestamp() > this.timeValuePair.getTimestamp() || timeValuePair.getTimestamp() == this.timeValuePair.getTimestamp() && highPriorityUpdate) {
            this.timeValuePair.setTimestamp(timeValuePair.getTimestamp());
            this.timeValuePair.setValue(timeValuePair.getValue());
        }
    }
}

