/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.upgrade;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.concurrent.WrappedRunnable;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.upgrade.UpgradeCheckStatus;
import org.apache.iotdb.db.engine.upgrade.UpgradeLog;
import org.apache.iotdb.db.service.UpgradeSevice;
import org.apache.iotdb.db.tools.upgrade.TsFileOnlineUpgradeTool;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask
extends WrappedRunnable {
    private TsFileResource upgradeResource;
    private static final Logger logger = LoggerFactory.getLogger(UpgradeTask.class);
    private static final String COMMA_SEPERATOR = ",";
    private static final int maxLevelNum = IoTDBDescriptor.getInstance().getConfig().getSeqLevelNum();
    private FSFactory fsFactory = FSFactoryProducer.getFSFactory();

    public UpgradeTask(TsFileResource upgradeResource) {
        this.upgradeResource = upgradeResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runMayThrow() {
        try {
            List<TsFileResource> upgradedResources = this.generateUpgradedFiles();
            this.upgradeResource.writeLock();
            String oldTsfilePath = this.upgradeResource.getTsFile().getAbsolutePath();
            String oldModificationFilePath = oldTsfilePath + ".mods";
            try {
                this.upgradeResource.delete();
                File modificationFile = FSFactoryProducer.getFSFactory().getFile(oldModificationFilePath);
                for (TsFileResource upgradedResource : upgradedResources) {
                    File upgradedFile = upgradedResource.getTsFile();
                    long partition = upgradedResource.getTimePartition();
                    String storageGroupPath = upgradedFile.getParentFile().getParentFile().getParent();
                    File partitionDir = FSFactoryProducer.getFSFactory().getFile(storageGroupPath, partition + "");
                    if (!partitionDir.exists()) {
                        partitionDir.mkdir();
                    }
                    FSFactoryProducer.getFSFactory().moveFile(upgradedFile, FSFactoryProducer.getFSFactory().getFile(partitionDir, upgradedFile.getName()));
                    upgradedResource.setFile(FSFactoryProducer.getFSFactory().getFile(partitionDir, upgradedFile.getName()));
                    if (modificationFile.exists()) {
                        Files.copy(modificationFile.toPath(), FSFactoryProducer.getFSFactory().getFile(partitionDir, upgradedFile.getName() + ".mods").toPath(), new CopyOption[0]);
                    }
                    upgradedResource.serialize();
                    if (upgradedFile.getParentFile().isDirectory() && upgradedFile.getParentFile().listFiles().length == 0) {
                        Files.delete(upgradedFile.getParentFile().toPath());
                    }
                    upgradedFile = upgradedResource.getTsFile();
                    File zeroMergeVersionFile = this.getMaxMergeVersionFile(upgradedFile);
                    this.fsFactory.moveFile(upgradedFile, zeroMergeVersionFile);
                    this.fsFactory.moveFile(this.fsFactory.getFile(upgradedFile.getAbsolutePath() + ".resource"), this.fsFactory.getFile(zeroMergeVersionFile.getAbsolutePath() + ".resource"));
                    upgradedResource.setFile(upgradedFile);
                }
                if (modificationFile.exists()) {
                    Files.delete(modificationFile.toPath());
                }
                if (this.upgradeResource.getTsFile().getParentFile().isDirectory() && this.upgradeResource.getTsFile().getParentFile().listFiles().length == 0) {
                    Files.delete(this.upgradeResource.getTsFile().getParentFile().toPath());
                }
                this.upgradeResource.setUpgradedResources(upgradedResources);
                UpgradeLog.writeUpgradeLogFile(oldTsfilePath + COMMA_SEPERATOR + (Object)((Object)UpgradeCheckStatus.UPGRADE_SUCCESS));
                this.upgradeResource.getUpgradeTsFileResourceCallBack().call(this.upgradeResource);
            }
            finally {
                this.upgradeResource.writeUnlock();
            }
            UpgradeSevice.setCntUpgradeFileNum(UpgradeSevice.getCntUpgradeFileNum() - 1);
            logger.info("Upgrade completes, file path:{} , the remaining upgraded file num: {}", (Object)oldTsfilePath, (Object)UpgradeSevice.getCntUpgradeFileNum());
        }
        catch (Exception e) {
            logger.error("meet error when upgrade file:{}", (Object)this.upgradeResource.getTsFile().getAbsolutePath(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TsFileResource> generateUpgradedFiles() throws WriteProcessException {
        this.upgradeResource.readLock();
        String oldTsfilePath = this.upgradeResource.getTsFile().getAbsolutePath();
        ArrayList<TsFileResource> upgradedResources = new ArrayList<TsFileResource>();
        UpgradeLog.writeUpgradeLogFile(oldTsfilePath + COMMA_SEPERATOR + (Object)((Object)UpgradeCheckStatus.BEGIN_UPGRADE_FILE));
        try {
            TsFileOnlineUpgradeTool.upgradeOneTsfile(oldTsfilePath, upgradedResources);
            UpgradeLog.writeUpgradeLogFile(oldTsfilePath + COMMA_SEPERATOR + (Object)((Object)UpgradeCheckStatus.AFTER_UPGRADE_FILE));
        }
        catch (IOException e) {
            logger.error("generate upgrade file failed, the file to be upgraded:{}", (Object)oldTsfilePath, (Object)e);
        }
        finally {
            this.upgradeResource.readUnlock();
        }
        return upgradedResources;
    }

    private File getMaxMergeVersionFile(File seqFile) {
        String[] splits = seqFile.getName().replace(".tsfile", "").split("-");
        return this.fsFactory.getFile(seqFile.getParentFile(), splits[0] + "-" + splits[1] + "-" + (maxLevelNum - 1) + ".tsfile");
    }
}

