/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.memtable;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.engine.memtable.AbstractMemTable;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunk;
import org.apache.iotdb.db.engine.memtable.WritableMemChunk;
import org.apache.iotdb.db.rescon.TVListAllocator;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class PrimitiveMemTable
extends AbstractMemTable {
    public PrimitiveMemTable() {
    }

    public PrimitiveMemTable(boolean enableMemControl) {
        this.disableMemControl = !enableMemControl;
    }

    public PrimitiveMemTable(Map<String, Map<String, IWritableMemChunk>> memTableMap) {
        super(memTableMap);
    }

    @Override
    protected IWritableMemChunk genMemSeries(MeasurementSchema schema) {
        return new WritableMemChunk(schema, TVListAllocator.getInstance().allocate(schema.getType()));
    }

    @Override
    public IMemTable copy() {
        HashMap<String, Map<String, IWritableMemChunk>> newMap = new HashMap<String, Map<String, IWritableMemChunk>>(this.getMemTableMap());
        return new PrimitiveMemTable(newMap);
    }

    @Override
    public boolean isSignalMemTable() {
        return false;
    }

    public int hashCode() {
        return (int)this.getVersion();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }
}

