/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.iotdb.tsfile.encoding.encoder;

import static org.apache.iotdb.tsfile.common.conf.TSFileConfig.GORILLA_ENCODING_ENDING_FLOAT;

import java.io.ByteArrayOutputStream;

/**
 * <p> This class includes code modified from Michael Burman's gorilla-tsc project.
 *
 * <p> Copyright: 2016-2018 Michael Burman and/or other contributors
 * <p> Project page: https://github.com/burmanm/gorilla-tsc
 * <p> License: http://www.apache.org/licenses/LICENSE-2.0
 */
public class SinglePrecisionEncoderV2 extends IntGorillaEncoder {

  @Override
  public final void encode(float value, ByteArrayOutputStream out) {
    encode(Float.floatToRawIntBits(value), out);
  }

  @Override
  public void flush(ByteArrayOutputStream out) {
    // ending stream
    encode(GORILLA_ENCODING_ENDING_FLOAT, out);

    // flip the byte no matter it is empty or not
    // the empty ending byte is necessary when decoding
    bitsLeft = 0;
    flipByte(out);

    // the encoder may be reused, so let us reset it
    reset();
  }
}
