/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.v1.file.metadata;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.v1.file.metadata.ChunkMetadataV1;

public class ChunkGroupMetaDataV1 {
    private String deviceID;
    private long startOffsetOfChunkGroup;
    private long endOffsetOfChunkGroup;
    private List<ChunkMetadataV1> chunkMetaDataList = new ArrayList<ChunkMetadataV1>();
    private long version;

    private ChunkGroupMetaDataV1() {
    }

    public static ChunkGroupMetaDataV1 deserializeFrom(ByteBuffer buffer) {
        ChunkGroupMetaDataV1 chunkGroupMetaData = new ChunkGroupMetaDataV1();
        chunkGroupMetaData.deviceID = ReadWriteIOUtils.readString(buffer);
        chunkGroupMetaData.startOffsetOfChunkGroup = ReadWriteIOUtils.readLong(buffer);
        chunkGroupMetaData.endOffsetOfChunkGroup = ReadWriteIOUtils.readLong(buffer);
        chunkGroupMetaData.version = ReadWriteIOUtils.readLong(buffer);
        int size = ReadWriteIOUtils.readInt(buffer);
        ArrayList<ChunkMetadataV1> chunkMetaDataList = new ArrayList<ChunkMetadataV1>();
        for (int i = 0; i < size; ++i) {
            ChunkMetadataV1 metaData = ChunkMetadataV1.deserializeFrom(buffer);
            chunkMetaDataList.add(metaData);
        }
        chunkGroupMetaData.chunkMetaDataList = chunkMetaDataList;
        return chunkGroupMetaData;
    }

    public void addTimeSeriesChunkMetaData(ChunkMetadataV1 metadata) {
        if (this.chunkMetaDataList == null) {
            this.chunkMetaDataList = new ArrayList<ChunkMetadataV1>();
        }
        this.chunkMetaDataList.add(metadata);
    }

    public List<ChunkMetadataV1> getChunkMetaDataList() {
        return this.chunkMetaDataList;
    }

    public String getDeviceID() {
        return this.deviceID;
    }

    public long getStartOffsetOfChunkGroup() {
        return this.startOffsetOfChunkGroup;
    }

    public long getEndOffsetOfChunkGroup() {
        return this.endOffsetOfChunkGroup;
    }

    public long getVersion() {
        return this.version;
    }
}

