/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.reader.chunk;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.compress.IUnCompressor;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IChunkReader;
import org.apache.iotdb.tsfile.read.reader.IPageReader;
import org.apache.iotdb.tsfile.read.reader.page.PageReader;
import org.apache.iotdb.tsfile.v1.file.utils.HeaderUtils;

public class ChunkReader
implements IChunkReader {
    private ChunkHeader chunkHeader;
    private ByteBuffer chunkDataBuffer;
    private IUnCompressor unCompressor;
    private Decoder timeDecoder = Decoder.getDecoderByType(TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), TSDataType.INT64);
    protected Filter filter;
    private List<IPageReader> pageReaderList = new LinkedList<IPageReader>();
    private boolean isFromOldTsFile = false;
    private List<TimeRange> deleteIntervalList;

    public ChunkReader(Chunk chunk, Filter filter) throws IOException {
        this.filter = filter;
        this.chunkDataBuffer = chunk.getData();
        this.deleteIntervalList = chunk.getDeleteIntervalList();
        this.chunkHeader = chunk.getHeader();
        this.unCompressor = IUnCompressor.getUnCompressor(this.chunkHeader.getCompressionType());
        this.initAllPageReaders();
    }

    public ChunkReader(Chunk chunk, Filter filter, boolean isFromOldFile) throws IOException {
        this.filter = filter;
        this.chunkDataBuffer = chunk.getData();
        this.deleteIntervalList = chunk.getDeleteIntervalList();
        this.chunkHeader = chunk.getHeader();
        this.unCompressor = IUnCompressor.getUnCompressor(this.chunkHeader.getCompressionType());
        this.isFromOldTsFile = isFromOldFile;
        this.initAllPageReaders();
    }

    private void initAllPageReaders() throws IOException {
        while (this.chunkDataBuffer.remaining() > 0) {
            PageHeader pageHeader;
            PageHeader pageHeader2 = pageHeader = this.isFromOldTsFile ? HeaderUtils.deserializePageHeaderV1(this.chunkDataBuffer, this.chunkHeader.getDataType()) : PageHeader.deserializeFrom(this.chunkDataBuffer, this.chunkHeader.getDataType());
            if (this.pageSatisfied(pageHeader)) {
                this.pageReaderList.add(this.constructPageReaderForNextPage(pageHeader));
                continue;
            }
            this.skipBytesInStreamByLength(pageHeader.getCompressedSize());
        }
    }

    @Override
    public boolean hasNextSatisfiedPage() {
        return !this.pageReaderList.isEmpty();
    }

    @Override
    public BatchData nextPageData() throws IOException {
        if (this.pageReaderList.isEmpty()) {
            throw new IOException("No more page");
        }
        return this.pageReaderList.remove(0).getAllSatisfiedPageData();
    }

    private void skipBytesInStreamByLength(long length) {
        this.chunkDataBuffer.position(this.chunkDataBuffer.position() + (int)length);
    }

    public boolean pageSatisfied(PageHeader pageHeader) {
        if (this.deleteIntervalList != null) {
            for (TimeRange range : this.deleteIntervalList) {
                if (range.contains(pageHeader.getStartTime(), pageHeader.getEndTime())) {
                    return false;
                }
                if (!range.overlaps(new TimeRange(pageHeader.getStartTime(), pageHeader.getEndTime()))) continue;
                pageHeader.setModified(true);
            }
        }
        return this.filter == null || this.filter.satisfy(pageHeader.getStatistics());
    }

    private PageReader constructPageReaderForNextPage(PageHeader pageHeader) throws IOException {
        int compressedPageBodyLength = pageHeader.getCompressedSize();
        byte[] compressedPageBody = new byte[compressedPageBodyLength];
        if (compressedPageBodyLength > this.chunkDataBuffer.remaining()) {
            throw new IOException("do not has a complete page body. Expected:" + compressedPageBodyLength + ". Actual:" + this.chunkDataBuffer.remaining());
        }
        this.chunkDataBuffer.get(compressedPageBody);
        Decoder valueDecoder = Decoder.getDecoderByType(this.chunkHeader.getEncodingType(), this.chunkHeader.getDataType());
        byte[] uncompressedPageData = new byte[pageHeader.getUncompressedSize()];
        this.unCompressor.uncompress(compressedPageBody, 0, compressedPageBodyLength, uncompressedPageData, 0);
        ByteBuffer pageData = ByteBuffer.wrap(uncompressedPageData);
        PageReader reader = new PageReader(pageHeader, pageData, this.chunkHeader.getDataType(), valueDecoder, this.timeDecoder, this.filter);
        reader.setDeleteIntervalList(this.deleteIntervalList);
        return reader;
    }

    @Override
    public void close() {
    }

    public ChunkHeader getChunkHeader() {
        return this.chunkHeader;
    }

    @Override
    public List<IPageReader> loadPageReaderList() {
        return this.pageReaderList;
    }
}

