/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.iotdb.tsfile.common.cache.LRUCache;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.controller.IMetadataQuerier;

public class MetadataQuerierByFileImpl
implements IMetadataQuerier {
    private static final int CACHED_ENTRY_NUMBER = 1000;
    private TsFileMetadata fileMetaData;
    private LRUCache<Path, List<ChunkMetadata>> chunkMetaDataCache;
    private TsFileSequenceReader tsFileReader;

    public MetadataQuerierByFileImpl(TsFileSequenceReader tsFileReader) throws IOException {
        this.tsFileReader = tsFileReader;
        this.fileMetaData = tsFileReader.readFileMetadata();
        this.chunkMetaDataCache = new LRUCache<Path, List<ChunkMetadata>>(1000){

            @Override
            public List<ChunkMetadata> loadObjectByKey(Path key) throws IOException {
                return MetadataQuerierByFileImpl.this.loadChunkMetadata(key);
            }
        };
    }

    @Override
    public List<ChunkMetadata> getChunkMetaDataList(Path path) throws IOException {
        return this.chunkMetaDataCache.get(path);
    }

    @Override
    public Map<Path, List<ChunkMetadata>> getChunkMetaDataMap(List<Path> paths) throws IOException {
        HashMap<Path, List<ChunkMetadata>> chunkMetaDatas = new HashMap<Path, List<ChunkMetadata>>();
        for (Path path : paths) {
            if (!chunkMetaDatas.containsKey(path)) {
                chunkMetaDatas.put(path, new ArrayList());
            }
            ((List)chunkMetaDatas.get(path)).addAll(this.getChunkMetaDataList(path));
        }
        return chunkMetaDatas;
    }

    @Override
    public TsFileMetadata getWholeFileMetadata() {
        return this.fileMetaData;
    }

    @Override
    public void loadChunkMetaDatas(List<Path> paths) throws IOException {
        TreeMap deviceMeasurementsMap = new TreeMap();
        for (Path path : paths) {
            if (!deviceMeasurementsMap.containsKey(path.getDevice())) {
                deviceMeasurementsMap.put(path.getDevice(), new HashSet());
            }
            ((Set)deviceMeasurementsMap.get(path.getDevice())).add(path.getMeasurement());
        }
        HashMap tempChunkMetaDatas = new HashMap();
        int count = 0;
        boolean enough = false;
        block1: for (Map.Entry deviceMeasurements : deviceMeasurementsMap.entrySet()) {
            if (enough) break;
            String selectedDevice = (String)deviceMeasurements.getKey();
            Set selectedMeasurements = (Set)deviceMeasurements.getValue();
            List<String> devices = this.tsFileReader.getAllDevices();
            Object[] deviceNames = devices.toArray(new String[devices.size()]);
            if (Arrays.binarySearch(deviceNames, selectedDevice) < 0) continue;
            List<TimeseriesMetadata> timeseriesMetaDataList = this.tsFileReader.readTimeseriesMetadata(selectedDevice, selectedMeasurements);
            ArrayList<ChunkMetadata> chunkMetadataList = new ArrayList<ChunkMetadata>();
            for (TimeseriesMetadata timeseriesMetadata : timeseriesMetaDataList) {
                chunkMetadataList.addAll(this.tsFileReader.readChunkMetaDataList(timeseriesMetadata));
            }
            for (ChunkMetadata chunkMetaData : chunkMetadataList) {
                String currentMeasurement = chunkMetaData.getMeasurementUid();
                if (!selectedMeasurements.contains(currentMeasurement)) continue;
                Path path = new Path(selectedDevice, currentMeasurement);
                if (!tempChunkMetaDatas.containsKey(path)) {
                    tempChunkMetaDatas.put(path, new ArrayList());
                }
                ((List)tempChunkMetaDatas.get(path)).add(chunkMetaData);
                if (++count != 1000) continue;
                enough = true;
                continue block1;
            }
        }
        for (Map.Entry entry : tempChunkMetaDatas.entrySet()) {
            this.chunkMetaDataCache.put((Path)entry.getKey(), (List<ChunkMetadata>)entry.getValue());
        }
    }

    @Override
    public TSDataType getDataType(Path path) throws IOException {
        if (this.tsFileReader.getChunkMetadataList(path) == null || this.tsFileReader.getChunkMetadataList(path).isEmpty()) {
            return null;
        }
        return this.tsFileReader.getChunkMetadataList(path).get(0).getDataType();
    }

    private List<ChunkMetadata> loadChunkMetadata(Path path) throws IOException {
        return this.tsFileReader.getChunkMetadataList(path);
    }

    @Override
    public List<TimeRange> convertSpace2TimePartition(List<Path> paths, long spacePartitionStartPos, long spacePartitionEndPos) throws IOException {
        if (spacePartitionStartPos > spacePartitionEndPos) {
            throw new IllegalArgumentException("'spacePartitionStartPos' should not be larger than 'spacePartitionEndPos'.");
        }
        ArrayList<TimeRange> timeRangesInCandidates = new ArrayList<TimeRange>();
        ArrayList<TimeRange> timeRangesBeforeCandidates = new ArrayList<TimeRange>();
        TreeMap<String, Set> deviceMeasurementsMap = new TreeMap<String, Set>();
        for (Path path : paths) {
            deviceMeasurementsMap.computeIfAbsent(path.getDevice(), key -> new HashSet()).add(path.getMeasurement());
        }
        for (Map.Entry entry : deviceMeasurementsMap.entrySet()) {
            String selectedDevice = (String)entry.getKey();
            Set selectedMeasurements = (Set)entry.getValue();
            Map<String, List<ChunkMetadata>> seriesMetadatas = this.tsFileReader.readChunkMetadataInDevice(selectedDevice);
            for (Map.Entry<String, List<ChunkMetadata>> seriesMetadata : seriesMetadatas.entrySet()) {
                ChunkMetadata chunkMetadata;
                TsFileSequenceReader.LocateStatus location;
                if (!selectedMeasurements.contains(seriesMetadata.getKey())) continue;
                Iterator<ChunkMetadata> iterator = seriesMetadata.getValue().iterator();
                while (iterator.hasNext() && (location = MetadataQuerierByFileImpl.checkLocateStatus(chunkMetadata = iterator.next(), spacePartitionStartPos, spacePartitionEndPos)) != TsFileSequenceReader.LocateStatus.after) {
                    if (location == TsFileSequenceReader.LocateStatus.in) {
                        timeRangesInCandidates.add(new TimeRange(chunkMetadata.getStartTime(), chunkMetadata.getEndTime()));
                        continue;
                    }
                    timeRangesBeforeCandidates.add(new TimeRange(chunkMetadata.getStartTime(), chunkMetadata.getEndTime()));
                }
            }
        }
        ArrayList<TimeRange> timeRangesIn = new ArrayList<TimeRange>(TimeRange.sortAndMerge(timeRangesInCandidates));
        if (timeRangesIn.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TimeRange> arrayList = new ArrayList<TimeRange>(TimeRange.sortAndMerge(timeRangesBeforeCandidates));
        ArrayList<TimeRange> resTimeRanges = new ArrayList<TimeRange>();
        for (TimeRange in : timeRangesIn) {
            ArrayList<TimeRange> remains = new ArrayList<TimeRange>(in.getRemains(arrayList));
            resTimeRanges.addAll(remains);
        }
        return resTimeRanges;
    }

    public static TsFileSequenceReader.LocateStatus checkLocateStatus(ChunkMetadata chunkMetaData, long spacePartitionStartPos, long spacePartitionEndPos) {
        long startOffsetOfChunk = chunkMetaData.getOffsetOfChunkHeader();
        if (spacePartitionStartPos <= startOffsetOfChunk && startOffsetOfChunk < spacePartitionEndPos) {
            return TsFileSequenceReader.LocateStatus.in;
        }
        if (startOffsetOfChunk < spacePartitionStartPos) {
            return TsFileSequenceReader.LocateStatus.before;
        }
        return TsFileSequenceReader.LocateStatus.after;
    }

    @Override
    public void clear() {
        this.chunkMetaDataCache.clear();
    }
}

