/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.series;

import java.io.IOException;
import java.util.Set;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.series.IAggregateReader;
import org.apache.iotdb.db.query.reader.series.SeriesReader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class SeriesAggregateReader
implements IAggregateReader {
    private final SeriesReader seriesReader;

    public SeriesAggregateReader(PartialPath seriesPath, Set<String> allSensors, TSDataType dataType, QueryContext context, QueryDataSource dataSource, Filter timeFilter, Filter valueFilter, TsFileFilter fileFilter, boolean ascending) {
        this.seriesReader = new SeriesReader(seriesPath, allSensors, dataType, context, dataSource, timeFilter, valueFilter, fileFilter, ascending);
    }

    @Override
    public boolean isAscending() {
        return this.seriesReader.getOrderUtils().getAscending();
    }

    @Override
    public boolean hasNextFile() throws IOException {
        return this.seriesReader.hasNextFile();
    }

    @Override
    public boolean canUseCurrentFileStatistics() throws IOException {
        Statistics fileStatistics = this.currentFileStatistics();
        return !this.seriesReader.isFileOverlapped() && this.containedByTimeFilter(fileStatistics) && !this.seriesReader.currentFileModified();
    }

    @Override
    public Statistics currentFileStatistics() throws IOException {
        return this.seriesReader.currentFileStatistics();
    }

    @Override
    public void skipCurrentFile() {
        this.seriesReader.skipCurrentFile();
    }

    @Override
    public boolean hasNextChunk() throws IOException {
        return this.seriesReader.hasNextChunk();
    }

    @Override
    public boolean canUseCurrentChunkStatistics() throws IOException {
        Statistics chunkStatistics = this.currentChunkStatistics();
        return !this.seriesReader.isChunkOverlapped() && this.containedByTimeFilter(chunkStatistics) && !this.seriesReader.currentChunkModified();
    }

    @Override
    public Statistics currentChunkStatistics() {
        return this.seriesReader.currentChunkStatistics();
    }

    @Override
    public void skipCurrentChunk() {
        this.seriesReader.skipCurrentChunk();
    }

    @Override
    public boolean hasNextPage() throws IOException {
        return this.seriesReader.hasNextPage();
    }

    @Override
    public boolean canUseCurrentPageStatistics() throws IOException {
        Statistics currentPageStatistics = this.currentPageStatistics();
        if (currentPageStatistics == null) {
            return false;
        }
        return !this.seriesReader.isPageOverlapped() && this.containedByTimeFilter(currentPageStatistics) && !this.seriesReader.currentPageModified();
    }

    @Override
    public Statistics currentPageStatistics() {
        return this.seriesReader.currentPageStatistics();
    }

    @Override
    public void skipCurrentPage() {
        this.seriesReader.skipCurrentPage();
    }

    @Override
    public BatchData nextPage() throws IOException {
        return this.seriesReader.nextPage().flip();
    }

    private boolean containedByTimeFilter(Statistics statistics) {
        Filter timeFilter = this.seriesReader.getTimeFilter();
        return timeFilter == null || timeFilter.containStartEndTime(statistics.getStartTime(), statistics.getEndTime());
    }
}

